// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigatewayv2;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class RouteResponseArgs extends com.pulumi.resources.ResourceArgs {

    public static final RouteResponseArgs Empty = new RouteResponseArgs();

    /**
     * API identifier.
     * 
     */
    @Import(name="apiId", required=true)
    private Output<String> apiId;

    /**
     * @return API identifier.
     * 
     */
    public Output<String> apiId() {
        return this.apiId;
    }

    /**
     * The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route response.
     * 
     */
    @Import(name="modelSelectionExpression")
    private @Nullable Output<String> modelSelectionExpression;

    /**
     * @return The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route response.
     * 
     */
    public Optional<Output<String>> modelSelectionExpression() {
        return Optional.ofNullable(this.modelSelectionExpression);
    }

    /**
     * Response models for the route response.
     * 
     */
    @Import(name="responseModels")
    private @Nullable Output<Map<String,String>> responseModels;

    /**
     * @return Response models for the route response.
     * 
     */
    public Optional<Output<Map<String,String>>> responseModels() {
        return Optional.ofNullable(this.responseModels);
    }

    /**
     * Identifier of the `aws.apigatewayv2.Route`.
     * 
     */
    @Import(name="routeId", required=true)
    private Output<String> routeId;

    /**
     * @return Identifier of the `aws.apigatewayv2.Route`.
     * 
     */
    public Output<String> routeId() {
        return this.routeId;
    }

    /**
     * Route response key.
     * 
     */
    @Import(name="routeResponseKey", required=true)
    private Output<String> routeResponseKey;

    /**
     * @return Route response key.
     * 
     */
    public Output<String> routeResponseKey() {
        return this.routeResponseKey;
    }

    private RouteResponseArgs() {}

    private RouteResponseArgs(RouteResponseArgs $) {
        this.apiId = $.apiId;
        this.modelSelectionExpression = $.modelSelectionExpression;
        this.responseModels = $.responseModels;
        this.routeId = $.routeId;
        this.routeResponseKey = $.routeResponseKey;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(RouteResponseArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private RouteResponseArgs $;

        public Builder() {
            $ = new RouteResponseArgs();
        }

        public Builder(RouteResponseArgs defaults) {
            $ = new RouteResponseArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param apiId API identifier.
         * 
         * @return builder
         * 
         */
        public Builder apiId(Output<String> apiId) {
            $.apiId = apiId;
            return this;
        }

        /**
         * @param apiId API identifier.
         * 
         * @return builder
         * 
         */
        public Builder apiId(String apiId) {
            return apiId(Output.of(apiId));
        }

        /**
         * @param modelSelectionExpression The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route response.
         * 
         * @return builder
         * 
         */
        public Builder modelSelectionExpression(@Nullable Output<String> modelSelectionExpression) {
            $.modelSelectionExpression = modelSelectionExpression;
            return this;
        }

        /**
         * @param modelSelectionExpression The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route response.
         * 
         * @return builder
         * 
         */
        public Builder modelSelectionExpression(String modelSelectionExpression) {
            return modelSelectionExpression(Output.of(modelSelectionExpression));
        }

        /**
         * @param responseModels Response models for the route response.
         * 
         * @return builder
         * 
         */
        public Builder responseModels(@Nullable Output<Map<String,String>> responseModels) {
            $.responseModels = responseModels;
            return this;
        }

        /**
         * @param responseModels Response models for the route response.
         * 
         * @return builder
         * 
         */
        public Builder responseModels(Map<String,String> responseModels) {
            return responseModels(Output.of(responseModels));
        }

        /**
         * @param routeId Identifier of the `aws.apigatewayv2.Route`.
         * 
         * @return builder
         * 
         */
        public Builder routeId(Output<String> routeId) {
            $.routeId = routeId;
            return this;
        }

        /**
         * @param routeId Identifier of the `aws.apigatewayv2.Route`.
         * 
         * @return builder
         * 
         */
        public Builder routeId(String routeId) {
            return routeId(Output.of(routeId));
        }

        /**
         * @param routeResponseKey Route response key.
         * 
         * @return builder
         * 
         */
        public Builder routeResponseKey(Output<String> routeResponseKey) {
            $.routeResponseKey = routeResponseKey;
            return this;
        }

        /**
         * @param routeResponseKey Route response key.
         * 
         * @return builder
         * 
         */
        public Builder routeResponseKey(String routeResponseKey) {
            return routeResponseKey(Output.of(routeResponseKey));
        }

        public RouteResponseArgs build() {
            $.apiId = Objects.requireNonNull($.apiId, "expected parameter 'apiId' to be non-null");
            $.routeId = Objects.requireNonNull($.routeId, "expected parameter 'routeId' to be non-null");
            $.routeResponseKey = Objects.requireNonNull($.routeResponseKey, "expected parameter 'routeResponseKey' to be non-null");
            return $;
        }
    }

}
