// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigateway.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@CustomType
public final class RestApiEndpointConfiguration {
    /**
     * @return List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE`, `REGIONAL` or `PRIVATE`. If unspecified, defaults to `EDGE`. If set to `PRIVATE` recommend to set `put_rest_api_mode` = `merge` to not cause the endpoints and associated Route53 records to be deleted. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
     * 
     */
    private String types;
    /**
     * @return Set of VPC Endpoint identifiers. It is only supported for `PRIVATE` endpoint type. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-endpoint-configuration` extension `vpcEndpointIds` property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-endpoint-configuration.html). If the argument value is provided and is different than the OpenAPI value, **the argument value will override the OpenAPI value**.
     * 
     */
    private @Nullable List<String> vpcEndpointIds;

    private RestApiEndpointConfiguration() {}
    /**
     * @return List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE`, `REGIONAL` or `PRIVATE`. If unspecified, defaults to `EDGE`. If set to `PRIVATE` recommend to set `put_rest_api_mode` = `merge` to not cause the endpoints and associated Route53 records to be deleted. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
     * 
     */
    public String types() {
        return this.types;
    }
    /**
     * @return Set of VPC Endpoint identifiers. It is only supported for `PRIVATE` endpoint type. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-endpoint-configuration` extension `vpcEndpointIds` property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-endpoint-configuration.html). If the argument value is provided and is different than the OpenAPI value, **the argument value will override the OpenAPI value**.
     * 
     */
    public List<String> vpcEndpointIds() {
        return this.vpcEndpointIds == null ? List.of() : this.vpcEndpointIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RestApiEndpointConfiguration defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private String types;
        private @Nullable List<String> vpcEndpointIds;
        public Builder() {}
        public Builder(RestApiEndpointConfiguration defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.types = defaults.types;
    	      this.vpcEndpointIds = defaults.vpcEndpointIds;
        }

        @CustomType.Setter
        public Builder types(String types) {
            this.types = Objects.requireNonNull(types);
            return this;
        }
        @CustomType.Setter
        public Builder vpcEndpointIds(@Nullable List<String> vpcEndpointIds) {
            this.vpcEndpointIds = vpcEndpointIds;
            return this;
        }
        public Builder vpcEndpointIds(String... vpcEndpointIds) {
            return vpcEndpointIds(List.of(vpcEndpointIds));
        }
        public RestApiEndpointConfiguration build() {
            final var o = new RestApiEndpointConfiguration();
            o.types = types;
            o.vpcEndpointIds = vpcEndpointIds;
            return o;
        }
    }
}
