// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigateway.inputs;

import com.pulumi.aws.apigateway.inputs.IntegrationTlsConfigArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class IntegrationState extends com.pulumi.resources.ResourceArgs {

    public static final IntegrationState Empty = new IntegrationState();

    /**
     * List of cache key parameters for the integration.
     * 
     */
    @Import(name="cacheKeyParameters")
    private @Nullable Output<List<String>> cacheKeyParameters;

    /**
     * @return List of cache key parameters for the integration.
     * 
     */
    public Optional<Output<List<String>>> cacheKeyParameters() {
        return Optional.ofNullable(this.cacheKeyParameters);
    }

    /**
     * Integration&#39;s cache namespace.
     * 
     */
    @Import(name="cacheNamespace")
    private @Nullable Output<String> cacheNamespace;

    /**
     * @return Integration&#39;s cache namespace.
     * 
     */
    public Optional<Output<String>> cacheNamespace() {
        return Optional.ofNullable(this.cacheNamespace);
    }

    /**
     * ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
     * 
     */
    @Import(name="connectionId")
    private @Nullable Output<String> connectionId;

    /**
     * @return ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
     * 
     */
    public Optional<Output<String>> connectionId() {
        return Optional.ofNullable(this.connectionId);
    }

    /**
     * Integration input&#39;s [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
     * 
     */
    @Import(name="connectionType")
    private @Nullable Output<String> connectionType;

    /**
     * @return Integration input&#39;s [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
     * 
     */
    public Optional<Output<String>> connectionType() {
        return Optional.ofNullable(this.connectionType);
    }

    /**
     * How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
     * 
     */
    @Import(name="contentHandling")
    private @Nullable Output<String> contentHandling;

    /**
     * @return How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
     * 
     */
    public Optional<Output<String>> contentHandling() {
        return Optional.ofNullable(this.contentHandling);
    }

    /**
     * Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role&#39;s ARN. To require that the caller&#39;s identity be passed through from the request, specify the string `arn:aws:iam::\*:user/\*`.
     * 
     */
    @Import(name="credentials")
    private @Nullable Output<String> credentials;

    /**
     * @return Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role&#39;s ARN. To require that the caller&#39;s identity be passed through from the request, specify the string `arn:aws:iam::\*:user/\*`.
     * 
     */
    public Optional<Output<String>> credentials() {
        return Optional.ofNullable(this.credentials);
    }

    /**
     * HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
     * when calling the associated resource.
     * 
     */
    @Import(name="httpMethod")
    private @Nullable Output<String> httpMethod;

    /**
     * @return HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
     * when calling the associated resource.
     * 
     */
    public Optional<Output<String>> httpMethod() {
        return Optional.ofNullable(this.httpMethod);
    }

    /**
     * Integration HTTP method
     * (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
     * **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
     * Not all methods are compatible with all `AWS` integrations.
     * e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
     * 
     */
    @Import(name="integrationHttpMethod")
    private @Nullable Output<String> integrationHttpMethod;

    /**
     * @return Integration HTTP method
     * (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
     * **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
     * Not all methods are compatible with all `AWS` integrations.
     * e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
     * 
     */
    public Optional<Output<String>> integrationHttpMethod() {
        return Optional.ofNullable(this.integrationHttpMethod);
    }

    /**
     * Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
     * 
     */
    @Import(name="passthroughBehavior")
    private @Nullable Output<String> passthroughBehavior;

    /**
     * @return Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
     * 
     */
    public Optional<Output<String>> passthroughBehavior() {
        return Optional.ofNullable(this.passthroughBehavior);
    }

    /**
     * Map of request query string parameters and headers that should be passed to the backend responder.
     * For example: `request_parameters = { &#34;integration.request.header.X-Some-Other-Header&#34; = &#34;method.request.header.X-Some-Header&#34; }`
     * 
     */
    @Import(name="requestParameters")
    private @Nullable Output<Map<String,String>> requestParameters;

    /**
     * @return Map of request query string parameters and headers that should be passed to the backend responder.
     * For example: `request_parameters = { &#34;integration.request.header.X-Some-Other-Header&#34; = &#34;method.request.header.X-Some-Header&#34; }`
     * 
     */
    public Optional<Output<Map<String,String>>> requestParameters() {
        return Optional.ofNullable(this.requestParameters);
    }

    /**
     * Map of the integration&#39;s request templates.
     * 
     */
    @Import(name="requestTemplates")
    private @Nullable Output<Map<String,String>> requestTemplates;

    /**
     * @return Map of the integration&#39;s request templates.
     * 
     */
    public Optional<Output<Map<String,String>>> requestTemplates() {
        return Optional.ofNullable(this.requestTemplates);
    }

    /**
     * API resource ID.
     * 
     */
    @Import(name="resourceId")
    private @Nullable Output<String> resourceId;

    /**
     * @return API resource ID.
     * 
     */
    public Optional<Output<String>> resourceId() {
        return Optional.ofNullable(this.resourceId);
    }

    /**
     * ID of the associated REST API.
     * 
     */
    @Import(name="restApi")
    private @Nullable Output<String> restApi;

    /**
     * @return ID of the associated REST API.
     * 
     */
    public Optional<Output<String>> restApi() {
        return Optional.ofNullable(this.restApi);
    }

    /**
     * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds.
     * 
     */
    @Import(name="timeoutMilliseconds")
    private @Nullable Output<Integer> timeoutMilliseconds;

    /**
     * @return Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds.
     * 
     */
    public Optional<Output<Integer>> timeoutMilliseconds() {
        return Optional.ofNullable(this.timeoutMilliseconds);
    }

    /**
     * TLS configuration. See below.
     * 
     */
    @Import(name="tlsConfig")
    private @Nullable Output<IntegrationTlsConfigArgs> tlsConfig;

    /**
     * @return TLS configuration. See below.
     * 
     */
    public Optional<Output<IntegrationTlsConfigArgs>> tlsConfig() {
        return Optional.ofNullable(this.tlsConfig);
    }

    /**
     * Integration input&#39;s [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
     * 
     */
    @Import(name="type")
    private @Nullable Output<String> type;

    /**
     * @return Integration input&#39;s [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
     * 
     */
    public Optional<Output<String>> type() {
        return Optional.ofNullable(this.type);
    }

    /**
     * Input&#39;s URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
     * For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
     * e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:012345678901:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
     * 
     */
    @Import(name="uri")
    private @Nullable Output<String> uri;

    /**
     * @return Input&#39;s URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
     * For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
     * e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:012345678901:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
     * 
     */
    public Optional<Output<String>> uri() {
        return Optional.ofNullable(this.uri);
    }

    private IntegrationState() {}

    private IntegrationState(IntegrationState $) {
        this.cacheKeyParameters = $.cacheKeyParameters;
        this.cacheNamespace = $.cacheNamespace;
        this.connectionId = $.connectionId;
        this.connectionType = $.connectionType;
        this.contentHandling = $.contentHandling;
        this.credentials = $.credentials;
        this.httpMethod = $.httpMethod;
        this.integrationHttpMethod = $.integrationHttpMethod;
        this.passthroughBehavior = $.passthroughBehavior;
        this.requestParameters = $.requestParameters;
        this.requestTemplates = $.requestTemplates;
        this.resourceId = $.resourceId;
        this.restApi = $.restApi;
        this.timeoutMilliseconds = $.timeoutMilliseconds;
        this.tlsConfig = $.tlsConfig;
        this.type = $.type;
        this.uri = $.uri;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(IntegrationState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private IntegrationState $;

        public Builder() {
            $ = new IntegrationState();
        }

        public Builder(IntegrationState defaults) {
            $ = new IntegrationState(Objects.requireNonNull(defaults));
        }

        /**
         * @param cacheKeyParameters List of cache key parameters for the integration.
         * 
         * @return builder
         * 
         */
        public Builder cacheKeyParameters(@Nullable Output<List<String>> cacheKeyParameters) {
            $.cacheKeyParameters = cacheKeyParameters;
            return this;
        }

        /**
         * @param cacheKeyParameters List of cache key parameters for the integration.
         * 
         * @return builder
         * 
         */
        public Builder cacheKeyParameters(List<String> cacheKeyParameters) {
            return cacheKeyParameters(Output.of(cacheKeyParameters));
        }

        /**
         * @param cacheKeyParameters List of cache key parameters for the integration.
         * 
         * @return builder
         * 
         */
        public Builder cacheKeyParameters(String... cacheKeyParameters) {
            return cacheKeyParameters(List.of(cacheKeyParameters));
        }

        /**
         * @param cacheNamespace Integration&#39;s cache namespace.
         * 
         * @return builder
         * 
         */
        public Builder cacheNamespace(@Nullable Output<String> cacheNamespace) {
            $.cacheNamespace = cacheNamespace;
            return this;
        }

        /**
         * @param cacheNamespace Integration&#39;s cache namespace.
         * 
         * @return builder
         * 
         */
        public Builder cacheNamespace(String cacheNamespace) {
            return cacheNamespace(Output.of(cacheNamespace));
        }

        /**
         * @param connectionId ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
         * 
         * @return builder
         * 
         */
        public Builder connectionId(@Nullable Output<String> connectionId) {
            $.connectionId = connectionId;
            return this;
        }

        /**
         * @param connectionId ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
         * 
         * @return builder
         * 
         */
        public Builder connectionId(String connectionId) {
            return connectionId(Output.of(connectionId));
        }

        /**
         * @param connectionType Integration input&#39;s [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
         * 
         * @return builder
         * 
         */
        public Builder connectionType(@Nullable Output<String> connectionType) {
            $.connectionType = connectionType;
            return this;
        }

        /**
         * @param connectionType Integration input&#39;s [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
         * 
         * @return builder
         * 
         */
        public Builder connectionType(String connectionType) {
            return connectionType(Output.of(connectionType));
        }

        /**
         * @param contentHandling How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
         * 
         * @return builder
         * 
         */
        public Builder contentHandling(@Nullable Output<String> contentHandling) {
            $.contentHandling = contentHandling;
            return this;
        }

        /**
         * @param contentHandling How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
         * 
         * @return builder
         * 
         */
        public Builder contentHandling(String contentHandling) {
            return contentHandling(Output.of(contentHandling));
        }

        /**
         * @param credentials Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role&#39;s ARN. To require that the caller&#39;s identity be passed through from the request, specify the string `arn:aws:iam::\*:user/\*`.
         * 
         * @return builder
         * 
         */
        public Builder credentials(@Nullable Output<String> credentials) {
            $.credentials = credentials;
            return this;
        }

        /**
         * @param credentials Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role&#39;s ARN. To require that the caller&#39;s identity be passed through from the request, specify the string `arn:aws:iam::\*:user/\*`.
         * 
         * @return builder
         * 
         */
        public Builder credentials(String credentials) {
            return credentials(Output.of(credentials));
        }

        /**
         * @param httpMethod HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
         * when calling the associated resource.
         * 
         * @return builder
         * 
         */
        public Builder httpMethod(@Nullable Output<String> httpMethod) {
            $.httpMethod = httpMethod;
            return this;
        }

        /**
         * @param httpMethod HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
         * when calling the associated resource.
         * 
         * @return builder
         * 
         */
        public Builder httpMethod(String httpMethod) {
            return httpMethod(Output.of(httpMethod));
        }

        /**
         * @param integrationHttpMethod Integration HTTP method
         * (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
         * **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
         * Not all methods are compatible with all `AWS` integrations.
         * e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
         * 
         * @return builder
         * 
         */
        public Builder integrationHttpMethod(@Nullable Output<String> integrationHttpMethod) {
            $.integrationHttpMethod = integrationHttpMethod;
            return this;
        }

        /**
         * @param integrationHttpMethod Integration HTTP method
         * (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
         * **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
         * Not all methods are compatible with all `AWS` integrations.
         * e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
         * 
         * @return builder
         * 
         */
        public Builder integrationHttpMethod(String integrationHttpMethod) {
            return integrationHttpMethod(Output.of(integrationHttpMethod));
        }

        /**
         * @param passthroughBehavior Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
         * 
         * @return builder
         * 
         */
        public Builder passthroughBehavior(@Nullable Output<String> passthroughBehavior) {
            $.passthroughBehavior = passthroughBehavior;
            return this;
        }

        /**
         * @param passthroughBehavior Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
         * 
         * @return builder
         * 
         */
        public Builder passthroughBehavior(String passthroughBehavior) {
            return passthroughBehavior(Output.of(passthroughBehavior));
        }

        /**
         * @param requestParameters Map of request query string parameters and headers that should be passed to the backend responder.
         * For example: `request_parameters = { &#34;integration.request.header.X-Some-Other-Header&#34; = &#34;method.request.header.X-Some-Header&#34; }`
         * 
         * @return builder
         * 
         */
        public Builder requestParameters(@Nullable Output<Map<String,String>> requestParameters) {
            $.requestParameters = requestParameters;
            return this;
        }

        /**
         * @param requestParameters Map of request query string parameters and headers that should be passed to the backend responder.
         * For example: `request_parameters = { &#34;integration.request.header.X-Some-Other-Header&#34; = &#34;method.request.header.X-Some-Header&#34; }`
         * 
         * @return builder
         * 
         */
        public Builder requestParameters(Map<String,String> requestParameters) {
            return requestParameters(Output.of(requestParameters));
        }

        /**
         * @param requestTemplates Map of the integration&#39;s request templates.
         * 
         * @return builder
         * 
         */
        public Builder requestTemplates(@Nullable Output<Map<String,String>> requestTemplates) {
            $.requestTemplates = requestTemplates;
            return this;
        }

        /**
         * @param requestTemplates Map of the integration&#39;s request templates.
         * 
         * @return builder
         * 
         */
        public Builder requestTemplates(Map<String,String> requestTemplates) {
            return requestTemplates(Output.of(requestTemplates));
        }

        /**
         * @param resourceId API resource ID.
         * 
         * @return builder
         * 
         */
        public Builder resourceId(@Nullable Output<String> resourceId) {
            $.resourceId = resourceId;
            return this;
        }

        /**
         * @param resourceId API resource ID.
         * 
         * @return builder
         * 
         */
        public Builder resourceId(String resourceId) {
            return resourceId(Output.of(resourceId));
        }

        /**
         * @param restApi ID of the associated REST API.
         * 
         * @return builder
         * 
         */
        public Builder restApi(@Nullable Output<String> restApi) {
            $.restApi = restApi;
            return this;
        }

        /**
         * @param restApi ID of the associated REST API.
         * 
         * @return builder
         * 
         */
        public Builder restApi(String restApi) {
            return restApi(Output.of(restApi));
        }

        /**
         * @param timeoutMilliseconds Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds.
         * 
         * @return builder
         * 
         */
        public Builder timeoutMilliseconds(@Nullable Output<Integer> timeoutMilliseconds) {
            $.timeoutMilliseconds = timeoutMilliseconds;
            return this;
        }

        /**
         * @param timeoutMilliseconds Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds.
         * 
         * @return builder
         * 
         */
        public Builder timeoutMilliseconds(Integer timeoutMilliseconds) {
            return timeoutMilliseconds(Output.of(timeoutMilliseconds));
        }

        /**
         * @param tlsConfig TLS configuration. See below.
         * 
         * @return builder
         * 
         */
        public Builder tlsConfig(@Nullable Output<IntegrationTlsConfigArgs> tlsConfig) {
            $.tlsConfig = tlsConfig;
            return this;
        }

        /**
         * @param tlsConfig TLS configuration. See below.
         * 
         * @return builder
         * 
         */
        public Builder tlsConfig(IntegrationTlsConfigArgs tlsConfig) {
            return tlsConfig(Output.of(tlsConfig));
        }

        /**
         * @param type Integration input&#39;s [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
         * 
         * @return builder
         * 
         */
        public Builder type(@Nullable Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type Integration input&#39;s [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        /**
         * @param uri Input&#39;s URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
         * For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
         * e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:012345678901:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
         * 
         * @return builder
         * 
         */
        public Builder uri(@Nullable Output<String> uri) {
            $.uri = uri;
            return this;
        }

        /**
         * @param uri Input&#39;s URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
         * For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
         * e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:012345678901:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
         * 
         * @return builder
         * 
         */
        public Builder uri(String uri) {
            return uri(Output.of(uri));
        }

        public IntegrationState build() {
            return $;
        }
    }

}
