// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigateway.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DomainNameMutualTlsAuthenticationArgs extends com.pulumi.resources.ResourceArgs {

    public static final DomainNameMutualTlsAuthenticationArgs Empty = new DomainNameMutualTlsAuthenticationArgs();

    /**
     * Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
     * 
     */
    @Import(name="truststoreUri", required=true)
    private Output<String> truststoreUri;

    /**
     * @return Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
     * 
     */
    public Output<String> truststoreUri() {
        return this.truststoreUri;
    }

    /**
     * Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
     * 
     */
    @Import(name="truststoreVersion")
    private @Nullable Output<String> truststoreVersion;

    /**
     * @return Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
     * 
     */
    public Optional<Output<String>> truststoreVersion() {
        return Optional.ofNullable(this.truststoreVersion);
    }

    private DomainNameMutualTlsAuthenticationArgs() {}

    private DomainNameMutualTlsAuthenticationArgs(DomainNameMutualTlsAuthenticationArgs $) {
        this.truststoreUri = $.truststoreUri;
        this.truststoreVersion = $.truststoreVersion;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DomainNameMutualTlsAuthenticationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DomainNameMutualTlsAuthenticationArgs $;

        public Builder() {
            $ = new DomainNameMutualTlsAuthenticationArgs();
        }

        public Builder(DomainNameMutualTlsAuthenticationArgs defaults) {
            $ = new DomainNameMutualTlsAuthenticationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param truststoreUri Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
         * 
         * @return builder
         * 
         */
        public Builder truststoreUri(Output<String> truststoreUri) {
            $.truststoreUri = truststoreUri;
            return this;
        }

        /**
         * @param truststoreUri Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
         * 
         * @return builder
         * 
         */
        public Builder truststoreUri(String truststoreUri) {
            return truststoreUri(Output.of(truststoreUri));
        }

        /**
         * @param truststoreVersion Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
         * 
         * @return builder
         * 
         */
        public Builder truststoreVersion(@Nullable Output<String> truststoreVersion) {
            $.truststoreVersion = truststoreVersion;
            return this;
        }

        /**
         * @param truststoreVersion Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
         * 
         * @return builder
         * 
         */
        public Builder truststoreVersion(String truststoreVersion) {
            return truststoreVersion(Output.of(truststoreVersion));
        }

        public DomainNameMutualTlsAuthenticationArgs build() {
            $.truststoreUri = Objects.requireNonNull($.truststoreUri, "expected parameter 'truststoreUri' to be non-null");
            return $;
        }
    }

}
