// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigateway.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class AuthorizerState extends com.pulumi.resources.ResourceArgs {

    public static final AuthorizerState Empty = new AuthorizerState();

    /**
     * ARN of the API Gateway Authorizer
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return ARN of the API Gateway Authorizer
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * Credentials required for the authorizer. To specify an IAM Role for API Gateway to assume, use the IAM Role ARN.
     * 
     */
    @Import(name="authorizerCredentials")
    private @Nullable Output<String> authorizerCredentials;

    /**
     * @return Credentials required for the authorizer. To specify an IAM Role for API Gateway to assume, use the IAM Role ARN.
     * 
     */
    public Optional<Output<String>> authorizerCredentials() {
        return Optional.ofNullable(this.authorizerCredentials);
    }

    /**
     * TTL of cached authorizer results in seconds. Defaults to `300`.
     * 
     */
    @Import(name="authorizerResultTtlInSeconds")
    private @Nullable Output<Integer> authorizerResultTtlInSeconds;

    /**
     * @return TTL of cached authorizer results in seconds. Defaults to `300`.
     * 
     */
    public Optional<Output<Integer>> authorizerResultTtlInSeconds() {
        return Optional.ofNullable(this.authorizerResultTtlInSeconds);
    }

    /**
     * Authorizer&#39;s Uniform Resource Identifier (URI). This must be a well-formed Lambda function URI in the form of `arn:aws:apigateway:{region}:lambda:path/{service_api}`,
     * e.g., `arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:012345678912:function:my-function/invocations`
     * 
     */
    @Import(name="authorizerUri")
    private @Nullable Output<String> authorizerUri;

    /**
     * @return Authorizer&#39;s Uniform Resource Identifier (URI). This must be a well-formed Lambda function URI in the form of `arn:aws:apigateway:{region}:lambda:path/{service_api}`,
     * e.g., `arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:012345678912:function:my-function/invocations`
     * 
     */
    public Optional<Output<String>> authorizerUri() {
        return Optional.ofNullable(this.authorizerUri);
    }

    /**
     * Source of the identity in an incoming request. Defaults to `method.request.header.Authorization`. For `REQUEST` type, this may be a comma-separated list of values, including headers, query string parameters and stage variables - e.g., `&#34;method.request.header.SomeHeaderName,method.request.querystring.SomeQueryStringName,stageVariables.SomeStageVariableName&#34;`
     * 
     */
    @Import(name="identitySource")
    private @Nullable Output<String> identitySource;

    /**
     * @return Source of the identity in an incoming request. Defaults to `method.request.header.Authorization`. For `REQUEST` type, this may be a comma-separated list of values, including headers, query string parameters and stage variables - e.g., `&#34;method.request.header.SomeHeaderName,method.request.querystring.SomeQueryStringName,stageVariables.SomeStageVariableName&#34;`
     * 
     */
    public Optional<Output<String>> identitySource() {
        return Optional.ofNullable(this.identitySource);
    }

    /**
     * Validation expression for the incoming identity. For `TOKEN` type, this value should be a regular expression. The incoming token from the client is matched against this expression, and will proceed if the token matches. If the token doesn&#39;t match, the client receives a 401 Unauthorized response.
     * 
     */
    @Import(name="identityValidationExpression")
    private @Nullable Output<String> identityValidationExpression;

    /**
     * @return Validation expression for the incoming identity. For `TOKEN` type, this value should be a regular expression. The incoming token from the client is matched against this expression, and will proceed if the token matches. If the token doesn&#39;t match, the client receives a 401 Unauthorized response.
     * 
     */
    public Optional<Output<String>> identityValidationExpression() {
        return Optional.ofNullable(this.identityValidationExpression);
    }

    /**
     * Name of the authorizer
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name of the authorizer
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * List of the Amazon Cognito user pool ARNs. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`.
     * 
     */
    @Import(name="providerArns")
    private @Nullable Output<List<String>> providerArns;

    /**
     * @return List of the Amazon Cognito user pool ARNs. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`.
     * 
     */
    public Optional<Output<List<String>>> providerArns() {
        return Optional.ofNullable(this.providerArns);
    }

    /**
     * ID of the associated REST API
     * 
     */
    @Import(name="restApi")
    private @Nullable Output<String> restApi;

    /**
     * @return ID of the associated REST API
     * 
     */
    public Optional<Output<String>> restApi() {
        return Optional.ofNullable(this.restApi);
    }

    /**
     * Type of the authorizer. Possible values are `TOKEN` for a Lambda function using a single authorization token submitted in a custom header, `REQUEST` for a Lambda function using incoming request parameters, or `COGNITO_USER_POOLS` for using an Amazon Cognito user pool. Defaults to `TOKEN`.
     * 
     */
    @Import(name="type")
    private @Nullable Output<String> type;

    /**
     * @return Type of the authorizer. Possible values are `TOKEN` for a Lambda function using a single authorization token submitted in a custom header, `REQUEST` for a Lambda function using incoming request parameters, or `COGNITO_USER_POOLS` for using an Amazon Cognito user pool. Defaults to `TOKEN`.
     * 
     */
    public Optional<Output<String>> type() {
        return Optional.ofNullable(this.type);
    }

    private AuthorizerState() {}

    private AuthorizerState(AuthorizerState $) {
        this.arn = $.arn;
        this.authorizerCredentials = $.authorizerCredentials;
        this.authorizerResultTtlInSeconds = $.authorizerResultTtlInSeconds;
        this.authorizerUri = $.authorizerUri;
        this.identitySource = $.identitySource;
        this.identityValidationExpression = $.identityValidationExpression;
        this.name = $.name;
        this.providerArns = $.providerArns;
        this.restApi = $.restApi;
        this.type = $.type;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(AuthorizerState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private AuthorizerState $;

        public Builder() {
            $ = new AuthorizerState();
        }

        public Builder(AuthorizerState defaults) {
            $ = new AuthorizerState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn ARN of the API Gateway Authorizer
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn ARN of the API Gateway Authorizer
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param authorizerCredentials Credentials required for the authorizer. To specify an IAM Role for API Gateway to assume, use the IAM Role ARN.
         * 
         * @return builder
         * 
         */
        public Builder authorizerCredentials(@Nullable Output<String> authorizerCredentials) {
            $.authorizerCredentials = authorizerCredentials;
            return this;
        }

        /**
         * @param authorizerCredentials Credentials required for the authorizer. To specify an IAM Role for API Gateway to assume, use the IAM Role ARN.
         * 
         * @return builder
         * 
         */
        public Builder authorizerCredentials(String authorizerCredentials) {
            return authorizerCredentials(Output.of(authorizerCredentials));
        }

        /**
         * @param authorizerResultTtlInSeconds TTL of cached authorizer results in seconds. Defaults to `300`.
         * 
         * @return builder
         * 
         */
        public Builder authorizerResultTtlInSeconds(@Nullable Output<Integer> authorizerResultTtlInSeconds) {
            $.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
            return this;
        }

        /**
         * @param authorizerResultTtlInSeconds TTL of cached authorizer results in seconds. Defaults to `300`.
         * 
         * @return builder
         * 
         */
        public Builder authorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds) {
            return authorizerResultTtlInSeconds(Output.of(authorizerResultTtlInSeconds));
        }

        /**
         * @param authorizerUri Authorizer&#39;s Uniform Resource Identifier (URI). This must be a well-formed Lambda function URI in the form of `arn:aws:apigateway:{region}:lambda:path/{service_api}`,
         * e.g., `arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:012345678912:function:my-function/invocations`
         * 
         * @return builder
         * 
         */
        public Builder authorizerUri(@Nullable Output<String> authorizerUri) {
            $.authorizerUri = authorizerUri;
            return this;
        }

        /**
         * @param authorizerUri Authorizer&#39;s Uniform Resource Identifier (URI). This must be a well-formed Lambda function URI in the form of `arn:aws:apigateway:{region}:lambda:path/{service_api}`,
         * e.g., `arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:012345678912:function:my-function/invocations`
         * 
         * @return builder
         * 
         */
        public Builder authorizerUri(String authorizerUri) {
            return authorizerUri(Output.of(authorizerUri));
        }

        /**
         * @param identitySource Source of the identity in an incoming request. Defaults to `method.request.header.Authorization`. For `REQUEST` type, this may be a comma-separated list of values, including headers, query string parameters and stage variables - e.g., `&#34;method.request.header.SomeHeaderName,method.request.querystring.SomeQueryStringName,stageVariables.SomeStageVariableName&#34;`
         * 
         * @return builder
         * 
         */
        public Builder identitySource(@Nullable Output<String> identitySource) {
            $.identitySource = identitySource;
            return this;
        }

        /**
         * @param identitySource Source of the identity in an incoming request. Defaults to `method.request.header.Authorization`. For `REQUEST` type, this may be a comma-separated list of values, including headers, query string parameters and stage variables - e.g., `&#34;method.request.header.SomeHeaderName,method.request.querystring.SomeQueryStringName,stageVariables.SomeStageVariableName&#34;`
         * 
         * @return builder
         * 
         */
        public Builder identitySource(String identitySource) {
            return identitySource(Output.of(identitySource));
        }

        /**
         * @param identityValidationExpression Validation expression for the incoming identity. For `TOKEN` type, this value should be a regular expression. The incoming token from the client is matched against this expression, and will proceed if the token matches. If the token doesn&#39;t match, the client receives a 401 Unauthorized response.
         * 
         * @return builder
         * 
         */
        public Builder identityValidationExpression(@Nullable Output<String> identityValidationExpression) {
            $.identityValidationExpression = identityValidationExpression;
            return this;
        }

        /**
         * @param identityValidationExpression Validation expression for the incoming identity. For `TOKEN` type, this value should be a regular expression. The incoming token from the client is matched against this expression, and will proceed if the token matches. If the token doesn&#39;t match, the client receives a 401 Unauthorized response.
         * 
         * @return builder
         * 
         */
        public Builder identityValidationExpression(String identityValidationExpression) {
            return identityValidationExpression(Output.of(identityValidationExpression));
        }

        /**
         * @param name Name of the authorizer
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the authorizer
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param providerArns List of the Amazon Cognito user pool ARNs. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`.
         * 
         * @return builder
         * 
         */
        public Builder providerArns(@Nullable Output<List<String>> providerArns) {
            $.providerArns = providerArns;
            return this;
        }

        /**
         * @param providerArns List of the Amazon Cognito user pool ARNs. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`.
         * 
         * @return builder
         * 
         */
        public Builder providerArns(List<String> providerArns) {
            return providerArns(Output.of(providerArns));
        }

        /**
         * @param providerArns List of the Amazon Cognito user pool ARNs. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`.
         * 
         * @return builder
         * 
         */
        public Builder providerArns(String... providerArns) {
            return providerArns(List.of(providerArns));
        }

        /**
         * @param restApi ID of the associated REST API
         * 
         * @return builder
         * 
         */
        public Builder restApi(@Nullable Output<String> restApi) {
            $.restApi = restApi;
            return this;
        }

        /**
         * @param restApi ID of the associated REST API
         * 
         * @return builder
         * 
         */
        public Builder restApi(String restApi) {
            return restApi(Output.of(restApi));
        }

        /**
         * @param type Type of the authorizer. Possible values are `TOKEN` for a Lambda function using a single authorization token submitted in a custom header, `REQUEST` for a Lambda function using incoming request parameters, or `COGNITO_USER_POOLS` for using an Amazon Cognito user pool. Defaults to `TOKEN`.
         * 
         * @return builder
         * 
         */
        public Builder type(@Nullable Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type Type of the authorizer. Possible values are `TOKEN` for a Lambda function using a single authorization token submitted in a custom header, `REQUEST` for a Lambda function using incoming request parameters, or `COGNITO_USER_POOLS` for using an Amazon Cognito user pool. Defaults to `TOKEN`.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        public AuthorizerState build() {
            return $;
        }
    }

}
