// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigateway;

import com.pulumi.aws.apigateway.inputs.StageAccessLogSettingsArgs;
import com.pulumi.aws.apigateway.inputs.StageCanarySettingsArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class StageArgs extends com.pulumi.resources.ResourceArgs {

    public static final StageArgs Empty = new StageArgs();

    /**
     * Enables access logs for the API stage. See Access Log Settings below.
     * 
     */
    @Import(name="accessLogSettings")
    private @Nullable Output<StageAccessLogSettingsArgs> accessLogSettings;

    /**
     * @return Enables access logs for the API stage. See Access Log Settings below.
     * 
     */
    public Optional<Output<StageAccessLogSettingsArgs>> accessLogSettings() {
        return Optional.ofNullable(this.accessLogSettings);
    }

    /**
     * Whether a cache cluster is enabled for the stage
     * 
     */
    @Import(name="cacheClusterEnabled")
    private @Nullable Output<Boolean> cacheClusterEnabled;

    /**
     * @return Whether a cache cluster is enabled for the stage
     * 
     */
    public Optional<Output<Boolean>> cacheClusterEnabled() {
        return Optional.ofNullable(this.cacheClusterEnabled);
    }

    /**
     * Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
     * 
     */
    @Import(name="cacheClusterSize")
    private @Nullable Output<String> cacheClusterSize;

    /**
     * @return Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
     * 
     */
    public Optional<Output<String>> cacheClusterSize() {
        return Optional.ofNullable(this.cacheClusterSize);
    }

    /**
     * Configuration settings of a canary deployment. See Canary Settings below.
     * 
     */
    @Import(name="canarySettings")
    private @Nullable Output<StageCanarySettingsArgs> canarySettings;

    /**
     * @return Configuration settings of a canary deployment. See Canary Settings below.
     * 
     */
    public Optional<Output<StageCanarySettingsArgs>> canarySettings() {
        return Optional.ofNullable(this.canarySettings);
    }

    /**
     * Identifier of a client certificate for the stage.
     * 
     */
    @Import(name="clientCertificateId")
    private @Nullable Output<String> clientCertificateId;

    /**
     * @return Identifier of a client certificate for the stage.
     * 
     */
    public Optional<Output<String>> clientCertificateId() {
        return Optional.ofNullable(this.clientCertificateId);
    }

    /**
     * ID of the deployment that the stage points to
     * 
     */
    @Import(name="deployment", required=true)
    private Output<String> deployment;

    /**
     * @return ID of the deployment that the stage points to
     * 
     */
    public Output<String> deployment() {
        return this.deployment;
    }

    /**
     * Description of the stage.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Description of the stage.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Version of the associated API documentation
     * 
     */
    @Import(name="documentationVersion")
    private @Nullable Output<String> documentationVersion;

    /**
     * @return Version of the associated API documentation
     * 
     */
    public Optional<Output<String>> documentationVersion() {
        return Optional.ofNullable(this.documentationVersion);
    }

    /**
     * ID of the associated REST API
     * 
     */
    @Import(name="restApi", required=true)
    private Output<String> restApi;

    /**
     * @return ID of the associated REST API
     * 
     */
    public Output<String> restApi() {
        return this.restApi;
    }

    /**
     * Name of the stage
     * 
     */
    @Import(name="stageName", required=true)
    private Output<String> stageName;

    /**
     * @return Name of the stage
     * 
     */
    public Output<String> stageName() {
        return this.stageName;
    }

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Map that defines the stage variables
     * 
     */
    @Import(name="variables")
    private @Nullable Output<Map<String,String>> variables;

    /**
     * @return Map that defines the stage variables
     * 
     */
    public Optional<Output<Map<String,String>>> variables() {
        return Optional.ofNullable(this.variables);
    }

    /**
     * Whether active tracing with X-ray is enabled. Defaults to `false`.
     * 
     */
    @Import(name="xrayTracingEnabled")
    private @Nullable Output<Boolean> xrayTracingEnabled;

    /**
     * @return Whether active tracing with X-ray is enabled. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> xrayTracingEnabled() {
        return Optional.ofNullable(this.xrayTracingEnabled);
    }

    private StageArgs() {}

    private StageArgs(StageArgs $) {
        this.accessLogSettings = $.accessLogSettings;
        this.cacheClusterEnabled = $.cacheClusterEnabled;
        this.cacheClusterSize = $.cacheClusterSize;
        this.canarySettings = $.canarySettings;
        this.clientCertificateId = $.clientCertificateId;
        this.deployment = $.deployment;
        this.description = $.description;
        this.documentationVersion = $.documentationVersion;
        this.restApi = $.restApi;
        this.stageName = $.stageName;
        this.tags = $.tags;
        this.variables = $.variables;
        this.xrayTracingEnabled = $.xrayTracingEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(StageArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private StageArgs $;

        public Builder() {
            $ = new StageArgs();
        }

        public Builder(StageArgs defaults) {
            $ = new StageArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessLogSettings Enables access logs for the API stage. See Access Log Settings below.
         * 
         * @return builder
         * 
         */
        public Builder accessLogSettings(@Nullable Output<StageAccessLogSettingsArgs> accessLogSettings) {
            $.accessLogSettings = accessLogSettings;
            return this;
        }

        /**
         * @param accessLogSettings Enables access logs for the API stage. See Access Log Settings below.
         * 
         * @return builder
         * 
         */
        public Builder accessLogSettings(StageAccessLogSettingsArgs accessLogSettings) {
            return accessLogSettings(Output.of(accessLogSettings));
        }

        /**
         * @param cacheClusterEnabled Whether a cache cluster is enabled for the stage
         * 
         * @return builder
         * 
         */
        public Builder cacheClusterEnabled(@Nullable Output<Boolean> cacheClusterEnabled) {
            $.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        /**
         * @param cacheClusterEnabled Whether a cache cluster is enabled for the stage
         * 
         * @return builder
         * 
         */
        public Builder cacheClusterEnabled(Boolean cacheClusterEnabled) {
            return cacheClusterEnabled(Output.of(cacheClusterEnabled));
        }

        /**
         * @param cacheClusterSize Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
         * 
         * @return builder
         * 
         */
        public Builder cacheClusterSize(@Nullable Output<String> cacheClusterSize) {
            $.cacheClusterSize = cacheClusterSize;
            return this;
        }

        /**
         * @param cacheClusterSize Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
         * 
         * @return builder
         * 
         */
        public Builder cacheClusterSize(String cacheClusterSize) {
            return cacheClusterSize(Output.of(cacheClusterSize));
        }

        /**
         * @param canarySettings Configuration settings of a canary deployment. See Canary Settings below.
         * 
         * @return builder
         * 
         */
        public Builder canarySettings(@Nullable Output<StageCanarySettingsArgs> canarySettings) {
            $.canarySettings = canarySettings;
            return this;
        }

        /**
         * @param canarySettings Configuration settings of a canary deployment. See Canary Settings below.
         * 
         * @return builder
         * 
         */
        public Builder canarySettings(StageCanarySettingsArgs canarySettings) {
            return canarySettings(Output.of(canarySettings));
        }

        /**
         * @param clientCertificateId Identifier of a client certificate for the stage.
         * 
         * @return builder
         * 
         */
        public Builder clientCertificateId(@Nullable Output<String> clientCertificateId) {
            $.clientCertificateId = clientCertificateId;
            return this;
        }

        /**
         * @param clientCertificateId Identifier of a client certificate for the stage.
         * 
         * @return builder
         * 
         */
        public Builder clientCertificateId(String clientCertificateId) {
            return clientCertificateId(Output.of(clientCertificateId));
        }

        /**
         * @param deployment ID of the deployment that the stage points to
         * 
         * @return builder
         * 
         */
        public Builder deployment(Output<String> deployment) {
            $.deployment = deployment;
            return this;
        }

        /**
         * @param deployment ID of the deployment that the stage points to
         * 
         * @return builder
         * 
         */
        public Builder deployment(String deployment) {
            return deployment(Output.of(deployment));
        }

        /**
         * @param description Description of the stage.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Description of the stage.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param documentationVersion Version of the associated API documentation
         * 
         * @return builder
         * 
         */
        public Builder documentationVersion(@Nullable Output<String> documentationVersion) {
            $.documentationVersion = documentationVersion;
            return this;
        }

        /**
         * @param documentationVersion Version of the associated API documentation
         * 
         * @return builder
         * 
         */
        public Builder documentationVersion(String documentationVersion) {
            return documentationVersion(Output.of(documentationVersion));
        }

        /**
         * @param restApi ID of the associated REST API
         * 
         * @return builder
         * 
         */
        public Builder restApi(Output<String> restApi) {
            $.restApi = restApi;
            return this;
        }

        /**
         * @param restApi ID of the associated REST API
         * 
         * @return builder
         * 
         */
        public Builder restApi(String restApi) {
            return restApi(Output.of(restApi));
        }

        /**
         * @param stageName Name of the stage
         * 
         * @return builder
         * 
         */
        public Builder stageName(Output<String> stageName) {
            $.stageName = stageName;
            return this;
        }

        /**
         * @param stageName Name of the stage
         * 
         * @return builder
         * 
         */
        public Builder stageName(String stageName) {
            return stageName(Output.of(stageName));
        }

        /**
         * @param tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param variables Map that defines the stage variables
         * 
         * @return builder
         * 
         */
        public Builder variables(@Nullable Output<Map<String,String>> variables) {
            $.variables = variables;
            return this;
        }

        /**
         * @param variables Map that defines the stage variables
         * 
         * @return builder
         * 
         */
        public Builder variables(Map<String,String> variables) {
            return variables(Output.of(variables));
        }

        /**
         * @param xrayTracingEnabled Whether active tracing with X-ray is enabled. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder xrayTracingEnabled(@Nullable Output<Boolean> xrayTracingEnabled) {
            $.xrayTracingEnabled = xrayTracingEnabled;
            return this;
        }

        /**
         * @param xrayTracingEnabled Whether active tracing with X-ray is enabled. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder xrayTracingEnabled(Boolean xrayTracingEnabled) {
            return xrayTracingEnabled(Output.of(xrayTracingEnabled));
        }

        public StageArgs build() {
            $.deployment = Objects.requireNonNull($.deployment, "expected parameter 'deployment' to be non-null");
            $.restApi = Objects.requireNonNull($.restApi, "expected parameter 'restApi' to be non-null");
            $.stageName = Objects.requireNonNull($.stageName, "expected parameter 'stageName' to be non-null");
            return $;
        }
    }

}
