// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigateway;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ResponseArgs extends com.pulumi.resources.ResourceArgs {

    public static final ResponseArgs Empty = new ResponseArgs();

    /**
     * Map of parameters (paths, query strings and headers) of the Gateway Response.
     * 
     */
    @Import(name="responseParameters")
    private @Nullable Output<Map<String,String>> responseParameters;

    /**
     * @return Map of parameters (paths, query strings and headers) of the Gateway Response.
     * 
     */
    public Optional<Output<Map<String,String>>> responseParameters() {
        return Optional.ofNullable(this.responseParameters);
    }

    /**
     * Map of templates used to transform the response body.
     * 
     */
    @Import(name="responseTemplates")
    private @Nullable Output<Map<String,String>> responseTemplates;

    /**
     * @return Map of templates used to transform the response body.
     * 
     */
    public Optional<Output<Map<String,String>>> responseTemplates() {
        return Optional.ofNullable(this.responseTemplates);
    }

    /**
     * Response type of the associated GatewayResponse.
     * 
     */
    @Import(name="responseType", required=true)
    private Output<String> responseType;

    /**
     * @return Response type of the associated GatewayResponse.
     * 
     */
    public Output<String> responseType() {
        return this.responseType;
    }

    /**
     * String identifier of the associated REST API.
     * 
     */
    @Import(name="restApiId", required=true)
    private Output<String> restApiId;

    /**
     * @return String identifier of the associated REST API.
     * 
     */
    public Output<String> restApiId() {
        return this.restApiId;
    }

    /**
     * HTTP status code of the Gateway Response.
     * 
     */
    @Import(name="statusCode")
    private @Nullable Output<String> statusCode;

    /**
     * @return HTTP status code of the Gateway Response.
     * 
     */
    public Optional<Output<String>> statusCode() {
        return Optional.ofNullable(this.statusCode);
    }

    private ResponseArgs() {}

    private ResponseArgs(ResponseArgs $) {
        this.responseParameters = $.responseParameters;
        this.responseTemplates = $.responseTemplates;
        this.responseType = $.responseType;
        this.restApiId = $.restApiId;
        this.statusCode = $.statusCode;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ResponseArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ResponseArgs $;

        public Builder() {
            $ = new ResponseArgs();
        }

        public Builder(ResponseArgs defaults) {
            $ = new ResponseArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param responseParameters Map of parameters (paths, query strings and headers) of the Gateway Response.
         * 
         * @return builder
         * 
         */
        public Builder responseParameters(@Nullable Output<Map<String,String>> responseParameters) {
            $.responseParameters = responseParameters;
            return this;
        }

        /**
         * @param responseParameters Map of parameters (paths, query strings and headers) of the Gateway Response.
         * 
         * @return builder
         * 
         */
        public Builder responseParameters(Map<String,String> responseParameters) {
            return responseParameters(Output.of(responseParameters));
        }

        /**
         * @param responseTemplates Map of templates used to transform the response body.
         * 
         * @return builder
         * 
         */
        public Builder responseTemplates(@Nullable Output<Map<String,String>> responseTemplates) {
            $.responseTemplates = responseTemplates;
            return this;
        }

        /**
         * @param responseTemplates Map of templates used to transform the response body.
         * 
         * @return builder
         * 
         */
        public Builder responseTemplates(Map<String,String> responseTemplates) {
            return responseTemplates(Output.of(responseTemplates));
        }

        /**
         * @param responseType Response type of the associated GatewayResponse.
         * 
         * @return builder
         * 
         */
        public Builder responseType(Output<String> responseType) {
            $.responseType = responseType;
            return this;
        }

        /**
         * @param responseType Response type of the associated GatewayResponse.
         * 
         * @return builder
         * 
         */
        public Builder responseType(String responseType) {
            return responseType(Output.of(responseType));
        }

        /**
         * @param restApiId String identifier of the associated REST API.
         * 
         * @return builder
         * 
         */
        public Builder restApiId(Output<String> restApiId) {
            $.restApiId = restApiId;
            return this;
        }

        /**
         * @param restApiId String identifier of the associated REST API.
         * 
         * @return builder
         * 
         */
        public Builder restApiId(String restApiId) {
            return restApiId(Output.of(restApiId));
        }

        /**
         * @param statusCode HTTP status code of the Gateway Response.
         * 
         * @return builder
         * 
         */
        public Builder statusCode(@Nullable Output<String> statusCode) {
            $.statusCode = statusCode;
            return this;
        }

        /**
         * @param statusCode HTTP status code of the Gateway Response.
         * 
         * @return builder
         * 
         */
        public Builder statusCode(String statusCode) {
            return statusCode(Output.of(statusCode));
        }

        public ResponseArgs build() {
            $.responseType = Objects.requireNonNull($.responseType, "expected parameter 'responseType' to be non-null");
            $.restApiId = Objects.requireNonNull($.restApiId, "expected parameter 'restApiId' to be non-null");
            return $;
        }
    }

}
