// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigateway;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.apigateway.RequestValidatorArgs;
import com.pulumi.aws.apigateway.inputs.RequestValidatorState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an API Gateway Request Validator.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RequestValidator;
 * import com.pulumi.aws.apigateway.RequestValidatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new RequestValidator(&#34;example&#34;, RequestValidatorArgs.builder()        
 *             .restApi(aws_api_gateway_rest_api.example().id())
 *             .validateRequestBody(true)
 *             .validateRequestParameters(true)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_api_gateway_request_validator` using `REST-API-ID/REQUEST-VALIDATOR-ID`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:apigateway/requestValidator:RequestValidator example 12345abcde/67890fghij
 * ```
 * 
 */
@ResourceType(type="aws:apigateway/requestValidator:RequestValidator")
public class RequestValidator extends com.pulumi.resources.CustomResource {
    /**
     * Name of the request validator
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name of the request validator
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * ID of the associated Rest API
     * 
     */
    @Export(name="restApi", refs={String.class}, tree="[0]")
    private Output<String> restApi;

    /**
     * @return ID of the associated Rest API
     * 
     */
    public Output<String> restApi() {
        return this.restApi;
    }
    /**
     * Boolean whether to validate request body. Defaults to `false`.
     * 
     */
    @Export(name="validateRequestBody", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> validateRequestBody;

    /**
     * @return Boolean whether to validate request body. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> validateRequestBody() {
        return Codegen.optional(this.validateRequestBody);
    }
    /**
     * Boolean whether to validate request parameters. Defaults to `false`.
     * 
     */
    @Export(name="validateRequestParameters", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> validateRequestParameters;

    /**
     * @return Boolean whether to validate request parameters. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> validateRequestParameters() {
        return Codegen.optional(this.validateRequestParameters);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public RequestValidator(String name) {
        this(name, RequestValidatorArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public RequestValidator(String name, RequestValidatorArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public RequestValidator(String name, RequestValidatorArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:apigateway/requestValidator:RequestValidator", name, args == null ? RequestValidatorArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private RequestValidator(String name, Output<String> id, @Nullable RequestValidatorState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:apigateway/requestValidator:RequestValidator", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static RequestValidator get(String name, Output<String> id, @Nullable RequestValidatorState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new RequestValidator(name, id, state, options);
    }
}
