// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigateway;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.apigateway.MethodResponseArgs;
import com.pulumi.aws.apigateway.inputs.MethodResponseState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an HTTP Method Response for an API Gateway Resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import com.pulumi.aws.apigateway.Method;
 * import com.pulumi.aws.apigateway.MethodArgs;
 * import com.pulumi.aws.apigateway.Integration;
 * import com.pulumi.aws.apigateway.IntegrationArgs;
 * import com.pulumi.aws.apigateway.MethodResponse;
 * import com.pulumi.aws.apigateway.MethodResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi(&#34;myDemoAPI&#34;, RestApiArgs.builder()        
 *             .description(&#34;This is my API for demonstration purposes&#34;)
 *             .build());
 * 
 *         var myDemoResource = new Resource(&#34;myDemoResource&#34;, ResourceArgs.builder()        
 *             .restApi(myDemoAPI.id())
 *             .parentId(myDemoAPI.rootResourceId())
 *             .pathPart(&#34;mydemoresource&#34;)
 *             .build());
 * 
 *         var myDemoMethod = new Method(&#34;myDemoMethod&#34;, MethodArgs.builder()        
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod(&#34;GET&#34;)
 *             .authorization(&#34;NONE&#34;)
 *             .build());
 * 
 *         var myDemoIntegration = new Integration(&#34;myDemoIntegration&#34;, IntegrationArgs.builder()        
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod(myDemoMethod.httpMethod())
 *             .type(&#34;MOCK&#34;)
 *             .build());
 * 
 *         var response200 = new MethodResponse(&#34;response200&#34;, MethodResponseArgs.builder()        
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod(myDemoMethod.httpMethod())
 *             .statusCode(&#34;200&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_api_gateway_method_response` using `REST-API-ID/RESOURCE-ID/HTTP-METHOD/STATUS-CODE`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:apigateway/methodResponse:MethodResponse example 12345abcde/67890fghij/GET/200
 * ```
 * 
 */
@ResourceType(type="aws:apigateway/methodResponse:MethodResponse")
public class MethodResponse extends com.pulumi.resources.CustomResource {
    /**
     * HTTP Method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`)
     * 
     */
    @Export(name="httpMethod", refs={String.class}, tree="[0]")
    private Output<String> httpMethod;

    /**
     * @return HTTP Method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`)
     * 
     */
    public Output<String> httpMethod() {
        return this.httpMethod;
    }
    /**
     * API resource ID
     * 
     */
    @Export(name="resourceId", refs={String.class}, tree="[0]")
    private Output<String> resourceId;

    /**
     * @return API resource ID
     * 
     */
    public Output<String> resourceId() {
        return this.resourceId;
    }
    /**
     * Map of the API models used for the response&#39;s content type
     * 
     */
    @Export(name="responseModels", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> responseModels;

    /**
     * @return Map of the API models used for the response&#39;s content type
     * 
     */
    public Output<Optional<Map<String,String>>> responseModels() {
        return Codegen.optional(this.responseModels);
    }
    /**
     * Map of response parameters that can be sent to the caller.
     * For example: `response_parameters = { &#34;method.response.header.X-Some-Header&#34; = true }`
     * would define that the header `X-Some-Header` can be provided on the response.
     * 
     */
    @Export(name="responseParameters", refs={Map.class,String.class,Boolean.class}, tree="[0,1,2]")
    private Output</* @Nullable */ Map<String,Boolean>> responseParameters;

    /**
     * @return Map of response parameters that can be sent to the caller.
     * For example: `response_parameters = { &#34;method.response.header.X-Some-Header&#34; = true }`
     * would define that the header `X-Some-Header` can be provided on the response.
     * 
     */
    public Output<Optional<Map<String,Boolean>>> responseParameters() {
        return Codegen.optional(this.responseParameters);
    }
    /**
     * ID of the associated REST API
     * 
     */
    @Export(name="restApi", refs={String.class}, tree="[0]")
    private Output<String> restApi;

    /**
     * @return ID of the associated REST API
     * 
     */
    public Output<String> restApi() {
        return this.restApi;
    }
    /**
     * HTTP status code
     * 
     */
    @Export(name="statusCode", refs={String.class}, tree="[0]")
    private Output<String> statusCode;

    /**
     * @return HTTP status code
     * 
     */
    public Output<String> statusCode() {
        return this.statusCode;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public MethodResponse(String name) {
        this(name, MethodResponseArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public MethodResponse(String name, MethodResponseArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public MethodResponse(String name, MethodResponseArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:apigateway/methodResponse:MethodResponse", name, args == null ? MethodResponseArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private MethodResponse(String name, Output<String> id, @Nullable MethodResponseState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:apigateway/methodResponse:MethodResponse", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static MethodResponse get(String name, Output<String> id, @Nullable MethodResponseState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new MethodResponse(name, id, state, options);
    }
}
