// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigateway;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class MethodArgs extends com.pulumi.resources.ResourceArgs {

    public static final MethodArgs Empty = new MethodArgs();

    /**
     * Specify if the method requires an API key
     * 
     */
    @Import(name="apiKeyRequired")
    private @Nullable Output<Boolean> apiKeyRequired;

    /**
     * @return Specify if the method requires an API key
     * 
     */
    public Optional<Output<Boolean>> apiKeyRequired() {
        return Optional.ofNullable(this.apiKeyRequired);
    }

    /**
     * Type of authorization used for the method (`NONE`, `CUSTOM`, `AWS_IAM`, `COGNITO_USER_POOLS`)
     * 
     */
    @Import(name="authorization", required=true)
    private Output<String> authorization;

    /**
     * @return Type of authorization used for the method (`NONE`, `CUSTOM`, `AWS_IAM`, `COGNITO_USER_POOLS`)
     * 
     */
    public Output<String> authorization() {
        return this.authorization;
    }

    /**
     * Authorization scopes used when the authorization is `COGNITO_USER_POOLS`
     * 
     */
    @Import(name="authorizationScopes")
    private @Nullable Output<List<String>> authorizationScopes;

    /**
     * @return Authorization scopes used when the authorization is `COGNITO_USER_POOLS`
     * 
     */
    public Optional<Output<List<String>>> authorizationScopes() {
        return Optional.ofNullable(this.authorizationScopes);
    }

    /**
     * Authorizer id to be used when the authorization is `CUSTOM` or `COGNITO_USER_POOLS`
     * 
     */
    @Import(name="authorizerId")
    private @Nullable Output<String> authorizerId;

    /**
     * @return Authorizer id to be used when the authorization is `CUSTOM` or `COGNITO_USER_POOLS`
     * 
     */
    public Optional<Output<String>> authorizerId() {
        return Optional.ofNullable(this.authorizerId);
    }

    /**
     * HTTP Method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`)
     * 
     */
    @Import(name="httpMethod", required=true)
    private Output<String> httpMethod;

    /**
     * @return HTTP Method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`)
     * 
     */
    public Output<String> httpMethod() {
        return this.httpMethod;
    }

    /**
     * Function name that will be given to the method when generating an SDK through API Gateway. If omitted, API Gateway will generate a function name based on the resource path and HTTP verb.
     * 
     */
    @Import(name="operationName")
    private @Nullable Output<String> operationName;

    /**
     * @return Function name that will be given to the method when generating an SDK through API Gateway. If omitted, API Gateway will generate a function name based on the resource path and HTTP verb.
     * 
     */
    public Optional<Output<String>> operationName() {
        return Optional.ofNullable(this.operationName);
    }

    /**
     * Map of the API models used for the request&#39;s content type
     * where key is the content type (e.g., `application/json`)
     * and value is either `Error`, `Empty` (built-in models) or `aws.apigateway.Model`&#39;s `name`.
     * 
     */
    @Import(name="requestModels")
    private @Nullable Output<Map<String,String>> requestModels;

    /**
     * @return Map of the API models used for the request&#39;s content type
     * where key is the content type (e.g., `application/json`)
     * and value is either `Error`, `Empty` (built-in models) or `aws.apigateway.Model`&#39;s `name`.
     * 
     */
    public Optional<Output<Map<String,String>>> requestModels() {
        return Optional.ofNullable(this.requestModels);
    }

    /**
     * Map of request parameters (from the path, query string and headers) that should be passed to the integration. The boolean value indicates whether the parameter is required (`true`) or optional (`false`).
     * For example: `request_parameters = {&#34;method.request.header.X-Some-Header&#34; = true &#34;method.request.querystring.some-query-param&#34; = true}` would define that the header `X-Some-Header` and the query string `some-query-param` must be provided in the request.
     * 
     */
    @Import(name="requestParameters")
    private @Nullable Output<Map<String,Boolean>> requestParameters;

    /**
     * @return Map of request parameters (from the path, query string and headers) that should be passed to the integration. The boolean value indicates whether the parameter is required (`true`) or optional (`false`).
     * For example: `request_parameters = {&#34;method.request.header.X-Some-Header&#34; = true &#34;method.request.querystring.some-query-param&#34; = true}` would define that the header `X-Some-Header` and the query string `some-query-param` must be provided in the request.
     * 
     */
    public Optional<Output<Map<String,Boolean>>> requestParameters() {
        return Optional.ofNullable(this.requestParameters);
    }

    /**
     * ID of a `aws.apigateway.RequestValidator`
     * 
     */
    @Import(name="requestValidatorId")
    private @Nullable Output<String> requestValidatorId;

    /**
     * @return ID of a `aws.apigateway.RequestValidator`
     * 
     */
    public Optional<Output<String>> requestValidatorId() {
        return Optional.ofNullable(this.requestValidatorId);
    }

    /**
     * API resource ID
     * 
     */
    @Import(name="resourceId", required=true)
    private Output<String> resourceId;

    /**
     * @return API resource ID
     * 
     */
    public Output<String> resourceId() {
        return this.resourceId;
    }

    /**
     * ID of the associated REST API
     * 
     */
    @Import(name="restApi", required=true)
    private Output<String> restApi;

    /**
     * @return ID of the associated REST API
     * 
     */
    public Output<String> restApi() {
        return this.restApi;
    }

    private MethodArgs() {}

    private MethodArgs(MethodArgs $) {
        this.apiKeyRequired = $.apiKeyRequired;
        this.authorization = $.authorization;
        this.authorizationScopes = $.authorizationScopes;
        this.authorizerId = $.authorizerId;
        this.httpMethod = $.httpMethod;
        this.operationName = $.operationName;
        this.requestModels = $.requestModels;
        this.requestParameters = $.requestParameters;
        this.requestValidatorId = $.requestValidatorId;
        this.resourceId = $.resourceId;
        this.restApi = $.restApi;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(MethodArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private MethodArgs $;

        public Builder() {
            $ = new MethodArgs();
        }

        public Builder(MethodArgs defaults) {
            $ = new MethodArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param apiKeyRequired Specify if the method requires an API key
         * 
         * @return builder
         * 
         */
        public Builder apiKeyRequired(@Nullable Output<Boolean> apiKeyRequired) {
            $.apiKeyRequired = apiKeyRequired;
            return this;
        }

        /**
         * @param apiKeyRequired Specify if the method requires an API key
         * 
         * @return builder
         * 
         */
        public Builder apiKeyRequired(Boolean apiKeyRequired) {
            return apiKeyRequired(Output.of(apiKeyRequired));
        }

        /**
         * @param authorization Type of authorization used for the method (`NONE`, `CUSTOM`, `AWS_IAM`, `COGNITO_USER_POOLS`)
         * 
         * @return builder
         * 
         */
        public Builder authorization(Output<String> authorization) {
            $.authorization = authorization;
            return this;
        }

        /**
         * @param authorization Type of authorization used for the method (`NONE`, `CUSTOM`, `AWS_IAM`, `COGNITO_USER_POOLS`)
         * 
         * @return builder
         * 
         */
        public Builder authorization(String authorization) {
            return authorization(Output.of(authorization));
        }

        /**
         * @param authorizationScopes Authorization scopes used when the authorization is `COGNITO_USER_POOLS`
         * 
         * @return builder
         * 
         */
        public Builder authorizationScopes(@Nullable Output<List<String>> authorizationScopes) {
            $.authorizationScopes = authorizationScopes;
            return this;
        }

        /**
         * @param authorizationScopes Authorization scopes used when the authorization is `COGNITO_USER_POOLS`
         * 
         * @return builder
         * 
         */
        public Builder authorizationScopes(List<String> authorizationScopes) {
            return authorizationScopes(Output.of(authorizationScopes));
        }

        /**
         * @param authorizationScopes Authorization scopes used when the authorization is `COGNITO_USER_POOLS`
         * 
         * @return builder
         * 
         */
        public Builder authorizationScopes(String... authorizationScopes) {
            return authorizationScopes(List.of(authorizationScopes));
        }

        /**
         * @param authorizerId Authorizer id to be used when the authorization is `CUSTOM` or `COGNITO_USER_POOLS`
         * 
         * @return builder
         * 
         */
        public Builder authorizerId(@Nullable Output<String> authorizerId) {
            $.authorizerId = authorizerId;
            return this;
        }

        /**
         * @param authorizerId Authorizer id to be used when the authorization is `CUSTOM` or `COGNITO_USER_POOLS`
         * 
         * @return builder
         * 
         */
        public Builder authorizerId(String authorizerId) {
            return authorizerId(Output.of(authorizerId));
        }

        /**
         * @param httpMethod HTTP Method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`)
         * 
         * @return builder
         * 
         */
        public Builder httpMethod(Output<String> httpMethod) {
            $.httpMethod = httpMethod;
            return this;
        }

        /**
         * @param httpMethod HTTP Method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`)
         * 
         * @return builder
         * 
         */
        public Builder httpMethod(String httpMethod) {
            return httpMethod(Output.of(httpMethod));
        }

        /**
         * @param operationName Function name that will be given to the method when generating an SDK through API Gateway. If omitted, API Gateway will generate a function name based on the resource path and HTTP verb.
         * 
         * @return builder
         * 
         */
        public Builder operationName(@Nullable Output<String> operationName) {
            $.operationName = operationName;
            return this;
        }

        /**
         * @param operationName Function name that will be given to the method when generating an SDK through API Gateway. If omitted, API Gateway will generate a function name based on the resource path and HTTP verb.
         * 
         * @return builder
         * 
         */
        public Builder operationName(String operationName) {
            return operationName(Output.of(operationName));
        }

        /**
         * @param requestModels Map of the API models used for the request&#39;s content type
         * where key is the content type (e.g., `application/json`)
         * and value is either `Error`, `Empty` (built-in models) or `aws.apigateway.Model`&#39;s `name`.
         * 
         * @return builder
         * 
         */
        public Builder requestModels(@Nullable Output<Map<String,String>> requestModels) {
            $.requestModels = requestModels;
            return this;
        }

        /**
         * @param requestModels Map of the API models used for the request&#39;s content type
         * where key is the content type (e.g., `application/json`)
         * and value is either `Error`, `Empty` (built-in models) or `aws.apigateway.Model`&#39;s `name`.
         * 
         * @return builder
         * 
         */
        public Builder requestModels(Map<String,String> requestModels) {
            return requestModels(Output.of(requestModels));
        }

        /**
         * @param requestParameters Map of request parameters (from the path, query string and headers) that should be passed to the integration. The boolean value indicates whether the parameter is required (`true`) or optional (`false`).
         * For example: `request_parameters = {&#34;method.request.header.X-Some-Header&#34; = true &#34;method.request.querystring.some-query-param&#34; = true}` would define that the header `X-Some-Header` and the query string `some-query-param` must be provided in the request.
         * 
         * @return builder
         * 
         */
        public Builder requestParameters(@Nullable Output<Map<String,Boolean>> requestParameters) {
            $.requestParameters = requestParameters;
            return this;
        }

        /**
         * @param requestParameters Map of request parameters (from the path, query string and headers) that should be passed to the integration. The boolean value indicates whether the parameter is required (`true`) or optional (`false`).
         * For example: `request_parameters = {&#34;method.request.header.X-Some-Header&#34; = true &#34;method.request.querystring.some-query-param&#34; = true}` would define that the header `X-Some-Header` and the query string `some-query-param` must be provided in the request.
         * 
         * @return builder
         * 
         */
        public Builder requestParameters(Map<String,Boolean> requestParameters) {
            return requestParameters(Output.of(requestParameters));
        }

        /**
         * @param requestValidatorId ID of a `aws.apigateway.RequestValidator`
         * 
         * @return builder
         * 
         */
        public Builder requestValidatorId(@Nullable Output<String> requestValidatorId) {
            $.requestValidatorId = requestValidatorId;
            return this;
        }

        /**
         * @param requestValidatorId ID of a `aws.apigateway.RequestValidator`
         * 
         * @return builder
         * 
         */
        public Builder requestValidatorId(String requestValidatorId) {
            return requestValidatorId(Output.of(requestValidatorId));
        }

        /**
         * @param resourceId API resource ID
         * 
         * @return builder
         * 
         */
        public Builder resourceId(Output<String> resourceId) {
            $.resourceId = resourceId;
            return this;
        }

        /**
         * @param resourceId API resource ID
         * 
         * @return builder
         * 
         */
        public Builder resourceId(String resourceId) {
            return resourceId(Output.of(resourceId));
        }

        /**
         * @param restApi ID of the associated REST API
         * 
         * @return builder
         * 
         */
        public Builder restApi(Output<String> restApi) {
            $.restApi = restApi;
            return this;
        }

        /**
         * @param restApi ID of the associated REST API
         * 
         * @return builder
         * 
         */
        public Builder restApi(String restApi) {
            return restApi(Output.of(restApi));
        }

        public MethodArgs build() {
            $.authorization = Objects.requireNonNull($.authorization, "expected parameter 'authorization' to be non-null");
            $.httpMethod = Objects.requireNonNull($.httpMethod, "expected parameter 'httpMethod' to be non-null");
            $.resourceId = Objects.requireNonNull($.resourceId, "expected parameter 'resourceId' to be non-null");
            $.restApi = Objects.requireNonNull($.restApi, "expected parameter 'restApi' to be non-null");
            return $;
        }
    }

}
