// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigateway;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.apigateway.IntegrationArgs;
import com.pulumi.aws.apigateway.inputs.IntegrationState;
import com.pulumi.aws.apigateway.outputs.IntegrationTlsConfig;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an HTTP Method Integration for an API Gateway Integration.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import com.pulumi.aws.apigateway.Method;
 * import com.pulumi.aws.apigateway.MethodArgs;
 * import com.pulumi.aws.apigateway.Integration;
 * import com.pulumi.aws.apigateway.IntegrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi(&#34;myDemoAPI&#34;, RestApiArgs.builder()        
 *             .description(&#34;This is my API for demonstration purposes&#34;)
 *             .build());
 * 
 *         var myDemoResource = new Resource(&#34;myDemoResource&#34;, ResourceArgs.builder()        
 *             .restApi(myDemoAPI.id())
 *             .parentId(myDemoAPI.rootResourceId())
 *             .pathPart(&#34;mydemoresource&#34;)
 *             .build());
 * 
 *         var myDemoMethod = new Method(&#34;myDemoMethod&#34;, MethodArgs.builder()        
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod(&#34;GET&#34;)
 *             .authorization(&#34;NONE&#34;)
 *             .build());
 * 
 *         var myDemoIntegration = new Integration(&#34;myDemoIntegration&#34;, IntegrationArgs.builder()        
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod(myDemoMethod.httpMethod())
 *             .type(&#34;MOCK&#34;)
 *             .cacheKeyParameters(&#34;method.request.path.param&#34;)
 *             .cacheNamespace(&#34;foobar&#34;)
 *             .timeoutMilliseconds(29000)
 *             .requestParameters(Map.of(&#34;integration.request.header.X-Authorization&#34;, &#34;&#39;static&#39;&#34;))
 *             .requestTemplates(Map.of(&#34;application/xml&#34;, &#34;&#34;&#34;
 * {
 *    &#34;body&#34; : $input.json(&#39;$&#39;)
 * }
 *             &#34;&#34;&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ## Lambda integration
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import com.pulumi.aws.apigateway.Method;
 * import com.pulumi.aws.apigateway.MethodArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.apigateway.Integration;
 * import com.pulumi.aws.apigateway.IntegrationArgs;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var myregion = config.get(&#34;myregion&#34;);
 *         final var accountId = config.get(&#34;accountId&#34;);
 *         var api = new RestApi(&#34;api&#34;);
 * 
 *         var resource = new Resource(&#34;resource&#34;, ResourceArgs.builder()        
 *             .pathPart(&#34;resource&#34;)
 *             .parentId(api.rootResourceId())
 *             .restApi(api.id())
 *             .build());
 * 
 *         var method = new Method(&#34;method&#34;, MethodArgs.builder()        
 *             .restApi(api.id())
 *             .resourceId(resource.id())
 *             .httpMethod(&#34;GET&#34;)
 *             .authorization(&#34;NONE&#34;)
 *             .build());
 * 
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect(&#34;Allow&#34;)
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type(&#34;Service&#34;)
 *                     .identifiers(&#34;lambda.amazonaws.com&#34;)
 *                     .build())
 *                 .actions(&#34;sts:AssumeRole&#34;)
 *                 .build())
 *             .build());
 * 
 *         var role = new Role(&#34;role&#34;, RoleArgs.builder()        
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *         var lambda = new Function(&#34;lambda&#34;, FunctionArgs.builder()        
 *             .code(new FileArchive(&#34;lambda.zip&#34;))
 *             .role(role.arn())
 *             .handler(&#34;lambda.lambda_handler&#34;)
 *             .runtime(&#34;python3.7&#34;)
 *             .build());
 * 
 *         var integration = new Integration(&#34;integration&#34;, IntegrationArgs.builder()        
 *             .restApi(api.id())
 *             .resourceId(resource.id())
 *             .httpMethod(method.httpMethod())
 *             .integrationHttpMethod(&#34;POST&#34;)
 *             .type(&#34;AWS_PROXY&#34;)
 *             .uri(lambda.invokeArn())
 *             .build());
 * 
 *         var apigwLambda = new Permission(&#34;apigwLambda&#34;, PermissionArgs.builder()        
 *             .action(&#34;lambda:InvokeFunction&#34;)
 *             .function(lambda.name())
 *             .principal(&#34;apigateway.amazonaws.com&#34;)
 *             .sourceArn(Output.tuple(api.id(), method.httpMethod(), resource.path()).applyValue(values -&gt; {
 *                 var id = values.t1;
 *                 var httpMethod = values.t2;
 *                 var path = values.t3;
 *                 return String.format(&#34;arn:aws:execute-api:%s:%s:%s/*{@literal /}%s%s&#34;, myregion,accountId,id,httpMethod,path);
 *             }))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## VPC Link
 * 
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.LoadBalancerArgs;
 * import com.pulumi.aws.apigateway.VpcLink;
 * import com.pulumi.aws.apigateway.VpcLinkArgs;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import com.pulumi.aws.apigateway.Method;
 * import com.pulumi.aws.apigateway.MethodArgs;
 * import com.pulumi.aws.apigateway.Integration;
 * import com.pulumi.aws.apigateway.IntegrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get(&#34;name&#34;);
 *         final var subnetId = config.get(&#34;subnetId&#34;);
 *         var testLoadBalancer = new LoadBalancer(&#34;testLoadBalancer&#34;, LoadBalancerArgs.builder()        
 *             .internal(true)
 *             .loadBalancerType(&#34;network&#34;)
 *             .subnets(subnetId)
 *             .build());
 * 
 *         var testVpcLink = new VpcLink(&#34;testVpcLink&#34;, VpcLinkArgs.builder()        
 *             .targetArn(testLoadBalancer.arn())
 *             .build());
 * 
 *         var testRestApi = new RestApi(&#34;testRestApi&#34;);
 * 
 *         var testResource = new Resource(&#34;testResource&#34;, ResourceArgs.builder()        
 *             .restApi(testRestApi.id())
 *             .parentId(testRestApi.rootResourceId())
 *             .pathPart(&#34;test&#34;)
 *             .build());
 * 
 *         var testMethod = new Method(&#34;testMethod&#34;, MethodArgs.builder()        
 *             .restApi(testRestApi.id())
 *             .resourceId(testResource.id())
 *             .httpMethod(&#34;GET&#34;)
 *             .authorization(&#34;NONE&#34;)
 *             .requestModels(Map.of(&#34;application/json&#34;, &#34;Error&#34;))
 *             .build());
 * 
 *         var testIntegration = new Integration(&#34;testIntegration&#34;, IntegrationArgs.builder()        
 *             .restApi(testRestApi.id())
 *             .resourceId(testResource.id())
 *             .httpMethod(testMethod.httpMethod())
 *             .requestTemplates(Map.ofEntries(
 *                 Map.entry(&#34;application/json&#34;, &#34;&#34;),
 *                 Map.entry(&#34;application/xml&#34;, &#34;&#34;&#34;
 * #set($inputRoot = $input.path(&#39;$&#39;))
 * { }                &#34;&#34;&#34;)
 *             ))
 *             .requestParameters(Map.ofEntries(
 *                 Map.entry(&#34;integration.request.header.X-Authorization&#34;, &#34;&#39;static&#39;&#34;),
 *                 Map.entry(&#34;integration.request.header.X-Foo&#34;, &#34;&#39;Bar&#39;&#34;)
 *             ))
 *             .type(&#34;HTTP&#34;)
 *             .uri(&#34;https://www.google.de&#34;)
 *             .integrationHttpMethod(&#34;GET&#34;)
 *             .passthroughBehavior(&#34;WHEN_NO_MATCH&#34;)
 *             .contentHandling(&#34;CONVERT_TO_TEXT&#34;)
 *             .connectionType(&#34;VPC_LINK&#34;)
 *             .connectionId(testVpcLink.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_api_gateway_integration` using `REST-API-ID/RESOURCE-ID/HTTP-METHOD`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:apigateway/integration:Integration example 12345abcde/67890fghij/GET
 * ```
 * 
 */
@ResourceType(type="aws:apigateway/integration:Integration")
public class Integration extends com.pulumi.resources.CustomResource {
    /**
     * List of cache key parameters for the integration.
     * 
     */
    @Export(name="cacheKeyParameters", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> cacheKeyParameters;

    /**
     * @return List of cache key parameters for the integration.
     * 
     */
    public Output<Optional<List<String>>> cacheKeyParameters() {
        return Codegen.optional(this.cacheKeyParameters);
    }
    /**
     * Integration&#39;s cache namespace.
     * 
     */
    @Export(name="cacheNamespace", refs={String.class}, tree="[0]")
    private Output<String> cacheNamespace;

    /**
     * @return Integration&#39;s cache namespace.
     * 
     */
    public Output<String> cacheNamespace() {
        return this.cacheNamespace;
    }
    /**
     * ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
     * 
     */
    @Export(name="connectionId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> connectionId;

    /**
     * @return ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
     * 
     */
    public Output<Optional<String>> connectionId() {
        return Codegen.optional(this.connectionId);
    }
    /**
     * Integration input&#39;s [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
     * 
     */
    @Export(name="connectionType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> connectionType;

    /**
     * @return Integration input&#39;s [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
     * 
     */
    public Output<Optional<String>> connectionType() {
        return Codegen.optional(this.connectionType);
    }
    /**
     * How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
     * 
     */
    @Export(name="contentHandling", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> contentHandling;

    /**
     * @return How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
     * 
     */
    public Output<Optional<String>> contentHandling() {
        return Codegen.optional(this.contentHandling);
    }
    /**
     * Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role&#39;s ARN. To require that the caller&#39;s identity be passed through from the request, specify the string `arn:aws:iam::\*:user/\*`.
     * 
     */
    @Export(name="credentials", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> credentials;

    /**
     * @return Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role&#39;s ARN. To require that the caller&#39;s identity be passed through from the request, specify the string `arn:aws:iam::\*:user/\*`.
     * 
     */
    public Output<Optional<String>> credentials() {
        return Codegen.optional(this.credentials);
    }
    /**
     * HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
     * when calling the associated resource.
     * 
     */
    @Export(name="httpMethod", refs={String.class}, tree="[0]")
    private Output<String> httpMethod;

    /**
     * @return HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
     * when calling the associated resource.
     * 
     */
    public Output<String> httpMethod() {
        return this.httpMethod;
    }
    /**
     * Integration HTTP method
     * (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
     * **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
     * Not all methods are compatible with all `AWS` integrations.
     * e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
     * 
     */
    @Export(name="integrationHttpMethod", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> integrationHttpMethod;

    /**
     * @return Integration HTTP method
     * (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
     * **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
     * Not all methods are compatible with all `AWS` integrations.
     * e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
     * 
     */
    public Output<Optional<String>> integrationHttpMethod() {
        return Codegen.optional(this.integrationHttpMethod);
    }
    /**
     * Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
     * 
     */
    @Export(name="passthroughBehavior", refs={String.class}, tree="[0]")
    private Output<String> passthroughBehavior;

    /**
     * @return Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
     * 
     */
    public Output<String> passthroughBehavior() {
        return this.passthroughBehavior;
    }
    /**
     * Map of request query string parameters and headers that should be passed to the backend responder.
     * For example: `request_parameters = { &#34;integration.request.header.X-Some-Other-Header&#34; = &#34;method.request.header.X-Some-Header&#34; }`
     * 
     */
    @Export(name="requestParameters", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> requestParameters;

    /**
     * @return Map of request query string parameters and headers that should be passed to the backend responder.
     * For example: `request_parameters = { &#34;integration.request.header.X-Some-Other-Header&#34; = &#34;method.request.header.X-Some-Header&#34; }`
     * 
     */
    public Output<Optional<Map<String,String>>> requestParameters() {
        return Codegen.optional(this.requestParameters);
    }
    /**
     * Map of the integration&#39;s request templates.
     * 
     */
    @Export(name="requestTemplates", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> requestTemplates;

    /**
     * @return Map of the integration&#39;s request templates.
     * 
     */
    public Output<Optional<Map<String,String>>> requestTemplates() {
        return Codegen.optional(this.requestTemplates);
    }
    /**
     * API resource ID.
     * 
     */
    @Export(name="resourceId", refs={String.class}, tree="[0]")
    private Output<String> resourceId;

    /**
     * @return API resource ID.
     * 
     */
    public Output<String> resourceId() {
        return this.resourceId;
    }
    /**
     * ID of the associated REST API.
     * 
     */
    @Export(name="restApi", refs={String.class}, tree="[0]")
    private Output<String> restApi;

    /**
     * @return ID of the associated REST API.
     * 
     */
    public Output<String> restApi() {
        return this.restApi;
    }
    /**
     * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds.
     * 
     */
    @Export(name="timeoutMilliseconds", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> timeoutMilliseconds;

    /**
     * @return Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds.
     * 
     */
    public Output<Optional<Integer>> timeoutMilliseconds() {
        return Codegen.optional(this.timeoutMilliseconds);
    }
    /**
     * TLS configuration. See below.
     * 
     */
    @Export(name="tlsConfig", refs={IntegrationTlsConfig.class}, tree="[0]")
    private Output</* @Nullable */ IntegrationTlsConfig> tlsConfig;

    /**
     * @return TLS configuration. See below.
     * 
     */
    public Output<Optional<IntegrationTlsConfig>> tlsConfig() {
        return Codegen.optional(this.tlsConfig);
    }
    /**
     * Integration input&#39;s [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
     * 
     */
    @Export(name="type", refs={String.class}, tree="[0]")
    private Output<String> type;

    /**
     * @return Integration input&#39;s [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
     * 
     */
    public Output<String> type() {
        return this.type;
    }
    /**
     * Input&#39;s URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
     * For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
     * e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:012345678901:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
     * 
     */
    @Export(name="uri", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> uri;

    /**
     * @return Input&#39;s URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
     * For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
     * e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:012345678901:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
     * 
     */
    public Output<Optional<String>> uri() {
        return Codegen.optional(this.uri);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Integration(String name) {
        this(name, IntegrationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Integration(String name, IntegrationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Integration(String name, IntegrationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:apigateway/integration:Integration", name, args == null ? IntegrationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Integration(String name, Output<String> id, @Nullable IntegrationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:apigateway/integration:Integration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Integration get(String name, Output<String> id, @Nullable IntegrationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Integration(name, id, state, options);
    }
}
