// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigateway;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BasePathMappingArgs extends com.pulumi.resources.ResourceArgs {

    public static final BasePathMappingArgs Empty = new BasePathMappingArgs();

    /**
     * Path segment that must be prepended to the path when accessing the API via this mapping. If omitted, the API is exposed at the root of the given domain.
     * 
     */
    @Import(name="basePath")
    private @Nullable Output<String> basePath;

    /**
     * @return Path segment that must be prepended to the path when accessing the API via this mapping. If omitted, the API is exposed at the root of the given domain.
     * 
     */
    public Optional<Output<String>> basePath() {
        return Optional.ofNullable(this.basePath);
    }

    /**
     * Already-registered domain name to connect the API to.
     * 
     */
    @Import(name="domainName", required=true)
    private Output<String> domainName;

    /**
     * @return Already-registered domain name to connect the API to.
     * 
     */
    public Output<String> domainName() {
        return this.domainName;
    }

    /**
     * ID of the API to connect.
     * 
     */
    @Import(name="restApi", required=true)
    private Output<String> restApi;

    /**
     * @return ID of the API to connect.
     * 
     */
    public Output<String> restApi() {
        return this.restApi;
    }

    /**
     * Name of a specific deployment stage to expose at the given path. If omitted, callers may select any stage by including its name as a path element after the base path.
     * 
     */
    @Import(name="stageName")
    private @Nullable Output<String> stageName;

    /**
     * @return Name of a specific deployment stage to expose at the given path. If omitted, callers may select any stage by including its name as a path element after the base path.
     * 
     */
    public Optional<Output<String>> stageName() {
        return Optional.ofNullable(this.stageName);
    }

    private BasePathMappingArgs() {}

    private BasePathMappingArgs(BasePathMappingArgs $) {
        this.basePath = $.basePath;
        this.domainName = $.domainName;
        this.restApi = $.restApi;
        this.stageName = $.stageName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BasePathMappingArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BasePathMappingArgs $;

        public Builder() {
            $ = new BasePathMappingArgs();
        }

        public Builder(BasePathMappingArgs defaults) {
            $ = new BasePathMappingArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param basePath Path segment that must be prepended to the path when accessing the API via this mapping. If omitted, the API is exposed at the root of the given domain.
         * 
         * @return builder
         * 
         */
        public Builder basePath(@Nullable Output<String> basePath) {
            $.basePath = basePath;
            return this;
        }

        /**
         * @param basePath Path segment that must be prepended to the path when accessing the API via this mapping. If omitted, the API is exposed at the root of the given domain.
         * 
         * @return builder
         * 
         */
        public Builder basePath(String basePath) {
            return basePath(Output.of(basePath));
        }

        /**
         * @param domainName Already-registered domain name to connect the API to.
         * 
         * @return builder
         * 
         */
        public Builder domainName(Output<String> domainName) {
            $.domainName = domainName;
            return this;
        }

        /**
         * @param domainName Already-registered domain name to connect the API to.
         * 
         * @return builder
         * 
         */
        public Builder domainName(String domainName) {
            return domainName(Output.of(domainName));
        }

        /**
         * @param restApi ID of the API to connect.
         * 
         * @return builder
         * 
         */
        public Builder restApi(Output<String> restApi) {
            $.restApi = restApi;
            return this;
        }

        /**
         * @param restApi ID of the API to connect.
         * 
         * @return builder
         * 
         */
        public Builder restApi(String restApi) {
            return restApi(Output.of(restApi));
        }

        /**
         * @param stageName Name of a specific deployment stage to expose at the given path. If omitted, callers may select any stage by including its name as a path element after the base path.
         * 
         * @return builder
         * 
         */
        public Builder stageName(@Nullable Output<String> stageName) {
            $.stageName = stageName;
            return this;
        }

        /**
         * @param stageName Name of a specific deployment stage to expose at the given path. If omitted, callers may select any stage by including its name as a path element after the base path.
         * 
         * @return builder
         * 
         */
        public Builder stageName(String stageName) {
            return stageName(Output.of(stageName));
        }

        public BasePathMappingArgs build() {
            $.domainName = Objects.requireNonNull($.domainName, "expected parameter 'domainName' to be non-null");
            $.restApi = Objects.requireNonNull($.restApi, "expected parameter 'restApi' to be non-null");
            return $;
        }
    }

}
