// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigateway;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.apigateway.AccountArgs;
import com.pulumi.aws.apigateway.inputs.AccountState;
import com.pulumi.aws.apigateway.outputs.AccountThrottleSetting;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a settings of an API Gateway Account. Settings is applied region-wide per `provider` block.
 * 
 * &gt; **Note:** As there is no API method for deleting account settings or resetting it to defaults, destroying this resource will keep your account settings intact
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.apigateway.Account;
 * import com.pulumi.aws.apigateway.AccountArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect(&#34;Allow&#34;)
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type(&#34;Service&#34;)
 *                     .identifiers(&#34;apigateway.amazonaws.com&#34;)
 *                     .build())
 *                 .actions(&#34;sts:AssumeRole&#34;)
 *                 .build())
 *             .build());
 * 
 *         var cloudwatchRole = new Role(&#34;cloudwatchRole&#34;, RoleArgs.builder()        
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *         var demo = new Account(&#34;demo&#34;, AccountArgs.builder()        
 *             .cloudwatchRoleArn(cloudwatchRole.arn())
 *             .build());
 * 
 *         final var cloudwatchPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect(&#34;Allow&#34;)
 *                 .actions(                
 *                     &#34;logs:CreateLogGroup&#34;,
 *                     &#34;logs:CreateLogStream&#34;,
 *                     &#34;logs:DescribeLogGroups&#34;,
 *                     &#34;logs:DescribeLogStreams&#34;,
 *                     &#34;logs:PutLogEvents&#34;,
 *                     &#34;logs:GetLogEvents&#34;,
 *                     &#34;logs:FilterLogEvents&#34;)
 *                 .resources(&#34;*&#34;)
 *                 .build())
 *             .build());
 * 
 *         var cloudwatchRolePolicy = new RolePolicy(&#34;cloudwatchRolePolicy&#34;, RolePolicyArgs.builder()        
 *             .role(cloudwatchRole.id())
 *             .policy(cloudwatchPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import API Gateway Accounts using the word `api-gateway-account`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:apigateway/account:Account demo api-gateway-account
 * ```
 * 
 */
@ResourceType(type="aws:apigateway/account:Account")
public class Account extends com.pulumi.resources.CustomResource {
    /**
     * The version of the API keys used for the account.
     * 
     */
    @Export(name="apiKeyVersion", refs={String.class}, tree="[0]")
    private Output<String> apiKeyVersion;

    /**
     * @return The version of the API keys used for the account.
     * 
     */
    public Output<String> apiKeyVersion() {
        return this.apiKeyVersion;
    }
    /**
     * ARN of an IAM role for CloudWatch (to allow logging &amp; monitoring). See more [in AWS Docs](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-stage-settings.html#how-to-stage-settings-console). Logging &amp; monitoring can be enabled/disabled and otherwise tuned on the API Gateway Stage level.
     * 
     */
    @Export(name="cloudwatchRoleArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> cloudwatchRoleArn;

    /**
     * @return ARN of an IAM role for CloudWatch (to allow logging &amp; monitoring). See more [in AWS Docs](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-stage-settings.html#how-to-stage-settings-console). Logging &amp; monitoring can be enabled/disabled and otherwise tuned on the API Gateway Stage level.
     * 
     */
    public Output<Optional<String>> cloudwatchRoleArn() {
        return Codegen.optional(this.cloudwatchRoleArn);
    }
    /**
     * A list of features supported for the account.
     * 
     */
    @Export(name="features", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> features;

    /**
     * @return A list of features supported for the account.
     * 
     */
    public Output<List<String>> features() {
        return this.features;
    }
    /**
     * Account-Level throttle settings. See exported fields below.
     * 
     */
    @Export(name="throttleSettings", refs={List.class,AccountThrottleSetting.class}, tree="[0,1]")
    private Output<List<AccountThrottleSetting>> throttleSettings;

    /**
     * @return Account-Level throttle settings. See exported fields below.
     * 
     */
    public Output<List<AccountThrottleSetting>> throttleSettings() {
        return this.throttleSettings;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Account(String name) {
        this(name, AccountArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Account(String name, @Nullable AccountArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Account(String name, @Nullable AccountArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:apigateway/account:Account", name, args == null ? AccountArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Account(String name, Output<String> id, @Nullable AccountState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:apigateway/account:Account", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Account get(String name, Output<String> id, @Nullable AccountState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Account(name, id, state, options);
    }
}
