// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.amplify;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.amplify.DomainAssociationArgs;
import com.pulumi.aws.amplify.inputs.DomainAssociationState;
import com.pulumi.aws.amplify.outputs.DomainAssociationSubDomain;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an Amplify Domain Association resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.inputs.AppCustomRuleArgs;
 * import com.pulumi.aws.amplify.Branch;
 * import com.pulumi.aws.amplify.BranchArgs;
 * import com.pulumi.aws.amplify.DomainAssociation;
 * import com.pulumi.aws.amplify.DomainAssociationArgs;
 * import com.pulumi.aws.amplify.inputs.DomainAssociationSubDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleApp = new App(&#34;exampleApp&#34;, AppArgs.builder()        
 *             .customRules(AppCustomRuleArgs.builder()
 *                 .source(&#34;https://example.com&#34;)
 *                 .status(&#34;302&#34;)
 *                 .target(&#34;https://www.example.com&#34;)
 *                 .build())
 *             .build());
 * 
 *         var master = new Branch(&#34;master&#34;, BranchArgs.builder()        
 *             .appId(exampleApp.id())
 *             .branchName(&#34;master&#34;)
 *             .build());
 * 
 *         var exampleDomainAssociation = new DomainAssociation(&#34;exampleDomainAssociation&#34;, DomainAssociationArgs.builder()        
 *             .appId(exampleApp.id())
 *             .domainName(&#34;example.com&#34;)
 *             .subDomains(            
 *                 DomainAssociationSubDomainArgs.builder()
 *                     .branchName(master.branchName())
 *                     .prefix(&#34;&#34;)
 *                     .build(),
 *                 DomainAssociationSubDomainArgs.builder()
 *                     .branchName(master.branchName())
 *                     .prefix(&#34;www&#34;)
 *                     .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Amplify domain association using `app_id` and `domain_name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:amplify/domainAssociation:DomainAssociation app d2ypk4k47z8u6/example.com
 * ```
 * 
 */
@ResourceType(type="aws:amplify/domainAssociation:DomainAssociation")
public class DomainAssociation extends com.pulumi.resources.CustomResource {
    /**
     * Unique ID for an Amplify app.
     * 
     */
    @Export(name="appId", refs={String.class}, tree="[0]")
    private Output<String> appId;

    /**
     * @return Unique ID for an Amplify app.
     * 
     */
    public Output<String> appId() {
        return this.appId;
    }
    /**
     * ARN for the domain association.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN for the domain association.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The DNS record for certificate verification.
     * 
     */
    @Export(name="certificateVerificationDnsRecord", refs={String.class}, tree="[0]")
    private Output<String> certificateVerificationDnsRecord;

    /**
     * @return The DNS record for certificate verification.
     * 
     */
    public Output<String> certificateVerificationDnsRecord() {
        return this.certificateVerificationDnsRecord;
    }
    /**
     * Domain name for the domain association.
     * 
     */
    @Export(name="domainName", refs={String.class}, tree="[0]")
    private Output<String> domainName;

    /**
     * @return Domain name for the domain association.
     * 
     */
    public Output<String> domainName() {
        return this.domainName;
    }
    /**
     * Enables the automated creation of subdomains for branches.
     * 
     */
    @Export(name="enableAutoSubDomain", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enableAutoSubDomain;

    /**
     * @return Enables the automated creation of subdomains for branches.
     * 
     */
    public Output<Optional<Boolean>> enableAutoSubDomain() {
        return Codegen.optional(this.enableAutoSubDomain);
    }
    /**
     * Setting for the subdomain. Documented below.
     * 
     */
    @Export(name="subDomains", refs={List.class,DomainAssociationSubDomain.class}, tree="[0,1]")
    private Output<List<DomainAssociationSubDomain>> subDomains;

    /**
     * @return Setting for the subdomain. Documented below.
     * 
     */
    public Output<List<DomainAssociationSubDomain>> subDomains() {
        return this.subDomains;
    }
    /**
     * If enabled, the resource will wait for the domain association status to change to `PENDING_DEPLOYMENT` or `AVAILABLE`. Setting this to `false` will skip the process. Default: `true`.
     * 
     */
    @Export(name="waitForVerification", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> waitForVerification;

    /**
     * @return If enabled, the resource will wait for the domain association status to change to `PENDING_DEPLOYMENT` or `AVAILABLE`. Setting this to `false` will skip the process. Default: `true`.
     * 
     */
    public Output<Optional<Boolean>> waitForVerification() {
        return Codegen.optional(this.waitForVerification);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public DomainAssociation(String name) {
        this(name, DomainAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public DomainAssociation(String name, DomainAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public DomainAssociation(String name, DomainAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:amplify/domainAssociation:DomainAssociation", name, args == null ? DomainAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private DomainAssociation(String name, Output<String> id, @Nullable DomainAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:amplify/domainAssociation:DomainAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static DomainAssociation get(String name, Output<String> id, @Nullable DomainAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new DomainAssociation(name, id, state, options);
    }
}
