// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.amp;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.amp.AlertManagerDefinitionArgs;
import com.pulumi.aws.amp.inputs.AlertManagerDefinitionState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Manages an Amazon Managed Service for Prometheus (AMP) Alert Manager Definition
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amp.Workspace;
 * import com.pulumi.aws.amp.AlertManagerDefinition;
 * import com.pulumi.aws.amp.AlertManagerDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var demoWorkspace = new Workspace(&#34;demoWorkspace&#34;);
 * 
 *         var demoAlertManagerDefinition = new AlertManagerDefinition(&#34;demoAlertManagerDefinition&#34;, AlertManagerDefinitionArgs.builder()        
 *             .workspaceId(demoWorkspace.id())
 *             .definition(&#34;&#34;&#34;
 * alertmanager_config: |
 *   route:
 *     receiver: &#39;default&#39;
 *   receivers:
 *     - name: &#39;default&#39;
 *             &#34;&#34;&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import the prometheus alert manager definition using the workspace identifier. For example:
 * 
 * ```sh
 *  $ pulumi import aws:amp/alertManagerDefinition:AlertManagerDefinition demo ws-C6DCB907-F2D7-4D96-957B-66691F865D8B
 * ```
 * 
 */
@ResourceType(type="aws:amp/alertManagerDefinition:AlertManagerDefinition")
public class AlertManagerDefinition extends com.pulumi.resources.CustomResource {
    /**
     * the alert manager definition that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-alert-manager.html).
     * 
     */
    @Export(name="definition", refs={String.class}, tree="[0]")
    private Output<String> definition;

    /**
     * @return the alert manager definition that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-alert-manager.html).
     * 
     */
    public Output<String> definition() {
        return this.definition;
    }
    /**
     * ID of the prometheus workspace the alert manager definition should be linked to
     * 
     */
    @Export(name="workspaceId", refs={String.class}, tree="[0]")
    private Output<String> workspaceId;

    /**
     * @return ID of the prometheus workspace the alert manager definition should be linked to
     * 
     */
    public Output<String> workspaceId() {
        return this.workspaceId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AlertManagerDefinition(String name) {
        this(name, AlertManagerDefinitionArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AlertManagerDefinition(String name, AlertManagerDefinitionArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AlertManagerDefinition(String name, AlertManagerDefinitionArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:amp/alertManagerDefinition:AlertManagerDefinition", name, args == null ? AlertManagerDefinitionArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AlertManagerDefinition(String name, Output<String> id, @Nullable AlertManagerDefinitionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:amp/alertManagerDefinition:AlertManagerDefinition", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AlertManagerDefinition get(String name, Output<String> id, @Nullable AlertManagerDefinitionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AlertManagerDefinition(name, id, state, options);
    }
}
