// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.alb.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class LoadBalancerAccessLogsArgs extends com.pulumi.resources.ResourceArgs {

    public static final LoadBalancerAccessLogsArgs Empty = new LoadBalancerAccessLogsArgs();

    /**
     * The S3 bucket name to store the logs in.
     * 
     */
    @Import(name="bucket", required=true)
    private Output<String> bucket;

    /**
     * @return The S3 bucket name to store the logs in.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }

    /**
     * Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
     * 
     */
    @Import(name="enabled")
    private @Nullable Output<Boolean> enabled;

    /**
     * @return Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
     * 
     */
    public Optional<Output<Boolean>> enabled() {
        return Optional.ofNullable(this.enabled);
    }

    /**
     * The S3 bucket prefix. Logs are stored in the root if not configured.
     * 
     */
    @Import(name="prefix")
    private @Nullable Output<String> prefix;

    /**
     * @return The S3 bucket prefix. Logs are stored in the root if not configured.
     * 
     */
    public Optional<Output<String>> prefix() {
        return Optional.ofNullable(this.prefix);
    }

    private LoadBalancerAccessLogsArgs() {}

    private LoadBalancerAccessLogsArgs(LoadBalancerAccessLogsArgs $) {
        this.bucket = $.bucket;
        this.enabled = $.enabled;
        this.prefix = $.prefix;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(LoadBalancerAccessLogsArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private LoadBalancerAccessLogsArgs $;

        public Builder() {
            $ = new LoadBalancerAccessLogsArgs();
        }

        public Builder(LoadBalancerAccessLogsArgs defaults) {
            $ = new LoadBalancerAccessLogsArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param bucket The S3 bucket name to store the logs in.
         * 
         * @return builder
         * 
         */
        public Builder bucket(Output<String> bucket) {
            $.bucket = bucket;
            return this;
        }

        /**
         * @param bucket The S3 bucket name to store the logs in.
         * 
         * @return builder
         * 
         */
        public Builder bucket(String bucket) {
            return bucket(Output.of(bucket));
        }

        /**
         * @param enabled Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
         * 
         * @return builder
         * 
         */
        public Builder enabled(@Nullable Output<Boolean> enabled) {
            $.enabled = enabled;
            return this;
        }

        /**
         * @param enabled Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
         * 
         * @return builder
         * 
         */
        public Builder enabled(Boolean enabled) {
            return enabled(Output.of(enabled));
        }

        /**
         * @param prefix The S3 bucket prefix. Logs are stored in the root if not configured.
         * 
         * @return builder
         * 
         */
        public Builder prefix(@Nullable Output<String> prefix) {
            $.prefix = prefix;
            return this;
        }

        /**
         * @param prefix The S3 bucket prefix. Logs are stored in the root if not configured.
         * 
         * @return builder
         * 
         */
        public Builder prefix(String prefix) {
            return prefix(Output.of(prefix));
        }

        public LoadBalancerAccessLogsArgs build() {
            $.bucket = Objects.requireNonNull($.bucket, "expected parameter 'bucket' to be non-null");
            return $;
        }
    }

}
