// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.acmpca;

import com.pulumi.aws.acmpca.inputs.CertificateValidityArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class CertificateArgs extends com.pulumi.resources.ResourceArgs {

    public static final CertificateArgs Empty = new CertificateArgs();

    /**
     * Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
     * 
     */
    @Import(name="apiPassthrough")
    private @Nullable Output<String> apiPassthrough;

    /**
     * @return Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
     * 
     */
    public Optional<Output<String>> apiPassthrough() {
        return Optional.ofNullable(this.apiPassthrough);
    }

    /**
     * ARN of the certificate authority.
     * 
     */
    @Import(name="certificateAuthorityArn", required=true)
    private Output<String> certificateAuthorityArn;

    /**
     * @return ARN of the certificate authority.
     * 
     */
    public Output<String> certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    /**
     * Certificate Signing Request in PEM format.
     * 
     */
    @Import(name="certificateSigningRequest", required=true)
    private Output<String> certificateSigningRequest;

    /**
     * @return Certificate Signing Request in PEM format.
     * 
     */
    public Output<String> certificateSigningRequest() {
        return this.certificateSigningRequest;
    }

    /**
     * Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
     * 
     */
    @Import(name="signingAlgorithm", required=true)
    private Output<String> signingAlgorithm;

    /**
     * @return Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
     * 
     */
    public Output<String> signingAlgorithm() {
        return this.signingAlgorithm;
    }

    /**
     * Template to use when issuing a certificate.
     * See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
     * 
     */
    @Import(name="templateArn")
    private @Nullable Output<String> templateArn;

    /**
     * @return Template to use when issuing a certificate.
     * See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
     * 
     */
    public Optional<Output<String>> templateArn() {
        return Optional.ofNullable(this.templateArn);
    }

    /**
     * Configures end of the validity period for the certificate. See validity block below.
     * 
     */
    @Import(name="validity", required=true)
    private Output<CertificateValidityArgs> validity;

    /**
     * @return Configures end of the validity period for the certificate. See validity block below.
     * 
     */
    public Output<CertificateValidityArgs> validity() {
        return this.validity;
    }

    private CertificateArgs() {}

    private CertificateArgs(CertificateArgs $) {
        this.apiPassthrough = $.apiPassthrough;
        this.certificateAuthorityArn = $.certificateAuthorityArn;
        this.certificateSigningRequest = $.certificateSigningRequest;
        this.signingAlgorithm = $.signingAlgorithm;
        this.templateArn = $.templateArn;
        this.validity = $.validity;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(CertificateArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private CertificateArgs $;

        public Builder() {
            $ = new CertificateArgs();
        }

        public Builder(CertificateArgs defaults) {
            $ = new CertificateArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param apiPassthrough Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
         * 
         * @return builder
         * 
         */
        public Builder apiPassthrough(@Nullable Output<String> apiPassthrough) {
            $.apiPassthrough = apiPassthrough;
            return this;
        }

        /**
         * @param apiPassthrough Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
         * 
         * @return builder
         * 
         */
        public Builder apiPassthrough(String apiPassthrough) {
            return apiPassthrough(Output.of(apiPassthrough));
        }

        /**
         * @param certificateAuthorityArn ARN of the certificate authority.
         * 
         * @return builder
         * 
         */
        public Builder certificateAuthorityArn(Output<String> certificateAuthorityArn) {
            $.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        /**
         * @param certificateAuthorityArn ARN of the certificate authority.
         * 
         * @return builder
         * 
         */
        public Builder certificateAuthorityArn(String certificateAuthorityArn) {
            return certificateAuthorityArn(Output.of(certificateAuthorityArn));
        }

        /**
         * @param certificateSigningRequest Certificate Signing Request in PEM format.
         * 
         * @return builder
         * 
         */
        public Builder certificateSigningRequest(Output<String> certificateSigningRequest) {
            $.certificateSigningRequest = certificateSigningRequest;
            return this;
        }

        /**
         * @param certificateSigningRequest Certificate Signing Request in PEM format.
         * 
         * @return builder
         * 
         */
        public Builder certificateSigningRequest(String certificateSigningRequest) {
            return certificateSigningRequest(Output.of(certificateSigningRequest));
        }

        /**
         * @param signingAlgorithm Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
         * 
         * @return builder
         * 
         */
        public Builder signingAlgorithm(Output<String> signingAlgorithm) {
            $.signingAlgorithm = signingAlgorithm;
            return this;
        }

        /**
         * @param signingAlgorithm Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
         * 
         * @return builder
         * 
         */
        public Builder signingAlgorithm(String signingAlgorithm) {
            return signingAlgorithm(Output.of(signingAlgorithm));
        }

        /**
         * @param templateArn Template to use when issuing a certificate.
         * See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
         * 
         * @return builder
         * 
         */
        public Builder templateArn(@Nullable Output<String> templateArn) {
            $.templateArn = templateArn;
            return this;
        }

        /**
         * @param templateArn Template to use when issuing a certificate.
         * See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
         * 
         * @return builder
         * 
         */
        public Builder templateArn(String templateArn) {
            return templateArn(Output.of(templateArn));
        }

        /**
         * @param validity Configures end of the validity period for the certificate. See validity block below.
         * 
         * @return builder
         * 
         */
        public Builder validity(Output<CertificateValidityArgs> validity) {
            $.validity = validity;
            return this;
        }

        /**
         * @param validity Configures end of the validity period for the certificate. See validity block below.
         * 
         * @return builder
         * 
         */
        public Builder validity(CertificateValidityArgs validity) {
            return validity(Output.of(validity));
        }

        public CertificateArgs build() {
            $.certificateAuthorityArn = Objects.requireNonNull($.certificateAuthorityArn, "expected parameter 'certificateAuthorityArn' to be non-null");
            $.certificateSigningRequest = Objects.requireNonNull($.certificateSigningRequest, "expected parameter 'certificateSigningRequest' to be non-null");
            $.signingAlgorithm = Objects.requireNonNull($.signingAlgorithm, "expected parameter 'signingAlgorithm' to be non-null");
            $.validity = Objects.requireNonNull($.validity, "expected parameter 'validity' to be non-null");
            return $;
        }
    }

}
