// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.acmpca;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.acmpca.CertificateArgs;
import com.pulumi.aws.acmpca.inputs.CertificateState;
import com.pulumi.aws.acmpca.outputs.CertificateValidity;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to issue a certificate using AWS Certificate Manager Private Certificate Authority (ACM PCA).
 * 
 * Certificates created using `aws.acmpca.Certificate` are not eligible for automatic renewal,
 * and must be replaced instead.
 * To issue a renewable certificate using an ACM PCA, create a `aws.acm.Certificate`
 * with the parameter `certificate_authority_arn`.
 * 
 * ## Example Usage
 * ### Basic
 * 
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.tls.PrivateKey;
 * import com.pulumi.tls.PrivateKeyArgs;
 * import com.pulumi.tls.CertRequest;
 * import com.pulumi.tls.CertRequestArgs;
 * import com.pulumi.tls.inputs.CertRequestSubjectArgs;
 * import com.pulumi.aws.acmpca.Certificate;
 * import com.pulumi.aws.acmpca.CertificateArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateValidityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleCertificateAuthority = new CertificateAuthority(&#34;exampleCertificateAuthority&#34;, CertificateAuthorityArgs.builder()        
 *             .privateCertificateConfiguration(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .permanentDeletionTimeInDays(7)
 *             .build());
 * 
 *         var key = new PrivateKey(&#34;key&#34;, PrivateKeyArgs.builder()        
 *             .algorithm(&#34;RSA&#34;)
 *             .build());
 * 
 *         var csr = new CertRequest(&#34;csr&#34;, CertRequestArgs.builder()        
 *             .keyAlgorithm(&#34;RSA&#34;)
 *             .privateKeyPem(key.privateKeyPem())
 *             .subject(CertRequestSubjectArgs.builder()
 *                 .commonName(&#34;example&#34;)
 *                 .build())
 *             .build());
 * 
 *         var exampleCertificate = new Certificate(&#34;exampleCertificate&#34;, CertificateArgs.builder()        
 *             .certificateAuthorityArn(exampleCertificateAuthority.arn())
 *             .certificateSigningRequest(csr.certRequestPem())
 *             .signingAlgorithm(&#34;SHA256WITHRSA&#34;)
 *             .validity(CertificateValidityArgs.builder()
 *                 .type(&#34;YEARS&#34;)
 *                 .value(1)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import ACM PCA Certificates using their ARN. For example:
 * 
 * ```sh
 *  $ pulumi import aws:acmpca/certificate:Certificate cert arn:aws:acm-pca:eu-west-1:675225743824:certificate-authority/08319ede-83g9-1400-8f21-c7d12b2b6edb/certificate/a4e9c2aa4bcfab625g1b9136464cd3a
 * ```
 * 
 */
@ResourceType(type="aws:acmpca/certificate:Certificate")
public class Certificate extends com.pulumi.resources.CustomResource {
    /**
     * Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
     * 
     */
    @Export(name="apiPassthrough", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> apiPassthrough;

    /**
     * @return Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
     * 
     */
    public Output<Optional<String>> apiPassthrough() {
        return Codegen.optional(this.apiPassthrough);
    }
    /**
     * ARN of the certificate.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the certificate.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * PEM-encoded certificate value.
     * 
     */
    @Export(name="certificate", refs={String.class}, tree="[0]")
    private Output<String> certificate;

    /**
     * @return PEM-encoded certificate value.
     * 
     */
    public Output<String> certificate() {
        return this.certificate;
    }
    /**
     * ARN of the certificate authority.
     * 
     */
    @Export(name="certificateAuthorityArn", refs={String.class}, tree="[0]")
    private Output<String> certificateAuthorityArn;

    /**
     * @return ARN of the certificate authority.
     * 
     */
    public Output<String> certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }
    /**
     * PEM-encoded certificate chain that includes any intermediate certificates and chains up to root CA.
     * 
     */
    @Export(name="certificateChain", refs={String.class}, tree="[0]")
    private Output<String> certificateChain;

    /**
     * @return PEM-encoded certificate chain that includes any intermediate certificates and chains up to root CA.
     * 
     */
    public Output<String> certificateChain() {
        return this.certificateChain;
    }
    /**
     * Certificate Signing Request in PEM format.
     * 
     */
    @Export(name="certificateSigningRequest", refs={String.class}, tree="[0]")
    private Output<String> certificateSigningRequest;

    /**
     * @return Certificate Signing Request in PEM format.
     * 
     */
    public Output<String> certificateSigningRequest() {
        return this.certificateSigningRequest;
    }
    /**
     * Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
     * 
     */
    @Export(name="signingAlgorithm", refs={String.class}, tree="[0]")
    private Output<String> signingAlgorithm;

    /**
     * @return Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
     * 
     */
    public Output<String> signingAlgorithm() {
        return this.signingAlgorithm;
    }
    /**
     * Template to use when issuing a certificate.
     * See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
     * 
     */
    @Export(name="templateArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> templateArn;

    /**
     * @return Template to use when issuing a certificate.
     * See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
     * 
     */
    public Output<Optional<String>> templateArn() {
        return Codegen.optional(this.templateArn);
    }
    /**
     * Configures end of the validity period for the certificate. See validity block below.
     * 
     */
    @Export(name="validity", refs={CertificateValidity.class}, tree="[0]")
    private Output<CertificateValidity> validity;

    /**
     * @return Configures end of the validity period for the certificate. See validity block below.
     * 
     */
    public Output<CertificateValidity> validity() {
        return this.validity;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Certificate(String name) {
        this(name, CertificateArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Certificate(String name, CertificateArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Certificate(String name, CertificateArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:acmpca/certificate:Certificate", name, args == null ? CertificateArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Certificate(String name, Output<String> id, @Nullable CertificateState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:acmpca/certificate:Certificate", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Certificate get(String name, Output<String> id, @Nullable CertificateState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Certificate(name, id, state, options);
    }
}
