// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.acm.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;


public final class CertificateValidationOptionArgs extends com.pulumi.resources.ResourceArgs {

    public static final CertificateValidationOptionArgs Empty = new CertificateValidationOptionArgs();

    /**
     * Fully qualified domain name (FQDN) in the certificate.
     * 
     */
    @Import(name="domainName", required=true)
    private Output<String> domainName;

    /**
     * @return Fully qualified domain name (FQDN) in the certificate.
     * 
     */
    public Output<String> domainName() {
        return this.domainName;
    }

    /**
     * Domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `domain_name` value or a superdomain of the `domain_name` value. For example, if you request a certificate for `&#34;testing.example.com&#34;`, you can specify `&#34;example.com&#34;` for this value.
     * 
     */
    @Import(name="validationDomain", required=true)
    private Output<String> validationDomain;

    /**
     * @return Domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `domain_name` value or a superdomain of the `domain_name` value. For example, if you request a certificate for `&#34;testing.example.com&#34;`, you can specify `&#34;example.com&#34;` for this value.
     * 
     */
    public Output<String> validationDomain() {
        return this.validationDomain;
    }

    private CertificateValidationOptionArgs() {}

    private CertificateValidationOptionArgs(CertificateValidationOptionArgs $) {
        this.domainName = $.domainName;
        this.validationDomain = $.validationDomain;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(CertificateValidationOptionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private CertificateValidationOptionArgs $;

        public Builder() {
            $ = new CertificateValidationOptionArgs();
        }

        public Builder(CertificateValidationOptionArgs defaults) {
            $ = new CertificateValidationOptionArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param domainName Fully qualified domain name (FQDN) in the certificate.
         * 
         * @return builder
         * 
         */
        public Builder domainName(Output<String> domainName) {
            $.domainName = domainName;
            return this;
        }

        /**
         * @param domainName Fully qualified domain name (FQDN) in the certificate.
         * 
         * @return builder
         * 
         */
        public Builder domainName(String domainName) {
            return domainName(Output.of(domainName));
        }

        /**
         * @param validationDomain Domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `domain_name` value or a superdomain of the `domain_name` value. For example, if you request a certificate for `&#34;testing.example.com&#34;`, you can specify `&#34;example.com&#34;` for this value.
         * 
         * @return builder
         * 
         */
        public Builder validationDomain(Output<String> validationDomain) {
            $.validationDomain = validationDomain;
            return this;
        }

        /**
         * @param validationDomain Domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `domain_name` value or a superdomain of the `domain_name` value. For example, if you request a certificate for `&#34;testing.example.com&#34;`, you can specify `&#34;example.com&#34;` for this value.
         * 
         * @return builder
         * 
         */
        public Builder validationDomain(String validationDomain) {
            return validationDomain(Output.of(validationDomain));
        }

        public CertificateValidationOptionArgs build() {
            $.domainName = Objects.requireNonNull($.domainName, "expected parameter 'domainName' to be non-null");
            $.validationDomain = Objects.requireNonNull($.validationDomain, "expected parameter 'validationDomain' to be non-null");
            return $;
        }
    }

}
