// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.account;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.account.PrimaryContactArgs;
import com.pulumi.aws.account.inputs.PrimaryContactState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages the specified primary contact information associated with an AWS Account.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.account.PrimaryContact;
 * import com.pulumi.aws.account.PrimaryContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new PrimaryContact(&#34;test&#34;, PrimaryContactArgs.builder()        
 *             .addressLine1(&#34;123 Any Street&#34;)
 *             .city(&#34;Seattle&#34;)
 *             .companyName(&#34;Example Corp, Inc.&#34;)
 *             .countryCode(&#34;US&#34;)
 *             .districtOrCounty(&#34;King&#34;)
 *             .fullName(&#34;My Name&#34;)
 *             .phoneNumber(&#34;+64211111111&#34;)
 *             .postalCode(&#34;98101&#34;)
 *             .stateOrRegion(&#34;WA&#34;)
 *             .websiteUrl(&#34;https://www.examplecorp.com&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import the Primary Contact using the `account_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:account/primaryContact:PrimaryContact test 1234567890
 * ```
 * 
 */
@ResourceType(type="aws:account/primaryContact:PrimaryContact")
public class PrimaryContact extends com.pulumi.resources.CustomResource {
    /**
     * The ID of the target account when managing member accounts. Will manage current user&#39;s account by default if omitted.
     * 
     */
    @Export(name="accountId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> accountId;

    /**
     * @return The ID of the target account when managing member accounts. Will manage current user&#39;s account by default if omitted.
     * 
     */
    public Output<Optional<String>> accountId() {
        return Codegen.optional(this.accountId);
    }
    /**
     * The first line of the primary contact address.
     * 
     */
    @Export(name="addressLine1", refs={String.class}, tree="[0]")
    private Output<String> addressLine1;

    /**
     * @return The first line of the primary contact address.
     * 
     */
    public Output<String> addressLine1() {
        return this.addressLine1;
    }
    /**
     * The second line of the primary contact address, if any.
     * 
     */
    @Export(name="addressLine2", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> addressLine2;

    /**
     * @return The second line of the primary contact address, if any.
     * 
     */
    public Output<Optional<String>> addressLine2() {
        return Codegen.optional(this.addressLine2);
    }
    /**
     * The third line of the primary contact address, if any.
     * 
     */
    @Export(name="addressLine3", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> addressLine3;

    /**
     * @return The third line of the primary contact address, if any.
     * 
     */
    public Output<Optional<String>> addressLine3() {
        return Codegen.optional(this.addressLine3);
    }
    /**
     * The city of the primary contact address.
     * 
     */
    @Export(name="city", refs={String.class}, tree="[0]")
    private Output<String> city;

    /**
     * @return The city of the primary contact address.
     * 
     */
    public Output<String> city() {
        return this.city;
    }
    /**
     * The name of the company associated with the primary contact information, if any.
     * 
     */
    @Export(name="companyName", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> companyName;

    /**
     * @return The name of the company associated with the primary contact information, if any.
     * 
     */
    public Output<Optional<String>> companyName() {
        return Codegen.optional(this.companyName);
    }
    /**
     * The ISO-3166 two-letter country code for the primary contact address.
     * 
     */
    @Export(name="countryCode", refs={String.class}, tree="[0]")
    private Output<String> countryCode;

    /**
     * @return The ISO-3166 two-letter country code for the primary contact address.
     * 
     */
    public Output<String> countryCode() {
        return this.countryCode;
    }
    /**
     * The district or county of the primary contact address, if any.
     * 
     */
    @Export(name="districtOrCounty", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> districtOrCounty;

    /**
     * @return The district or county of the primary contact address, if any.
     * 
     */
    public Output<Optional<String>> districtOrCounty() {
        return Codegen.optional(this.districtOrCounty);
    }
    /**
     * The full name of the primary contact address.
     * 
     */
    @Export(name="fullName", refs={String.class}, tree="[0]")
    private Output<String> fullName;

    /**
     * @return The full name of the primary contact address.
     * 
     */
    public Output<String> fullName() {
        return this.fullName;
    }
    /**
     * The phone number of the primary contact information. The number will be validated and, in some countries, checked for activation.
     * 
     */
    @Export(name="phoneNumber", refs={String.class}, tree="[0]")
    private Output<String> phoneNumber;

    /**
     * @return The phone number of the primary contact information. The number will be validated and, in some countries, checked for activation.
     * 
     */
    public Output<String> phoneNumber() {
        return this.phoneNumber;
    }
    /**
     * The postal code of the primary contact address.
     * 
     */
    @Export(name="postalCode", refs={String.class}, tree="[0]")
    private Output<String> postalCode;

    /**
     * @return The postal code of the primary contact address.
     * 
     */
    public Output<String> postalCode() {
        return this.postalCode;
    }
    /**
     * The state or region of the primary contact address. This field is required in selected countries.
     * 
     */
    @Export(name="stateOrRegion", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> stateOrRegion;

    /**
     * @return The state or region of the primary contact address. This field is required in selected countries.
     * 
     */
    public Output<Optional<String>> stateOrRegion() {
        return Codegen.optional(this.stateOrRegion);
    }
    /**
     * The URL of the website associated with the primary contact information, if any.
     * 
     */
    @Export(name="websiteUrl", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> websiteUrl;

    /**
     * @return The URL of the website associated with the primary contact information, if any.
     * 
     */
    public Output<Optional<String>> websiteUrl() {
        return Codegen.optional(this.websiteUrl);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public PrimaryContact(String name) {
        this(name, PrimaryContactArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public PrimaryContact(String name, PrimaryContactArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public PrimaryContact(String name, PrimaryContactArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:account/primaryContact:PrimaryContact", name, args == null ? PrimaryContactArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private PrimaryContact(String name, Output<String> id, @Nullable PrimaryContactState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:account/primaryContact:PrimaryContact", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static PrimaryContact get(String name, Output<String> id, @Nullable PrimaryContactState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new PrimaryContact(name, id, state, options);
    }
}
