// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws;

import com.pulumi.aws.inputs.ProviderAssumeRoleArgs;
import com.pulumi.aws.inputs.ProviderAssumeRoleWithWebIdentityArgs;
import com.pulumi.aws.inputs.ProviderDefaultTagsArgs;
import com.pulumi.aws.inputs.ProviderEndpointArgs;
import com.pulumi.aws.inputs.ProviderIgnoreTagsArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ProviderArgs extends com.pulumi.resources.ResourceArgs {

    public static final ProviderArgs Empty = new ProviderArgs();

    /**
     * The access key for API operations. You can retrieve this from the &#39;Security &amp; Credentials&#39; section of the AWS console.
     * 
     */
    @Import(name="accessKey")
    private @Nullable Output<String> accessKey;

    /**
     * @return The access key for API operations. You can retrieve this from the &#39;Security &amp; Credentials&#39; section of the AWS console.
     * 
     */
    public Optional<Output<String>> accessKey() {
        return Optional.ofNullable(this.accessKey);
    }

    @Import(name="allowedAccountIds", json=true)
    private @Nullable Output<List<String>> allowedAccountIds;

    public Optional<Output<List<String>>> allowedAccountIds() {
        return Optional.ofNullable(this.allowedAccountIds);
    }

    @Import(name="assumeRole", json=true)
    private @Nullable Output<ProviderAssumeRoleArgs> assumeRole;

    public Optional<Output<ProviderAssumeRoleArgs>> assumeRole() {
        return Optional.ofNullable(this.assumeRole);
    }

    @Import(name="assumeRoleWithWebIdentity", json=true)
    private @Nullable Output<ProviderAssumeRoleWithWebIdentityArgs> assumeRoleWithWebIdentity;

    public Optional<Output<ProviderAssumeRoleWithWebIdentityArgs>> assumeRoleWithWebIdentity() {
        return Optional.ofNullable(this.assumeRoleWithWebIdentity);
    }

    /**
     * File containing custom root and intermediate certificates. Can also be configured using the `AWS_CA_BUNDLE` environment
     * variable. (Setting `ca_bundle` in the shared config file is not supported.)
     * 
     */
    @Import(name="customCaBundle")
    private @Nullable Output<String> customCaBundle;

    /**
     * @return File containing custom root and intermediate certificates. Can also be configured using the `AWS_CA_BUNDLE` environment
     * variable. (Setting `ca_bundle` in the shared config file is not supported.)
     * 
     */
    public Optional<Output<String>> customCaBundle() {
        return Optional.ofNullable(this.customCaBundle);
    }

    /**
     * Configuration block with settings to default resource tags across all resources.
     * 
     */
    @Import(name="defaultTags", json=true)
    private @Nullable Output<ProviderDefaultTagsArgs> defaultTags;

    /**
     * @return Configuration block with settings to default resource tags across all resources.
     * 
     */
    public Optional<Output<ProviderDefaultTagsArgs>> defaultTags() {
        return Optional.ofNullable(this.defaultTags);
    }

    /**
     * Address of the EC2 metadata service endpoint to use. Can also be configured using the
     * `AWS_EC2_METADATA_SERVICE_ENDPOINT` environment variable.
     * 
     */
    @Import(name="ec2MetadataServiceEndpoint")
    private @Nullable Output<String> ec2MetadataServiceEndpoint;

    /**
     * @return Address of the EC2 metadata service endpoint to use. Can also be configured using the
     * `AWS_EC2_METADATA_SERVICE_ENDPOINT` environment variable.
     * 
     */
    public Optional<Output<String>> ec2MetadataServiceEndpoint() {
        return Optional.ofNullable(this.ec2MetadataServiceEndpoint);
    }

    /**
     * Protocol to use with EC2 metadata service endpoint.Valid values are `IPv4` and `IPv6`. Can also be configured using the
     * `AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE` environment variable.
     * 
     */
    @Import(name="ec2MetadataServiceEndpointMode")
    private @Nullable Output<String> ec2MetadataServiceEndpointMode;

    /**
     * @return Protocol to use with EC2 metadata service endpoint.Valid values are `IPv4` and `IPv6`. Can also be configured using the
     * `AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE` environment variable.
     * 
     */
    public Optional<Output<String>> ec2MetadataServiceEndpointMode() {
        return Optional.ofNullable(this.ec2MetadataServiceEndpointMode);
    }

    @Import(name="endpoints", json=true)
    private @Nullable Output<List<ProviderEndpointArgs>> endpoints;

    public Optional<Output<List<ProviderEndpointArgs>>> endpoints() {
        return Optional.ofNullable(this.endpoints);
    }

    @Import(name="forbiddenAccountIds", json=true)
    private @Nullable Output<List<String>> forbiddenAccountIds;

    public Optional<Output<List<String>>> forbiddenAccountIds() {
        return Optional.ofNullable(this.forbiddenAccountIds);
    }

    /**
     * The address of an HTTP proxy to use when accessing the AWS API. Can also be configured using the `HTTP_PROXY` or
     * `HTTPS_PROXY` environment variables.
     * 
     */
    @Import(name="httpProxy")
    private @Nullable Output<String> httpProxy;

    /**
     * @return The address of an HTTP proxy to use when accessing the AWS API. Can also be configured using the `HTTP_PROXY` or
     * `HTTPS_PROXY` environment variables.
     * 
     */
    public Optional<Output<String>> httpProxy() {
        return Optional.ofNullable(this.httpProxy);
    }

    /**
     * Configuration block with settings to ignore resource tags across all resources.
     * 
     */
    @Import(name="ignoreTags", json=true)
    private @Nullable Output<ProviderIgnoreTagsArgs> ignoreTags;

    /**
     * @return Configuration block with settings to ignore resource tags across all resources.
     * 
     */
    public Optional<Output<ProviderIgnoreTagsArgs>> ignoreTags() {
        return Optional.ofNullable(this.ignoreTags);
    }

    /**
     * Explicitly allow the provider to perform &#34;insecure&#34; SSL requests. If omitted, default value is `false`
     * 
     */
    @Import(name="insecure", json=true)
    private @Nullable Output<Boolean> insecure;

    /**
     * @return Explicitly allow the provider to perform &#34;insecure&#34; SSL requests. If omitted, default value is `false`
     * 
     */
    public Optional<Output<Boolean>> insecure() {
        return Optional.ofNullable(this.insecure);
    }

    /**
     * The maximum number of times an AWS API request is being executed. If the API request still fails, an error is thrown.
     * 
     */
    @Import(name="maxRetries", json=true)
    private @Nullable Output<Integer> maxRetries;

    /**
     * @return The maximum number of times an AWS API request is being executed. If the API request still fails, an error is thrown.
     * 
     */
    public Optional<Output<Integer>> maxRetries() {
        return Optional.ofNullable(this.maxRetries);
    }

    /**
     * The profile for API operations. If not set, the default profile created with `aws configure` will be used.
     * 
     */
    @Import(name="profile")
    private @Nullable Output<String> profile;

    /**
     * @return The profile for API operations. If not set, the default profile created with `aws configure` will be used.
     * 
     */
    public Optional<Output<String>> profile() {
        return Optional.ofNullable(this.profile);
    }

    /**
     * The region where AWS operations will take place. Examples are us-east-1, us-west-2, etc.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region where AWS operations will take place. Examples are us-east-1, us-west-2, etc.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * Specifies how retries are attempted. Valid values are `standard` and `adaptive`. Can also be configured using the
     * `AWS_RETRY_MODE` environment variable.
     * 
     */
    @Import(name="retryMode")
    private @Nullable Output<String> retryMode;

    /**
     * @return Specifies how retries are attempted. Valid values are `standard` and `adaptive`. Can also be configured using the
     * `AWS_RETRY_MODE` environment variable.
     * 
     */
    public Optional<Output<String>> retryMode() {
        return Optional.ofNullable(this.retryMode);
    }

    /**
     * Specifies whether S3 API calls in the `us-east-1` region use the legacy global endpoint or a regional endpoint. Valid
     * values are `legacy` or `regional`. Can also be configured using the `AWS_S3_US_EAST_1_REGIONAL_ENDPOINT` environment
     * variable or the `s3_us_east_1_regional_endpoint` shared config file parameter
     * 
     */
    @Import(name="s3UsEast1RegionalEndpoint")
    private @Nullable Output<String> s3UsEast1RegionalEndpoint;

    /**
     * @return Specifies whether S3 API calls in the `us-east-1` region use the legacy global endpoint or a regional endpoint. Valid
     * values are `legacy` or `regional`. Can also be configured using the `AWS_S3_US_EAST_1_REGIONAL_ENDPOINT` environment
     * variable or the `s3_us_east_1_regional_endpoint` shared config file parameter
     * 
     */
    public Optional<Output<String>> s3UsEast1RegionalEndpoint() {
        return Optional.ofNullable(this.s3UsEast1RegionalEndpoint);
    }

    /**
     * Set this to true to enable the request to use path-style addressing, i.e., https://s3.amazonaws.com/BUCKET/KEY. By
     * default, the S3 client will use virtual hosted bucket addressing when possible (https://BUCKET.s3.amazonaws.com/KEY).
     * Specific to the Amazon S3 service.
     * 
     */
    @Import(name="s3UsePathStyle", json=true)
    private @Nullable Output<Boolean> s3UsePathStyle;

    /**
     * @return Set this to true to enable the request to use path-style addressing, i.e., https://s3.amazonaws.com/BUCKET/KEY. By
     * default, the S3 client will use virtual hosted bucket addressing when possible (https://BUCKET.s3.amazonaws.com/KEY).
     * Specific to the Amazon S3 service.
     * 
     */
    public Optional<Output<Boolean>> s3UsePathStyle() {
        return Optional.ofNullable(this.s3UsePathStyle);
    }

    /**
     * The secret key for API operations. You can retrieve this from the &#39;Security &amp; Credentials&#39; section of the AWS console.
     * 
     */
    @Import(name="secretKey")
    private @Nullable Output<String> secretKey;

    /**
     * @return The secret key for API operations. You can retrieve this from the &#39;Security &amp; Credentials&#39; section of the AWS console.
     * 
     */
    public Optional<Output<String>> secretKey() {
        return Optional.ofNullable(this.secretKey);
    }

    /**
     * List of paths to shared config files. If not set, defaults to [~/.aws/config].
     * 
     */
    @Import(name="sharedConfigFiles", json=true)
    private @Nullable Output<List<String>> sharedConfigFiles;

    /**
     * @return List of paths to shared config files. If not set, defaults to [~/.aws/config].
     * 
     */
    public Optional<Output<List<String>>> sharedConfigFiles() {
        return Optional.ofNullable(this.sharedConfigFiles);
    }

    /**
     * List of paths to shared credentials files. If not set, defaults to [~/.aws/credentials].
     * 
     */
    @Import(name="sharedCredentialsFiles", json=true)
    private @Nullable Output<List<String>> sharedCredentialsFiles;

    /**
     * @return List of paths to shared credentials files. If not set, defaults to [~/.aws/credentials].
     * 
     */
    public Optional<Output<List<String>>> sharedCredentialsFiles() {
        return Optional.ofNullable(this.sharedCredentialsFiles);
    }

    /**
     * Skip the credentials validation via STS API. Used for AWS API implementations that do not have STS
     * available/implemented.
     * 
     */
    @Import(name="skipCredentialsValidation", json=true)
    private @Nullable Output<Boolean> skipCredentialsValidation;

    /**
     * @return Skip the credentials validation via STS API. Used for AWS API implementations that do not have STS
     * available/implemented.
     * 
     */
    public Optional<Output<Boolean>> skipCredentialsValidation() {
        return Optional.ofNullable(this.skipCredentialsValidation);
    }

    /**
     * Skip the AWS Metadata API check. Used for AWS API implementations that do not have a metadata api endpoint.
     * 
     */
    @Import(name="skipMetadataApiCheck", json=true)
    private @Nullable Output<Boolean> skipMetadataApiCheck;

    /**
     * @return Skip the AWS Metadata API check. Used for AWS API implementations that do not have a metadata api endpoint.
     * 
     */
    public Optional<Output<Boolean>> skipMetadataApiCheck() {
        return Optional.ofNullable(this.skipMetadataApiCheck);
    }

    /**
     * Skip static validation of region name. Used by users of alternative AWS-like APIs or users w/ access to regions that are
     * not public (yet).
     * 
     */
    @Import(name="skipRegionValidation", json=true)
    private @Nullable Output<Boolean> skipRegionValidation;

    /**
     * @return Skip static validation of region name. Used by users of alternative AWS-like APIs or users w/ access to regions that are
     * not public (yet).
     * 
     */
    public Optional<Output<Boolean>> skipRegionValidation() {
        return Optional.ofNullable(this.skipRegionValidation);
    }

    /**
     * Skip requesting the account ID. Used for AWS API implementations that do not have IAM/STS API and/or metadata API.
     * 
     */
    @Import(name="skipRequestingAccountId", json=true)
    private @Nullable Output<Boolean> skipRequestingAccountId;

    /**
     * @return Skip requesting the account ID. Used for AWS API implementations that do not have IAM/STS API and/or metadata API.
     * 
     */
    public Optional<Output<Boolean>> skipRequestingAccountId() {
        return Optional.ofNullable(this.skipRequestingAccountId);
    }

    /**
     * The region where AWS STS operations will take place. Examples are us-east-1 and us-west-2.
     * 
     */
    @Import(name="stsRegion")
    private @Nullable Output<String> stsRegion;

    /**
     * @return The region where AWS STS operations will take place. Examples are us-east-1 and us-west-2.
     * 
     */
    public Optional<Output<String>> stsRegion() {
        return Optional.ofNullable(this.stsRegion);
    }

    /**
     * session token. A session token is only required if you are using temporary security credentials.
     * 
     */
    @Import(name="token")
    private @Nullable Output<String> token;

    /**
     * @return session token. A session token is only required if you are using temporary security credentials.
     * 
     */
    public Optional<Output<String>> token() {
        return Optional.ofNullable(this.token);
    }

    /**
     * Resolve an endpoint with DualStack capability
     * 
     */
    @Import(name="useDualstackEndpoint", json=true)
    private @Nullable Output<Boolean> useDualstackEndpoint;

    /**
     * @return Resolve an endpoint with DualStack capability
     * 
     */
    public Optional<Output<Boolean>> useDualstackEndpoint() {
        return Optional.ofNullable(this.useDualstackEndpoint);
    }

    /**
     * Resolve an endpoint with FIPS capability
     * 
     */
    @Import(name="useFipsEndpoint", json=true)
    private @Nullable Output<Boolean> useFipsEndpoint;

    /**
     * @return Resolve an endpoint with FIPS capability
     * 
     */
    public Optional<Output<Boolean>> useFipsEndpoint() {
        return Optional.ofNullable(this.useFipsEndpoint);
    }

    private ProviderArgs() {}

    private ProviderArgs(ProviderArgs $) {
        this.accessKey = $.accessKey;
        this.allowedAccountIds = $.allowedAccountIds;
        this.assumeRole = $.assumeRole;
        this.assumeRoleWithWebIdentity = $.assumeRoleWithWebIdentity;
        this.customCaBundle = $.customCaBundle;
        this.defaultTags = $.defaultTags;
        this.ec2MetadataServiceEndpoint = $.ec2MetadataServiceEndpoint;
        this.ec2MetadataServiceEndpointMode = $.ec2MetadataServiceEndpointMode;
        this.endpoints = $.endpoints;
        this.forbiddenAccountIds = $.forbiddenAccountIds;
        this.httpProxy = $.httpProxy;
        this.ignoreTags = $.ignoreTags;
        this.insecure = $.insecure;
        this.maxRetries = $.maxRetries;
        this.profile = $.profile;
        this.region = $.region;
        this.retryMode = $.retryMode;
        this.s3UsEast1RegionalEndpoint = $.s3UsEast1RegionalEndpoint;
        this.s3UsePathStyle = $.s3UsePathStyle;
        this.secretKey = $.secretKey;
        this.sharedConfigFiles = $.sharedConfigFiles;
        this.sharedCredentialsFiles = $.sharedCredentialsFiles;
        this.skipCredentialsValidation = $.skipCredentialsValidation;
        this.skipMetadataApiCheck = $.skipMetadataApiCheck;
        this.skipRegionValidation = $.skipRegionValidation;
        this.skipRequestingAccountId = $.skipRequestingAccountId;
        this.stsRegion = $.stsRegion;
        this.token = $.token;
        this.useDualstackEndpoint = $.useDualstackEndpoint;
        this.useFipsEndpoint = $.useFipsEndpoint;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ProviderArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ProviderArgs $;

        public Builder() {
            $ = new ProviderArgs();
        }

        public Builder(ProviderArgs defaults) {
            $ = new ProviderArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessKey The access key for API operations. You can retrieve this from the &#39;Security &amp; Credentials&#39; section of the AWS console.
         * 
         * @return builder
         * 
         */
        public Builder accessKey(@Nullable Output<String> accessKey) {
            $.accessKey = accessKey;
            return this;
        }

        /**
         * @param accessKey The access key for API operations. You can retrieve this from the &#39;Security &amp; Credentials&#39; section of the AWS console.
         * 
         * @return builder
         * 
         */
        public Builder accessKey(String accessKey) {
            return accessKey(Output.of(accessKey));
        }

        public Builder allowedAccountIds(@Nullable Output<List<String>> allowedAccountIds) {
            $.allowedAccountIds = allowedAccountIds;
            return this;
        }

        public Builder allowedAccountIds(List<String> allowedAccountIds) {
            return allowedAccountIds(Output.of(allowedAccountIds));
        }

        public Builder allowedAccountIds(String... allowedAccountIds) {
            return allowedAccountIds(List.of(allowedAccountIds));
        }

        public Builder assumeRole(@Nullable Output<ProviderAssumeRoleArgs> assumeRole) {
            $.assumeRole = assumeRole;
            return this;
        }

        public Builder assumeRole(ProviderAssumeRoleArgs assumeRole) {
            return assumeRole(Output.of(assumeRole));
        }

        public Builder assumeRoleWithWebIdentity(@Nullable Output<ProviderAssumeRoleWithWebIdentityArgs> assumeRoleWithWebIdentity) {
            $.assumeRoleWithWebIdentity = assumeRoleWithWebIdentity;
            return this;
        }

        public Builder assumeRoleWithWebIdentity(ProviderAssumeRoleWithWebIdentityArgs assumeRoleWithWebIdentity) {
            return assumeRoleWithWebIdentity(Output.of(assumeRoleWithWebIdentity));
        }

        /**
         * @param customCaBundle File containing custom root and intermediate certificates. Can also be configured using the `AWS_CA_BUNDLE` environment
         * variable. (Setting `ca_bundle` in the shared config file is not supported.)
         * 
         * @return builder
         * 
         */
        public Builder customCaBundle(@Nullable Output<String> customCaBundle) {
            $.customCaBundle = customCaBundle;
            return this;
        }

        /**
         * @param customCaBundle File containing custom root and intermediate certificates. Can also be configured using the `AWS_CA_BUNDLE` environment
         * variable. (Setting `ca_bundle` in the shared config file is not supported.)
         * 
         * @return builder
         * 
         */
        public Builder customCaBundle(String customCaBundle) {
            return customCaBundle(Output.of(customCaBundle));
        }

        /**
         * @param defaultTags Configuration block with settings to default resource tags across all resources.
         * 
         * @return builder
         * 
         */
        public Builder defaultTags(@Nullable Output<ProviderDefaultTagsArgs> defaultTags) {
            $.defaultTags = defaultTags;
            return this;
        }

        /**
         * @param defaultTags Configuration block with settings to default resource tags across all resources.
         * 
         * @return builder
         * 
         */
        public Builder defaultTags(ProviderDefaultTagsArgs defaultTags) {
            return defaultTags(Output.of(defaultTags));
        }

        /**
         * @param ec2MetadataServiceEndpoint Address of the EC2 metadata service endpoint to use. Can also be configured using the
         * `AWS_EC2_METADATA_SERVICE_ENDPOINT` environment variable.
         * 
         * @return builder
         * 
         */
        public Builder ec2MetadataServiceEndpoint(@Nullable Output<String> ec2MetadataServiceEndpoint) {
            $.ec2MetadataServiceEndpoint = ec2MetadataServiceEndpoint;
            return this;
        }

        /**
         * @param ec2MetadataServiceEndpoint Address of the EC2 metadata service endpoint to use. Can also be configured using the
         * `AWS_EC2_METADATA_SERVICE_ENDPOINT` environment variable.
         * 
         * @return builder
         * 
         */
        public Builder ec2MetadataServiceEndpoint(String ec2MetadataServiceEndpoint) {
            return ec2MetadataServiceEndpoint(Output.of(ec2MetadataServiceEndpoint));
        }

        /**
         * @param ec2MetadataServiceEndpointMode Protocol to use with EC2 metadata service endpoint.Valid values are `IPv4` and `IPv6`. Can also be configured using the
         * `AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE` environment variable.
         * 
         * @return builder
         * 
         */
        public Builder ec2MetadataServiceEndpointMode(@Nullable Output<String> ec2MetadataServiceEndpointMode) {
            $.ec2MetadataServiceEndpointMode = ec2MetadataServiceEndpointMode;
            return this;
        }

        /**
         * @param ec2MetadataServiceEndpointMode Protocol to use with EC2 metadata service endpoint.Valid values are `IPv4` and `IPv6`. Can also be configured using the
         * `AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE` environment variable.
         * 
         * @return builder
         * 
         */
        public Builder ec2MetadataServiceEndpointMode(String ec2MetadataServiceEndpointMode) {
            return ec2MetadataServiceEndpointMode(Output.of(ec2MetadataServiceEndpointMode));
        }

        public Builder endpoints(@Nullable Output<List<ProviderEndpointArgs>> endpoints) {
            $.endpoints = endpoints;
            return this;
        }

        public Builder endpoints(List<ProviderEndpointArgs> endpoints) {
            return endpoints(Output.of(endpoints));
        }

        public Builder endpoints(ProviderEndpointArgs... endpoints) {
            return endpoints(List.of(endpoints));
        }

        public Builder forbiddenAccountIds(@Nullable Output<List<String>> forbiddenAccountIds) {
            $.forbiddenAccountIds = forbiddenAccountIds;
            return this;
        }

        public Builder forbiddenAccountIds(List<String> forbiddenAccountIds) {
            return forbiddenAccountIds(Output.of(forbiddenAccountIds));
        }

        public Builder forbiddenAccountIds(String... forbiddenAccountIds) {
            return forbiddenAccountIds(List.of(forbiddenAccountIds));
        }

        /**
         * @param httpProxy The address of an HTTP proxy to use when accessing the AWS API. Can also be configured using the `HTTP_PROXY` or
         * `HTTPS_PROXY` environment variables.
         * 
         * @return builder
         * 
         */
        public Builder httpProxy(@Nullable Output<String> httpProxy) {
            $.httpProxy = httpProxy;
            return this;
        }

        /**
         * @param httpProxy The address of an HTTP proxy to use when accessing the AWS API. Can also be configured using the `HTTP_PROXY` or
         * `HTTPS_PROXY` environment variables.
         * 
         * @return builder
         * 
         */
        public Builder httpProxy(String httpProxy) {
            return httpProxy(Output.of(httpProxy));
        }

        /**
         * @param ignoreTags Configuration block with settings to ignore resource tags across all resources.
         * 
         * @return builder
         * 
         */
        public Builder ignoreTags(@Nullable Output<ProviderIgnoreTagsArgs> ignoreTags) {
            $.ignoreTags = ignoreTags;
            return this;
        }

        /**
         * @param ignoreTags Configuration block with settings to ignore resource tags across all resources.
         * 
         * @return builder
         * 
         */
        public Builder ignoreTags(ProviderIgnoreTagsArgs ignoreTags) {
            return ignoreTags(Output.of(ignoreTags));
        }

        /**
         * @param insecure Explicitly allow the provider to perform &#34;insecure&#34; SSL requests. If omitted, default value is `false`
         * 
         * @return builder
         * 
         */
        public Builder insecure(@Nullable Output<Boolean> insecure) {
            $.insecure = insecure;
            return this;
        }

        /**
         * @param insecure Explicitly allow the provider to perform &#34;insecure&#34; SSL requests. If omitted, default value is `false`
         * 
         * @return builder
         * 
         */
        public Builder insecure(Boolean insecure) {
            return insecure(Output.of(insecure));
        }

        /**
         * @param maxRetries The maximum number of times an AWS API request is being executed. If the API request still fails, an error is thrown.
         * 
         * @return builder
         * 
         */
        public Builder maxRetries(@Nullable Output<Integer> maxRetries) {
            $.maxRetries = maxRetries;
            return this;
        }

        /**
         * @param maxRetries The maximum number of times an AWS API request is being executed. If the API request still fails, an error is thrown.
         * 
         * @return builder
         * 
         */
        public Builder maxRetries(Integer maxRetries) {
            return maxRetries(Output.of(maxRetries));
        }

        /**
         * @param profile The profile for API operations. If not set, the default profile created with `aws configure` will be used.
         * 
         * @return builder
         * 
         */
        public Builder profile(@Nullable Output<String> profile) {
            $.profile = profile;
            return this;
        }

        /**
         * @param profile The profile for API operations. If not set, the default profile created with `aws configure` will be used.
         * 
         * @return builder
         * 
         */
        public Builder profile(String profile) {
            return profile(Output.of(profile));
        }

        /**
         * @param region The region where AWS operations will take place. Examples are us-east-1, us-west-2, etc.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region where AWS operations will take place. Examples are us-east-1, us-west-2, etc.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param retryMode Specifies how retries are attempted. Valid values are `standard` and `adaptive`. Can also be configured using the
         * `AWS_RETRY_MODE` environment variable.
         * 
         * @return builder
         * 
         */
        public Builder retryMode(@Nullable Output<String> retryMode) {
            $.retryMode = retryMode;
            return this;
        }

        /**
         * @param retryMode Specifies how retries are attempted. Valid values are `standard` and `adaptive`. Can also be configured using the
         * `AWS_RETRY_MODE` environment variable.
         * 
         * @return builder
         * 
         */
        public Builder retryMode(String retryMode) {
            return retryMode(Output.of(retryMode));
        }

        /**
         * @param s3UsEast1RegionalEndpoint Specifies whether S3 API calls in the `us-east-1` region use the legacy global endpoint or a regional endpoint. Valid
         * values are `legacy` or `regional`. Can also be configured using the `AWS_S3_US_EAST_1_REGIONAL_ENDPOINT` environment
         * variable or the `s3_us_east_1_regional_endpoint` shared config file parameter
         * 
         * @return builder
         * 
         */
        public Builder s3UsEast1RegionalEndpoint(@Nullable Output<String> s3UsEast1RegionalEndpoint) {
            $.s3UsEast1RegionalEndpoint = s3UsEast1RegionalEndpoint;
            return this;
        }

        /**
         * @param s3UsEast1RegionalEndpoint Specifies whether S3 API calls in the `us-east-1` region use the legacy global endpoint or a regional endpoint. Valid
         * values are `legacy` or `regional`. Can also be configured using the `AWS_S3_US_EAST_1_REGIONAL_ENDPOINT` environment
         * variable or the `s3_us_east_1_regional_endpoint` shared config file parameter
         * 
         * @return builder
         * 
         */
        public Builder s3UsEast1RegionalEndpoint(String s3UsEast1RegionalEndpoint) {
            return s3UsEast1RegionalEndpoint(Output.of(s3UsEast1RegionalEndpoint));
        }

        /**
         * @param s3UsePathStyle Set this to true to enable the request to use path-style addressing, i.e., https://s3.amazonaws.com/BUCKET/KEY. By
         * default, the S3 client will use virtual hosted bucket addressing when possible (https://BUCKET.s3.amazonaws.com/KEY).
         * Specific to the Amazon S3 service.
         * 
         * @return builder
         * 
         */
        public Builder s3UsePathStyle(@Nullable Output<Boolean> s3UsePathStyle) {
            $.s3UsePathStyle = s3UsePathStyle;
            return this;
        }

        /**
         * @param s3UsePathStyle Set this to true to enable the request to use path-style addressing, i.e., https://s3.amazonaws.com/BUCKET/KEY. By
         * default, the S3 client will use virtual hosted bucket addressing when possible (https://BUCKET.s3.amazonaws.com/KEY).
         * Specific to the Amazon S3 service.
         * 
         * @return builder
         * 
         */
        public Builder s3UsePathStyle(Boolean s3UsePathStyle) {
            return s3UsePathStyle(Output.of(s3UsePathStyle));
        }

        /**
         * @param secretKey The secret key for API operations. You can retrieve this from the &#39;Security &amp; Credentials&#39; section of the AWS console.
         * 
         * @return builder
         * 
         */
        public Builder secretKey(@Nullable Output<String> secretKey) {
            $.secretKey = secretKey;
            return this;
        }

        /**
         * @param secretKey The secret key for API operations. You can retrieve this from the &#39;Security &amp; Credentials&#39; section of the AWS console.
         * 
         * @return builder
         * 
         */
        public Builder secretKey(String secretKey) {
            return secretKey(Output.of(secretKey));
        }

        /**
         * @param sharedConfigFiles List of paths to shared config files. If not set, defaults to [~/.aws/config].
         * 
         * @return builder
         * 
         */
        public Builder sharedConfigFiles(@Nullable Output<List<String>> sharedConfigFiles) {
            $.sharedConfigFiles = sharedConfigFiles;
            return this;
        }

        /**
         * @param sharedConfigFiles List of paths to shared config files. If not set, defaults to [~/.aws/config].
         * 
         * @return builder
         * 
         */
        public Builder sharedConfigFiles(List<String> sharedConfigFiles) {
            return sharedConfigFiles(Output.of(sharedConfigFiles));
        }

        /**
         * @param sharedConfigFiles List of paths to shared config files. If not set, defaults to [~/.aws/config].
         * 
         * @return builder
         * 
         */
        public Builder sharedConfigFiles(String... sharedConfigFiles) {
            return sharedConfigFiles(List.of(sharedConfigFiles));
        }

        /**
         * @param sharedCredentialsFiles List of paths to shared credentials files. If not set, defaults to [~/.aws/credentials].
         * 
         * @return builder
         * 
         */
        public Builder sharedCredentialsFiles(@Nullable Output<List<String>> sharedCredentialsFiles) {
            $.sharedCredentialsFiles = sharedCredentialsFiles;
            return this;
        }

        /**
         * @param sharedCredentialsFiles List of paths to shared credentials files. If not set, defaults to [~/.aws/credentials].
         * 
         * @return builder
         * 
         */
        public Builder sharedCredentialsFiles(List<String> sharedCredentialsFiles) {
            return sharedCredentialsFiles(Output.of(sharedCredentialsFiles));
        }

        /**
         * @param sharedCredentialsFiles List of paths to shared credentials files. If not set, defaults to [~/.aws/credentials].
         * 
         * @return builder
         * 
         */
        public Builder sharedCredentialsFiles(String... sharedCredentialsFiles) {
            return sharedCredentialsFiles(List.of(sharedCredentialsFiles));
        }

        /**
         * @param skipCredentialsValidation Skip the credentials validation via STS API. Used for AWS API implementations that do not have STS
         * available/implemented.
         * 
         * @return builder
         * 
         */
        public Builder skipCredentialsValidation(@Nullable Output<Boolean> skipCredentialsValidation) {
            $.skipCredentialsValidation = skipCredentialsValidation;
            return this;
        }

        /**
         * @param skipCredentialsValidation Skip the credentials validation via STS API. Used for AWS API implementations that do not have STS
         * available/implemented.
         * 
         * @return builder
         * 
         */
        public Builder skipCredentialsValidation(Boolean skipCredentialsValidation) {
            return skipCredentialsValidation(Output.of(skipCredentialsValidation));
        }

        /**
         * @param skipMetadataApiCheck Skip the AWS Metadata API check. Used for AWS API implementations that do not have a metadata api endpoint.
         * 
         * @return builder
         * 
         */
        public Builder skipMetadataApiCheck(@Nullable Output<Boolean> skipMetadataApiCheck) {
            $.skipMetadataApiCheck = skipMetadataApiCheck;
            return this;
        }

        /**
         * @param skipMetadataApiCheck Skip the AWS Metadata API check. Used for AWS API implementations that do not have a metadata api endpoint.
         * 
         * @return builder
         * 
         */
        public Builder skipMetadataApiCheck(Boolean skipMetadataApiCheck) {
            return skipMetadataApiCheck(Output.of(skipMetadataApiCheck));
        }

        /**
         * @param skipRegionValidation Skip static validation of region name. Used by users of alternative AWS-like APIs or users w/ access to regions that are
         * not public (yet).
         * 
         * @return builder
         * 
         */
        public Builder skipRegionValidation(@Nullable Output<Boolean> skipRegionValidation) {
            $.skipRegionValidation = skipRegionValidation;
            return this;
        }

        /**
         * @param skipRegionValidation Skip static validation of region name. Used by users of alternative AWS-like APIs or users w/ access to regions that are
         * not public (yet).
         * 
         * @return builder
         * 
         */
        public Builder skipRegionValidation(Boolean skipRegionValidation) {
            return skipRegionValidation(Output.of(skipRegionValidation));
        }

        /**
         * @param skipRequestingAccountId Skip requesting the account ID. Used for AWS API implementations that do not have IAM/STS API and/or metadata API.
         * 
         * @return builder
         * 
         */
        public Builder skipRequestingAccountId(@Nullable Output<Boolean> skipRequestingAccountId) {
            $.skipRequestingAccountId = skipRequestingAccountId;
            return this;
        }

        /**
         * @param skipRequestingAccountId Skip requesting the account ID. Used for AWS API implementations that do not have IAM/STS API and/or metadata API.
         * 
         * @return builder
         * 
         */
        public Builder skipRequestingAccountId(Boolean skipRequestingAccountId) {
            return skipRequestingAccountId(Output.of(skipRequestingAccountId));
        }

        /**
         * @param stsRegion The region where AWS STS operations will take place. Examples are us-east-1 and us-west-2.
         * 
         * @return builder
         * 
         */
        public Builder stsRegion(@Nullable Output<String> stsRegion) {
            $.stsRegion = stsRegion;
            return this;
        }

        /**
         * @param stsRegion The region where AWS STS operations will take place. Examples are us-east-1 and us-west-2.
         * 
         * @return builder
         * 
         */
        public Builder stsRegion(String stsRegion) {
            return stsRegion(Output.of(stsRegion));
        }

        /**
         * @param token session token. A session token is only required if you are using temporary security credentials.
         * 
         * @return builder
         * 
         */
        public Builder token(@Nullable Output<String> token) {
            $.token = token;
            return this;
        }

        /**
         * @param token session token. A session token is only required if you are using temporary security credentials.
         * 
         * @return builder
         * 
         */
        public Builder token(String token) {
            return token(Output.of(token));
        }

        /**
         * @param useDualstackEndpoint Resolve an endpoint with DualStack capability
         * 
         * @return builder
         * 
         */
        public Builder useDualstackEndpoint(@Nullable Output<Boolean> useDualstackEndpoint) {
            $.useDualstackEndpoint = useDualstackEndpoint;
            return this;
        }

        /**
         * @param useDualstackEndpoint Resolve an endpoint with DualStack capability
         * 
         * @return builder
         * 
         */
        public Builder useDualstackEndpoint(Boolean useDualstackEndpoint) {
            return useDualstackEndpoint(Output.of(useDualstackEndpoint));
        }

        /**
         * @param useFipsEndpoint Resolve an endpoint with FIPS capability
         * 
         * @return builder
         * 
         */
        public Builder useFipsEndpoint(@Nullable Output<Boolean> useFipsEndpoint) {
            $.useFipsEndpoint = useFipsEndpoint;
            return this;
        }

        /**
         * @param useFipsEndpoint Resolve an endpoint with FIPS capability
         * 
         * @return builder
         * 
         */
        public Builder useFipsEndpoint(Boolean useFipsEndpoint) {
            return useFipsEndpoint(Output.of(useFipsEndpoint));
        }

        public ProviderArgs build() {
            $.region = Codegen.stringProp("region").output().arg($.region).env("AWS_REGION", "AWS_DEFAULT_REGION").getNullable();
            $.skipCredentialsValidation = Codegen.booleanProp("skipCredentialsValidation").output().arg($.skipCredentialsValidation).def(false).getNullable();
            $.skipMetadataApiCheck = Codegen.booleanProp("skipMetadataApiCheck").output().arg($.skipMetadataApiCheck).def(true).getNullable();
            $.skipRegionValidation = Codegen.booleanProp("skipRegionValidation").output().arg($.skipRegionValidation).def(true).getNullable();
            return $;
        }
    }

}
