// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.inputs.GetArnArgs;
import com.pulumi.aws.inputs.GetArnPlainArgs;
import com.pulumi.aws.inputs.GetAvailabilityZoneArgs;
import com.pulumi.aws.inputs.GetAvailabilityZonePlainArgs;
import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
import com.pulumi.aws.inputs.GetAvailabilityZonesPlainArgs;
import com.pulumi.aws.inputs.GetBillingServiceAccountArgs;
import com.pulumi.aws.inputs.GetBillingServiceAccountPlainArgs;
import com.pulumi.aws.inputs.GetCallerIdentityArgs;
import com.pulumi.aws.inputs.GetCallerIdentityPlainArgs;
import com.pulumi.aws.inputs.GetDefaultTagsArgs;
import com.pulumi.aws.inputs.GetDefaultTagsPlainArgs;
import com.pulumi.aws.inputs.GetIpRangesArgs;
import com.pulumi.aws.inputs.GetIpRangesPlainArgs;
import com.pulumi.aws.inputs.GetPartitionArgs;
import com.pulumi.aws.inputs.GetPartitionPlainArgs;
import com.pulumi.aws.inputs.GetRegionArgs;
import com.pulumi.aws.inputs.GetRegionPlainArgs;
import com.pulumi.aws.inputs.GetRegionsArgs;
import com.pulumi.aws.inputs.GetRegionsPlainArgs;
import com.pulumi.aws.inputs.GetServiceArgs;
import com.pulumi.aws.inputs.GetServicePlainArgs;
import com.pulumi.aws.outputs.GetArnResult;
import com.pulumi.aws.outputs.GetAvailabilityZoneResult;
import com.pulumi.aws.outputs.GetAvailabilityZonesResult;
import com.pulumi.aws.outputs.GetBillingServiceAccountResult;
import com.pulumi.aws.outputs.GetCallerIdentityResult;
import com.pulumi.aws.outputs.GetDefaultTagsResult;
import com.pulumi.aws.outputs.GetIpRangesResult;
import com.pulumi.aws.outputs.GetPartitionResult;
import com.pulumi.aws.outputs.GetRegionResult;
import com.pulumi.aws.outputs.GetRegionsResult;
import com.pulumi.aws.outputs.GetServiceResult;
import com.pulumi.core.Output;
import com.pulumi.core.TypeShape;
import com.pulumi.deployment.Deployment;
import com.pulumi.deployment.InvokeOptions;
import java.util.concurrent.CompletableFuture;

public final class AwsFunctions {
    /**
     * Parses an ARN into its constituent parts.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetArnArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var dbInstance = AwsFunctions.getArn(GetArnArgs.builder()
     *             .arn(&#34;arn:aws:rds:eu-west-1:123456789012:db:mysql-db&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetArnResult> getArn(GetArnArgs args) {
        return getArn(args, InvokeOptions.Empty);
    }
    /**
     * Parses an ARN into its constituent parts.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetArnArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var dbInstance = AwsFunctions.getArn(GetArnArgs.builder()
     *             .arn(&#34;arn:aws:rds:eu-west-1:123456789012:db:mysql-db&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetArnResult> getArnPlain(GetArnPlainArgs args) {
        return getArnPlain(args, InvokeOptions.Empty);
    }
    /**
     * Parses an ARN into its constituent parts.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetArnArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var dbInstance = AwsFunctions.getArn(GetArnArgs.builder()
     *             .arn(&#34;arn:aws:rds:eu-west-1:123456789012:db:mysql-db&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetArnResult> getArn(GetArnArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:index/getArn:getArn", TypeShape.of(GetArnResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Parses an ARN into its constituent parts.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetArnArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var dbInstance = AwsFunctions.getArn(GetArnArgs.builder()
     *             .arn(&#34;arn:aws:rds:eu-west-1:123456789012:db:mysql-db&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetArnResult> getArnPlain(GetArnPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:index/getArn:getArn", TypeShape.of(GetArnResult.class), args, Utilities.withVersion(options));
    }
    /**
     * `aws.getAvailabilityZone` provides details about a specific availability zone (AZ)
     * in the current region.
     * 
     * This can be used both to validate an availability zone given in a variable
     * and to split the AZ name into its component parts of an AWS region and an
     * AZ identifier letter. The latter may be useful e.g., for implementing a
     * consistent subnet numbering scheme across several regions by mapping both
     * the region and the subnet letter to network numbers.
     * 
     * This is different from the `aws.getAvailabilityZones` (plural) data source,
     * which provides a list of the available zones.
     * 
     */
    public static Output<GetAvailabilityZoneResult> getAvailabilityZone() {
        return getAvailabilityZone(GetAvailabilityZoneArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * `aws.getAvailabilityZone` provides details about a specific availability zone (AZ)
     * in the current region.
     * 
     * This can be used both to validate an availability zone given in a variable
     * and to split the AZ name into its component parts of an AWS region and an
     * AZ identifier letter. The latter may be useful e.g., for implementing a
     * consistent subnet numbering scheme across several regions by mapping both
     * the region and the subnet letter to network numbers.
     * 
     * This is different from the `aws.getAvailabilityZones` (plural) data source,
     * which provides a list of the available zones.
     * 
     */
    public static CompletableFuture<GetAvailabilityZoneResult> getAvailabilityZonePlain() {
        return getAvailabilityZonePlain(GetAvailabilityZonePlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * `aws.getAvailabilityZone` provides details about a specific availability zone (AZ)
     * in the current region.
     * 
     * This can be used both to validate an availability zone given in a variable
     * and to split the AZ name into its component parts of an AWS region and an
     * AZ identifier letter. The latter may be useful e.g., for implementing a
     * consistent subnet numbering scheme across several regions by mapping both
     * the region and the subnet letter to network numbers.
     * 
     * This is different from the `aws.getAvailabilityZones` (plural) data source,
     * which provides a list of the available zones.
     * 
     */
    public static Output<GetAvailabilityZoneResult> getAvailabilityZone(GetAvailabilityZoneArgs args) {
        return getAvailabilityZone(args, InvokeOptions.Empty);
    }
    /**
     * `aws.getAvailabilityZone` provides details about a specific availability zone (AZ)
     * in the current region.
     * 
     * This can be used both to validate an availability zone given in a variable
     * and to split the AZ name into its component parts of an AWS region and an
     * AZ identifier letter. The latter may be useful e.g., for implementing a
     * consistent subnet numbering scheme across several regions by mapping both
     * the region and the subnet letter to network numbers.
     * 
     * This is different from the `aws.getAvailabilityZones` (plural) data source,
     * which provides a list of the available zones.
     * 
     */
    public static CompletableFuture<GetAvailabilityZoneResult> getAvailabilityZonePlain(GetAvailabilityZonePlainArgs args) {
        return getAvailabilityZonePlain(args, InvokeOptions.Empty);
    }
    /**
     * `aws.getAvailabilityZone` provides details about a specific availability zone (AZ)
     * in the current region.
     * 
     * This can be used both to validate an availability zone given in a variable
     * and to split the AZ name into its component parts of an AWS region and an
     * AZ identifier letter. The latter may be useful e.g., for implementing a
     * consistent subnet numbering scheme across several regions by mapping both
     * the region and the subnet letter to network numbers.
     * 
     * This is different from the `aws.getAvailabilityZones` (plural) data source,
     * which provides a list of the available zones.
     * 
     */
    public static Output<GetAvailabilityZoneResult> getAvailabilityZone(GetAvailabilityZoneArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:index/getAvailabilityZone:getAvailabilityZone", TypeShape.of(GetAvailabilityZoneResult.class), args, Utilities.withVersion(options));
    }
    /**
     * `aws.getAvailabilityZone` provides details about a specific availability zone (AZ)
     * in the current region.
     * 
     * This can be used both to validate an availability zone given in a variable
     * and to split the AZ name into its component parts of an AWS region and an
     * AZ identifier letter. The latter may be useful e.g., for implementing a
     * consistent subnet numbering scheme across several regions by mapping both
     * the region and the subnet letter to network numbers.
     * 
     * This is different from the `aws.getAvailabilityZones` (plural) data source,
     * which provides a list of the available zones.
     * 
     */
    public static CompletableFuture<GetAvailabilityZoneResult> getAvailabilityZonePlain(GetAvailabilityZonePlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:index/getAvailabilityZone:getAvailabilityZone", TypeShape.of(GetAvailabilityZoneResult.class), args, Utilities.withVersion(options));
    }
    /**
     * The Availability Zones data source allows access to the list of AWS
     * Availability Zones which can be accessed by an AWS account within the region
     * configured in the provider.
     * 
     * This is different from the `aws.getAvailabilityZone` (singular) data source,
     * which provides some details about a specific availability zone.
     * 
     * &gt; When [Local Zones](https://aws.amazon.com/about-aws/global-infrastructure/localzones/) are enabled in a region, by default the API and this data source include both Local Zones and Availability Zones. To return only Availability Zones, see the example section below.
     * 
     * ## Example Usage
     * ### By State
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import com.pulumi.aws.ec2.Subnet;
     * import com.pulumi.aws.ec2.SubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .state(&#34;available&#34;)
     *             .build());
     * 
     *         var primary = new Subnet(&#34;primary&#34;, SubnetArgs.builder()        
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[0]))
     *             .build());
     * 
     *         var secondary = new Subnet(&#34;secondary&#34;, SubnetArgs.builder()        
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[1]))
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### By Filter
     * 
     * All Local Zones (regardless of opt-in status):
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .allAvailabilityZones(true)
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(                
     *                     &#34;not-opted-in&#34;,
     *                     &#34;opted-in&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     * Only Availability Zones (no Local Zones):
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(&#34;opt-in-not-required&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetAvailabilityZonesResult> getAvailabilityZones() {
        return getAvailabilityZones(GetAvailabilityZonesArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * The Availability Zones data source allows access to the list of AWS
     * Availability Zones which can be accessed by an AWS account within the region
     * configured in the provider.
     * 
     * This is different from the `aws.getAvailabilityZone` (singular) data source,
     * which provides some details about a specific availability zone.
     * 
     * &gt; When [Local Zones](https://aws.amazon.com/about-aws/global-infrastructure/localzones/) are enabled in a region, by default the API and this data source include both Local Zones and Availability Zones. To return only Availability Zones, see the example section below.
     * 
     * ## Example Usage
     * ### By State
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import com.pulumi.aws.ec2.Subnet;
     * import com.pulumi.aws.ec2.SubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .state(&#34;available&#34;)
     *             .build());
     * 
     *         var primary = new Subnet(&#34;primary&#34;, SubnetArgs.builder()        
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[0]))
     *             .build());
     * 
     *         var secondary = new Subnet(&#34;secondary&#34;, SubnetArgs.builder()        
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[1]))
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### By Filter
     * 
     * All Local Zones (regardless of opt-in status):
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .allAvailabilityZones(true)
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(                
     *                     &#34;not-opted-in&#34;,
     *                     &#34;opted-in&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     * Only Availability Zones (no Local Zones):
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(&#34;opt-in-not-required&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetAvailabilityZonesResult> getAvailabilityZonesPlain() {
        return getAvailabilityZonesPlain(GetAvailabilityZonesPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * The Availability Zones data source allows access to the list of AWS
     * Availability Zones which can be accessed by an AWS account within the region
     * configured in the provider.
     * 
     * This is different from the `aws.getAvailabilityZone` (singular) data source,
     * which provides some details about a specific availability zone.
     * 
     * &gt; When [Local Zones](https://aws.amazon.com/about-aws/global-infrastructure/localzones/) are enabled in a region, by default the API and this data source include both Local Zones and Availability Zones. To return only Availability Zones, see the example section below.
     * 
     * ## Example Usage
     * ### By State
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import com.pulumi.aws.ec2.Subnet;
     * import com.pulumi.aws.ec2.SubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .state(&#34;available&#34;)
     *             .build());
     * 
     *         var primary = new Subnet(&#34;primary&#34;, SubnetArgs.builder()        
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[0]))
     *             .build());
     * 
     *         var secondary = new Subnet(&#34;secondary&#34;, SubnetArgs.builder()        
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[1]))
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### By Filter
     * 
     * All Local Zones (regardless of opt-in status):
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .allAvailabilityZones(true)
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(                
     *                     &#34;not-opted-in&#34;,
     *                     &#34;opted-in&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     * Only Availability Zones (no Local Zones):
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(&#34;opt-in-not-required&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetAvailabilityZonesResult> getAvailabilityZones(GetAvailabilityZonesArgs args) {
        return getAvailabilityZones(args, InvokeOptions.Empty);
    }
    /**
     * The Availability Zones data source allows access to the list of AWS
     * Availability Zones which can be accessed by an AWS account within the region
     * configured in the provider.
     * 
     * This is different from the `aws.getAvailabilityZone` (singular) data source,
     * which provides some details about a specific availability zone.
     * 
     * &gt; When [Local Zones](https://aws.amazon.com/about-aws/global-infrastructure/localzones/) are enabled in a region, by default the API and this data source include both Local Zones and Availability Zones. To return only Availability Zones, see the example section below.
     * 
     * ## Example Usage
     * ### By State
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import com.pulumi.aws.ec2.Subnet;
     * import com.pulumi.aws.ec2.SubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .state(&#34;available&#34;)
     *             .build());
     * 
     *         var primary = new Subnet(&#34;primary&#34;, SubnetArgs.builder()        
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[0]))
     *             .build());
     * 
     *         var secondary = new Subnet(&#34;secondary&#34;, SubnetArgs.builder()        
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[1]))
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### By Filter
     * 
     * All Local Zones (regardless of opt-in status):
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .allAvailabilityZones(true)
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(                
     *                     &#34;not-opted-in&#34;,
     *                     &#34;opted-in&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     * Only Availability Zones (no Local Zones):
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(&#34;opt-in-not-required&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetAvailabilityZonesResult> getAvailabilityZonesPlain(GetAvailabilityZonesPlainArgs args) {
        return getAvailabilityZonesPlain(args, InvokeOptions.Empty);
    }
    /**
     * The Availability Zones data source allows access to the list of AWS
     * Availability Zones which can be accessed by an AWS account within the region
     * configured in the provider.
     * 
     * This is different from the `aws.getAvailabilityZone` (singular) data source,
     * which provides some details about a specific availability zone.
     * 
     * &gt; When [Local Zones](https://aws.amazon.com/about-aws/global-infrastructure/localzones/) are enabled in a region, by default the API and this data source include both Local Zones and Availability Zones. To return only Availability Zones, see the example section below.
     * 
     * ## Example Usage
     * ### By State
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import com.pulumi.aws.ec2.Subnet;
     * import com.pulumi.aws.ec2.SubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .state(&#34;available&#34;)
     *             .build());
     * 
     *         var primary = new Subnet(&#34;primary&#34;, SubnetArgs.builder()        
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[0]))
     *             .build());
     * 
     *         var secondary = new Subnet(&#34;secondary&#34;, SubnetArgs.builder()        
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[1]))
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### By Filter
     * 
     * All Local Zones (regardless of opt-in status):
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .allAvailabilityZones(true)
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(                
     *                     &#34;not-opted-in&#34;,
     *                     &#34;opted-in&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     * Only Availability Zones (no Local Zones):
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(&#34;opt-in-not-required&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetAvailabilityZonesResult> getAvailabilityZones(GetAvailabilityZonesArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:index/getAvailabilityZones:getAvailabilityZones", TypeShape.of(GetAvailabilityZonesResult.class), args, Utilities.withVersion(options));
    }
    /**
     * The Availability Zones data source allows access to the list of AWS
     * Availability Zones which can be accessed by an AWS account within the region
     * configured in the provider.
     * 
     * This is different from the `aws.getAvailabilityZone` (singular) data source,
     * which provides some details about a specific availability zone.
     * 
     * &gt; When [Local Zones](https://aws.amazon.com/about-aws/global-infrastructure/localzones/) are enabled in a region, by default the API and this data source include both Local Zones and Availability Zones. To return only Availability Zones, see the example section below.
     * 
     * ## Example Usage
     * ### By State
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import com.pulumi.aws.ec2.Subnet;
     * import com.pulumi.aws.ec2.SubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .state(&#34;available&#34;)
     *             .build());
     * 
     *         var primary = new Subnet(&#34;primary&#34;, SubnetArgs.builder()        
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[0]))
     *             .build());
     * 
     *         var secondary = new Subnet(&#34;secondary&#34;, SubnetArgs.builder()        
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[1]))
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### By Filter
     * 
     * All Local Zones (regardless of opt-in status):
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .allAvailabilityZones(true)
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(                
     *                     &#34;not-opted-in&#34;,
     *                     &#34;opted-in&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     * Only Availability Zones (no Local Zones):
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(&#34;opt-in-not-required&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetAvailabilityZonesResult> getAvailabilityZonesPlain(GetAvailabilityZonesPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:index/getAvailabilityZones:getAvailabilityZones", TypeShape.of(GetAvailabilityZonesResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to get the Account ID of the [AWS Billing and Cost Management Service Account](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-getting-started.html#step-2) for the purpose of permitting in S3 bucket policy.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetBillingServiceAccountArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketAclV2;
     * import com.pulumi.aws.s3.BucketAclV2Args;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.s3.BucketPolicy;
     * import com.pulumi.aws.s3.BucketPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var main = AwsFunctions.getBillingServiceAccount();
     * 
     *         var billingLogs = new BucketV2(&#34;billingLogs&#34;);
     * 
     *         var billingLogsAcl = new BucketAclV2(&#34;billingLogsAcl&#34;, BucketAclV2Args.builder()        
     *             .bucket(billingLogs.id())
     *             .acl(&#34;private&#34;)
     *             .build());
     * 
     *         final var allowBillingLoggingPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(            
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect(&#34;Allow&#34;)
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type(&#34;AWS&#34;)
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -&gt; getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(                    
     *                         &#34;s3:GetBucketAcl&#34;,
     *                         &#34;s3:GetBucketPolicy&#34;)
     *                     .resources(billingLogs.arn())
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect(&#34;Allow&#34;)
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type(&#34;AWS&#34;)
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -&gt; getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(&#34;s3:PutObject&#34;)
     *                     .resources(billingLogs.arn().applyValue(arn -&gt; String.format(&#34;%s/*&#34;, arn)))
     *                     .build())
     *             .build());
     * 
     *         var allowBillingLoggingBucketPolicy = new BucketPolicy(&#34;allowBillingLoggingBucketPolicy&#34;, BucketPolicyArgs.builder()        
     *             .bucket(billingLogs.id())
     *             .policy(allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult).applyValue(allowBillingLoggingPolicyDocument -&gt; allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json())))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetBillingServiceAccountResult> getBillingServiceAccount() {
        return getBillingServiceAccount(GetBillingServiceAccountArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the Account ID of the [AWS Billing and Cost Management Service Account](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-getting-started.html#step-2) for the purpose of permitting in S3 bucket policy.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetBillingServiceAccountArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketAclV2;
     * import com.pulumi.aws.s3.BucketAclV2Args;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.s3.BucketPolicy;
     * import com.pulumi.aws.s3.BucketPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var main = AwsFunctions.getBillingServiceAccount();
     * 
     *         var billingLogs = new BucketV2(&#34;billingLogs&#34;);
     * 
     *         var billingLogsAcl = new BucketAclV2(&#34;billingLogsAcl&#34;, BucketAclV2Args.builder()        
     *             .bucket(billingLogs.id())
     *             .acl(&#34;private&#34;)
     *             .build());
     * 
     *         final var allowBillingLoggingPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(            
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect(&#34;Allow&#34;)
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type(&#34;AWS&#34;)
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -&gt; getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(                    
     *                         &#34;s3:GetBucketAcl&#34;,
     *                         &#34;s3:GetBucketPolicy&#34;)
     *                     .resources(billingLogs.arn())
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect(&#34;Allow&#34;)
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type(&#34;AWS&#34;)
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -&gt; getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(&#34;s3:PutObject&#34;)
     *                     .resources(billingLogs.arn().applyValue(arn -&gt; String.format(&#34;%s/*&#34;, arn)))
     *                     .build())
     *             .build());
     * 
     *         var allowBillingLoggingBucketPolicy = new BucketPolicy(&#34;allowBillingLoggingBucketPolicy&#34;, BucketPolicyArgs.builder()        
     *             .bucket(billingLogs.id())
     *             .policy(allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult).applyValue(allowBillingLoggingPolicyDocument -&gt; allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json())))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetBillingServiceAccountResult> getBillingServiceAccountPlain() {
        return getBillingServiceAccountPlain(GetBillingServiceAccountPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the Account ID of the [AWS Billing and Cost Management Service Account](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-getting-started.html#step-2) for the purpose of permitting in S3 bucket policy.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetBillingServiceAccountArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketAclV2;
     * import com.pulumi.aws.s3.BucketAclV2Args;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.s3.BucketPolicy;
     * import com.pulumi.aws.s3.BucketPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var main = AwsFunctions.getBillingServiceAccount();
     * 
     *         var billingLogs = new BucketV2(&#34;billingLogs&#34;);
     * 
     *         var billingLogsAcl = new BucketAclV2(&#34;billingLogsAcl&#34;, BucketAclV2Args.builder()        
     *             .bucket(billingLogs.id())
     *             .acl(&#34;private&#34;)
     *             .build());
     * 
     *         final var allowBillingLoggingPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(            
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect(&#34;Allow&#34;)
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type(&#34;AWS&#34;)
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -&gt; getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(                    
     *                         &#34;s3:GetBucketAcl&#34;,
     *                         &#34;s3:GetBucketPolicy&#34;)
     *                     .resources(billingLogs.arn())
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect(&#34;Allow&#34;)
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type(&#34;AWS&#34;)
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -&gt; getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(&#34;s3:PutObject&#34;)
     *                     .resources(billingLogs.arn().applyValue(arn -&gt; String.format(&#34;%s/*&#34;, arn)))
     *                     .build())
     *             .build());
     * 
     *         var allowBillingLoggingBucketPolicy = new BucketPolicy(&#34;allowBillingLoggingBucketPolicy&#34;, BucketPolicyArgs.builder()        
     *             .bucket(billingLogs.id())
     *             .policy(allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult).applyValue(allowBillingLoggingPolicyDocument -&gt; allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json())))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetBillingServiceAccountResult> getBillingServiceAccount(GetBillingServiceAccountArgs args) {
        return getBillingServiceAccount(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the Account ID of the [AWS Billing and Cost Management Service Account](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-getting-started.html#step-2) for the purpose of permitting in S3 bucket policy.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetBillingServiceAccountArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketAclV2;
     * import com.pulumi.aws.s3.BucketAclV2Args;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.s3.BucketPolicy;
     * import com.pulumi.aws.s3.BucketPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var main = AwsFunctions.getBillingServiceAccount();
     * 
     *         var billingLogs = new BucketV2(&#34;billingLogs&#34;);
     * 
     *         var billingLogsAcl = new BucketAclV2(&#34;billingLogsAcl&#34;, BucketAclV2Args.builder()        
     *             .bucket(billingLogs.id())
     *             .acl(&#34;private&#34;)
     *             .build());
     * 
     *         final var allowBillingLoggingPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(            
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect(&#34;Allow&#34;)
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type(&#34;AWS&#34;)
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -&gt; getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(                    
     *                         &#34;s3:GetBucketAcl&#34;,
     *                         &#34;s3:GetBucketPolicy&#34;)
     *                     .resources(billingLogs.arn())
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect(&#34;Allow&#34;)
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type(&#34;AWS&#34;)
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -&gt; getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(&#34;s3:PutObject&#34;)
     *                     .resources(billingLogs.arn().applyValue(arn -&gt; String.format(&#34;%s/*&#34;, arn)))
     *                     .build())
     *             .build());
     * 
     *         var allowBillingLoggingBucketPolicy = new BucketPolicy(&#34;allowBillingLoggingBucketPolicy&#34;, BucketPolicyArgs.builder()        
     *             .bucket(billingLogs.id())
     *             .policy(allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult).applyValue(allowBillingLoggingPolicyDocument -&gt; allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json())))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetBillingServiceAccountResult> getBillingServiceAccountPlain(GetBillingServiceAccountPlainArgs args) {
        return getBillingServiceAccountPlain(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the Account ID of the [AWS Billing and Cost Management Service Account](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-getting-started.html#step-2) for the purpose of permitting in S3 bucket policy.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetBillingServiceAccountArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketAclV2;
     * import com.pulumi.aws.s3.BucketAclV2Args;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.s3.BucketPolicy;
     * import com.pulumi.aws.s3.BucketPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var main = AwsFunctions.getBillingServiceAccount();
     * 
     *         var billingLogs = new BucketV2(&#34;billingLogs&#34;);
     * 
     *         var billingLogsAcl = new BucketAclV2(&#34;billingLogsAcl&#34;, BucketAclV2Args.builder()        
     *             .bucket(billingLogs.id())
     *             .acl(&#34;private&#34;)
     *             .build());
     * 
     *         final var allowBillingLoggingPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(            
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect(&#34;Allow&#34;)
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type(&#34;AWS&#34;)
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -&gt; getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(                    
     *                         &#34;s3:GetBucketAcl&#34;,
     *                         &#34;s3:GetBucketPolicy&#34;)
     *                     .resources(billingLogs.arn())
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect(&#34;Allow&#34;)
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type(&#34;AWS&#34;)
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -&gt; getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(&#34;s3:PutObject&#34;)
     *                     .resources(billingLogs.arn().applyValue(arn -&gt; String.format(&#34;%s/*&#34;, arn)))
     *                     .build())
     *             .build());
     * 
     *         var allowBillingLoggingBucketPolicy = new BucketPolicy(&#34;allowBillingLoggingBucketPolicy&#34;, BucketPolicyArgs.builder()        
     *             .bucket(billingLogs.id())
     *             .policy(allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult).applyValue(allowBillingLoggingPolicyDocument -&gt; allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json())))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetBillingServiceAccountResult> getBillingServiceAccount(GetBillingServiceAccountArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:index/getBillingServiceAccount:getBillingServiceAccount", TypeShape.of(GetBillingServiceAccountResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to get the Account ID of the [AWS Billing and Cost Management Service Account](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-getting-started.html#step-2) for the purpose of permitting in S3 bucket policy.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetBillingServiceAccountArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketAclV2;
     * import com.pulumi.aws.s3.BucketAclV2Args;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.s3.BucketPolicy;
     * import com.pulumi.aws.s3.BucketPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var main = AwsFunctions.getBillingServiceAccount();
     * 
     *         var billingLogs = new BucketV2(&#34;billingLogs&#34;);
     * 
     *         var billingLogsAcl = new BucketAclV2(&#34;billingLogsAcl&#34;, BucketAclV2Args.builder()        
     *             .bucket(billingLogs.id())
     *             .acl(&#34;private&#34;)
     *             .build());
     * 
     *         final var allowBillingLoggingPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(            
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect(&#34;Allow&#34;)
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type(&#34;AWS&#34;)
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -&gt; getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(                    
     *                         &#34;s3:GetBucketAcl&#34;,
     *                         &#34;s3:GetBucketPolicy&#34;)
     *                     .resources(billingLogs.arn())
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect(&#34;Allow&#34;)
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type(&#34;AWS&#34;)
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -&gt; getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(&#34;s3:PutObject&#34;)
     *                     .resources(billingLogs.arn().applyValue(arn -&gt; String.format(&#34;%s/*&#34;, arn)))
     *                     .build())
     *             .build());
     * 
     *         var allowBillingLoggingBucketPolicy = new BucketPolicy(&#34;allowBillingLoggingBucketPolicy&#34;, BucketPolicyArgs.builder()        
     *             .bucket(billingLogs.id())
     *             .policy(allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult).applyValue(allowBillingLoggingPolicyDocument -&gt; allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json())))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetBillingServiceAccountResult> getBillingServiceAccountPlain(GetBillingServiceAccountPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:index/getBillingServiceAccount:getBillingServiceAccount", TypeShape.of(GetBillingServiceAccountResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to get the access to the effective Account ID, User ID, and ARN in
     * which this provider is authorized.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     * 
     *         ctx.export(&#34;accountId&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()));
     *         ctx.export(&#34;callerArn&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.arn()));
     *         ctx.export(&#34;callerUser&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.userId()));
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetCallerIdentityResult> getCallerIdentity() {
        return getCallerIdentity(GetCallerIdentityArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the access to the effective Account ID, User ID, and ARN in
     * which this provider is authorized.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     * 
     *         ctx.export(&#34;accountId&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()));
     *         ctx.export(&#34;callerArn&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.arn()));
     *         ctx.export(&#34;callerUser&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.userId()));
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetCallerIdentityResult> getCallerIdentityPlain() {
        return getCallerIdentityPlain(GetCallerIdentityPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the access to the effective Account ID, User ID, and ARN in
     * which this provider is authorized.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     * 
     *         ctx.export(&#34;accountId&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()));
     *         ctx.export(&#34;callerArn&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.arn()));
     *         ctx.export(&#34;callerUser&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.userId()));
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetCallerIdentityResult> getCallerIdentity(GetCallerIdentityArgs args) {
        return getCallerIdentity(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the access to the effective Account ID, User ID, and ARN in
     * which this provider is authorized.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     * 
     *         ctx.export(&#34;accountId&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()));
     *         ctx.export(&#34;callerArn&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.arn()));
     *         ctx.export(&#34;callerUser&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.userId()));
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetCallerIdentityResult> getCallerIdentityPlain(GetCallerIdentityPlainArgs args) {
        return getCallerIdentityPlain(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the access to the effective Account ID, User ID, and ARN in
     * which this provider is authorized.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     * 
     *         ctx.export(&#34;accountId&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()));
     *         ctx.export(&#34;callerArn&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.arn()));
     *         ctx.export(&#34;callerUser&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.userId()));
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetCallerIdentityResult> getCallerIdentity(GetCallerIdentityArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:index/getCallerIdentity:getCallerIdentity", TypeShape.of(GetCallerIdentityResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to get the access to the effective Account ID, User ID, and ARN in
     * which this provider is authorized.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     * 
     *         ctx.export(&#34;accountId&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()));
     *         ctx.export(&#34;callerArn&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.arn()));
     *         ctx.export(&#34;callerUser&#34;, current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.userId()));
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetCallerIdentityResult> getCallerIdentityPlain(GetCallerIdentityPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:index/getCallerIdentity:getCallerIdentity", TypeShape.of(GetCallerIdentityResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to get the default tags configured on the provider.
     * 
     * With this data source, you can apply default tags to resources not _directly_ managed by a TODO resource, such as the instances underneath an Auto Scaling group or the volumes created for an EC2 instance.
     * 
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getDefaultTags();
     * 
     *     }
     * }
     * ```
     * ### Dynamically Apply Default Tags to Auto Scaling Group
     * 
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import com.pulumi.aws.autoscaling.Group;
     * import com.pulumi.aws.autoscaling.GroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var exampleDefaultTags = AwsFunctions.getDefaultTags();
     * 
     *         var exampleGroup = new Group(&#34;exampleGroup&#34;, GroupArgs.builder()        
     *             .dynamic(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetDefaultTagsResult> getDefaultTags() {
        return getDefaultTags(GetDefaultTagsArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the default tags configured on the provider.
     * 
     * With this data source, you can apply default tags to resources not _directly_ managed by a TODO resource, such as the instances underneath an Auto Scaling group or the volumes created for an EC2 instance.
     * 
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getDefaultTags();
     * 
     *     }
     * }
     * ```
     * ### Dynamically Apply Default Tags to Auto Scaling Group
     * 
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import com.pulumi.aws.autoscaling.Group;
     * import com.pulumi.aws.autoscaling.GroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var exampleDefaultTags = AwsFunctions.getDefaultTags();
     * 
     *         var exampleGroup = new Group(&#34;exampleGroup&#34;, GroupArgs.builder()        
     *             .dynamic(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetDefaultTagsResult> getDefaultTagsPlain() {
        return getDefaultTagsPlain(GetDefaultTagsPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the default tags configured on the provider.
     * 
     * With this data source, you can apply default tags to resources not _directly_ managed by a TODO resource, such as the instances underneath an Auto Scaling group or the volumes created for an EC2 instance.
     * 
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getDefaultTags();
     * 
     *     }
     * }
     * ```
     * ### Dynamically Apply Default Tags to Auto Scaling Group
     * 
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import com.pulumi.aws.autoscaling.Group;
     * import com.pulumi.aws.autoscaling.GroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var exampleDefaultTags = AwsFunctions.getDefaultTags();
     * 
     *         var exampleGroup = new Group(&#34;exampleGroup&#34;, GroupArgs.builder()        
     *             .dynamic(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetDefaultTagsResult> getDefaultTags(GetDefaultTagsArgs args) {
        return getDefaultTags(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the default tags configured on the provider.
     * 
     * With this data source, you can apply default tags to resources not _directly_ managed by a TODO resource, such as the instances underneath an Auto Scaling group or the volumes created for an EC2 instance.
     * 
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getDefaultTags();
     * 
     *     }
     * }
     * ```
     * ### Dynamically Apply Default Tags to Auto Scaling Group
     * 
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import com.pulumi.aws.autoscaling.Group;
     * import com.pulumi.aws.autoscaling.GroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var exampleDefaultTags = AwsFunctions.getDefaultTags();
     * 
     *         var exampleGroup = new Group(&#34;exampleGroup&#34;, GroupArgs.builder()        
     *             .dynamic(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetDefaultTagsResult> getDefaultTagsPlain(GetDefaultTagsPlainArgs args) {
        return getDefaultTagsPlain(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the default tags configured on the provider.
     * 
     * With this data source, you can apply default tags to resources not _directly_ managed by a TODO resource, such as the instances underneath an Auto Scaling group or the volumes created for an EC2 instance.
     * 
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getDefaultTags();
     * 
     *     }
     * }
     * ```
     * ### Dynamically Apply Default Tags to Auto Scaling Group
     * 
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import com.pulumi.aws.autoscaling.Group;
     * import com.pulumi.aws.autoscaling.GroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var exampleDefaultTags = AwsFunctions.getDefaultTags();
     * 
     *         var exampleGroup = new Group(&#34;exampleGroup&#34;, GroupArgs.builder()        
     *             .dynamic(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetDefaultTagsResult> getDefaultTags(GetDefaultTagsArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:index/getDefaultTags:getDefaultTags", TypeShape.of(GetDefaultTagsResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to get the default tags configured on the provider.
     * 
     * With this data source, you can apply default tags to resources not _directly_ managed by a TODO resource, such as the instances underneath an Auto Scaling group or the volumes created for an EC2 instance.
     * 
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getDefaultTags();
     * 
     *     }
     * }
     * ```
     * ### Dynamically Apply Default Tags to Auto Scaling Group
     * 
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import com.pulumi.aws.autoscaling.Group;
     * import com.pulumi.aws.autoscaling.GroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var exampleDefaultTags = AwsFunctions.getDefaultTags();
     * 
     *         var exampleGroup = new Group(&#34;exampleGroup&#34;, GroupArgs.builder()        
     *             .dynamic(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetDefaultTagsResult> getDefaultTagsPlain(GetDefaultTagsPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:index/getDefaultTags:getDefaultTags", TypeShape.of(GetDefaultTagsResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to get the IP ranges of various AWS products and services. For more information about the contents of this data source and required JSON syntax if referencing a custom URL, see the [AWS IP Address Ranges documentation](https://docs.aws.amazon.com/general/latest/gr/aws-ip-ranges.html).
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetIpRangesArgs;
     * import com.pulumi.aws.ec2.SecurityGroup;
     * import com.pulumi.aws.ec2.SecurityGroupArgs;
     * import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var europeanEc2 = AwsFunctions.getIpRanges(GetIpRangesArgs.builder()
     *             .regions(            
     *                 &#34;eu-west-1&#34;,
     *                 &#34;eu-central-1&#34;)
     *             .services(&#34;ec2&#34;)
     *             .build());
     * 
     *         var fromEurope = new SecurityGroup(&#34;fromEurope&#34;, SecurityGroupArgs.builder()        
     *             .ingress(SecurityGroupIngressArgs.builder()
     *                 .fromPort(&#34;443&#34;)
     *                 .toPort(&#34;443&#34;)
     *                 .protocol(&#34;tcp&#34;)
     *                 .cidrBlocks(europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.cidrBlocks()))
     *                 .ipv6CidrBlocks(europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.ipv6CidrBlocks()))
     *                 .build())
     *             .tags(Map.ofEntries(
     *                 Map.entry(&#34;CreateDate&#34;, europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.createDate())),
     *                 Map.entry(&#34;SyncToken&#34;, europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.syncToken()))
     *             ))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetIpRangesResult> getIpRanges(GetIpRangesArgs args) {
        return getIpRanges(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the IP ranges of various AWS products and services. For more information about the contents of this data source and required JSON syntax if referencing a custom URL, see the [AWS IP Address Ranges documentation](https://docs.aws.amazon.com/general/latest/gr/aws-ip-ranges.html).
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetIpRangesArgs;
     * import com.pulumi.aws.ec2.SecurityGroup;
     * import com.pulumi.aws.ec2.SecurityGroupArgs;
     * import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var europeanEc2 = AwsFunctions.getIpRanges(GetIpRangesArgs.builder()
     *             .regions(            
     *                 &#34;eu-west-1&#34;,
     *                 &#34;eu-central-1&#34;)
     *             .services(&#34;ec2&#34;)
     *             .build());
     * 
     *         var fromEurope = new SecurityGroup(&#34;fromEurope&#34;, SecurityGroupArgs.builder()        
     *             .ingress(SecurityGroupIngressArgs.builder()
     *                 .fromPort(&#34;443&#34;)
     *                 .toPort(&#34;443&#34;)
     *                 .protocol(&#34;tcp&#34;)
     *                 .cidrBlocks(europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.cidrBlocks()))
     *                 .ipv6CidrBlocks(europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.ipv6CidrBlocks()))
     *                 .build())
     *             .tags(Map.ofEntries(
     *                 Map.entry(&#34;CreateDate&#34;, europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.createDate())),
     *                 Map.entry(&#34;SyncToken&#34;, europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.syncToken()))
     *             ))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetIpRangesResult> getIpRangesPlain(GetIpRangesPlainArgs args) {
        return getIpRangesPlain(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the IP ranges of various AWS products and services. For more information about the contents of this data source and required JSON syntax if referencing a custom URL, see the [AWS IP Address Ranges documentation](https://docs.aws.amazon.com/general/latest/gr/aws-ip-ranges.html).
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetIpRangesArgs;
     * import com.pulumi.aws.ec2.SecurityGroup;
     * import com.pulumi.aws.ec2.SecurityGroupArgs;
     * import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var europeanEc2 = AwsFunctions.getIpRanges(GetIpRangesArgs.builder()
     *             .regions(            
     *                 &#34;eu-west-1&#34;,
     *                 &#34;eu-central-1&#34;)
     *             .services(&#34;ec2&#34;)
     *             .build());
     * 
     *         var fromEurope = new SecurityGroup(&#34;fromEurope&#34;, SecurityGroupArgs.builder()        
     *             .ingress(SecurityGroupIngressArgs.builder()
     *                 .fromPort(&#34;443&#34;)
     *                 .toPort(&#34;443&#34;)
     *                 .protocol(&#34;tcp&#34;)
     *                 .cidrBlocks(europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.cidrBlocks()))
     *                 .ipv6CidrBlocks(europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.ipv6CidrBlocks()))
     *                 .build())
     *             .tags(Map.ofEntries(
     *                 Map.entry(&#34;CreateDate&#34;, europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.createDate())),
     *                 Map.entry(&#34;SyncToken&#34;, europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.syncToken()))
     *             ))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetIpRangesResult> getIpRanges(GetIpRangesArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:index/getIpRanges:getIpRanges", TypeShape.of(GetIpRangesResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to get the IP ranges of various AWS products and services. For more information about the contents of this data source and required JSON syntax if referencing a custom URL, see the [AWS IP Address Ranges documentation](https://docs.aws.amazon.com/general/latest/gr/aws-ip-ranges.html).
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetIpRangesArgs;
     * import com.pulumi.aws.ec2.SecurityGroup;
     * import com.pulumi.aws.ec2.SecurityGroupArgs;
     * import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var europeanEc2 = AwsFunctions.getIpRanges(GetIpRangesArgs.builder()
     *             .regions(            
     *                 &#34;eu-west-1&#34;,
     *                 &#34;eu-central-1&#34;)
     *             .services(&#34;ec2&#34;)
     *             .build());
     * 
     *         var fromEurope = new SecurityGroup(&#34;fromEurope&#34;, SecurityGroupArgs.builder()        
     *             .ingress(SecurityGroupIngressArgs.builder()
     *                 .fromPort(&#34;443&#34;)
     *                 .toPort(&#34;443&#34;)
     *                 .protocol(&#34;tcp&#34;)
     *                 .cidrBlocks(europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.cidrBlocks()))
     *                 .ipv6CidrBlocks(europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.ipv6CidrBlocks()))
     *                 .build())
     *             .tags(Map.ofEntries(
     *                 Map.entry(&#34;CreateDate&#34;, europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.createDate())),
     *                 Map.entry(&#34;SyncToken&#34;, europeanEc2.applyValue(getIpRangesResult -&gt; getIpRangesResult.syncToken()))
     *             ))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetIpRangesResult> getIpRangesPlain(GetIpRangesPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:index/getIpRanges:getIpRanges", TypeShape.of(GetIpRangesResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to lookup information about the current AWS partition in
     * which the provider is working.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetPartitionArgs;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getPartition();
     * 
     *         final var s3Policy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .actions(&#34;s3:ListBucket&#34;)
     *                 .resources(String.format(&#34;arn:%s:s3:::my-bucket&#34;, current.applyValue(getPartitionResult -&gt; getPartitionResult.partition())))
     *                 .sid(&#34;1&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetPartitionResult> getPartition() {
        return getPartition(GetPartitionArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to lookup information about the current AWS partition in
     * which the provider is working.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetPartitionArgs;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getPartition();
     * 
     *         final var s3Policy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .actions(&#34;s3:ListBucket&#34;)
     *                 .resources(String.format(&#34;arn:%s:s3:::my-bucket&#34;, current.applyValue(getPartitionResult -&gt; getPartitionResult.partition())))
     *                 .sid(&#34;1&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetPartitionResult> getPartitionPlain() {
        return getPartitionPlain(GetPartitionPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to lookup information about the current AWS partition in
     * which the provider is working.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetPartitionArgs;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getPartition();
     * 
     *         final var s3Policy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .actions(&#34;s3:ListBucket&#34;)
     *                 .resources(String.format(&#34;arn:%s:s3:::my-bucket&#34;, current.applyValue(getPartitionResult -&gt; getPartitionResult.partition())))
     *                 .sid(&#34;1&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetPartitionResult> getPartition(GetPartitionArgs args) {
        return getPartition(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to lookup information about the current AWS partition in
     * which the provider is working.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetPartitionArgs;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getPartition();
     * 
     *         final var s3Policy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .actions(&#34;s3:ListBucket&#34;)
     *                 .resources(String.format(&#34;arn:%s:s3:::my-bucket&#34;, current.applyValue(getPartitionResult -&gt; getPartitionResult.partition())))
     *                 .sid(&#34;1&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetPartitionResult> getPartitionPlain(GetPartitionPlainArgs args) {
        return getPartitionPlain(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to lookup information about the current AWS partition in
     * which the provider is working.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetPartitionArgs;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getPartition();
     * 
     *         final var s3Policy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .actions(&#34;s3:ListBucket&#34;)
     *                 .resources(String.format(&#34;arn:%s:s3:::my-bucket&#34;, current.applyValue(getPartitionResult -&gt; getPartitionResult.partition())))
     *                 .sid(&#34;1&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetPartitionResult> getPartition(GetPartitionArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:index/getPartition:getPartition", TypeShape.of(GetPartitionResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to lookup information about the current AWS partition in
     * which the provider is working.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetPartitionArgs;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getPartition();
     * 
     *         final var s3Policy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .actions(&#34;s3:ListBucket&#34;)
     *                 .resources(String.format(&#34;arn:%s:s3:::my-bucket&#34;, current.applyValue(getPartitionResult -&gt; getPartitionResult.partition())))
     *                 .sid(&#34;1&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetPartitionResult> getPartitionPlain(GetPartitionPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:index/getPartition:getPartition", TypeShape.of(GetPartitionResult.class), args, Utilities.withVersion(options));
    }
    /**
     * `aws.getRegion` provides details about a specific AWS region.
     * 
     * As well as validating a given region name this resource can be used to
     * discover the name of the region configured within the provider. The latter
     * can be useful in a child module which is inheriting an AWS provider
     * configuration from its parent module.
     * 
     * ## Example Usage
     * 
     * The following example shows how the resource might be used to obtain
     * the name of the AWS region configured on the provider.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetRegionResult> getRegion() {
        return getRegion(GetRegionArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * `aws.getRegion` provides details about a specific AWS region.
     * 
     * As well as validating a given region name this resource can be used to
     * discover the name of the region configured within the provider. The latter
     * can be useful in a child module which is inheriting an AWS provider
     * configuration from its parent module.
     * 
     * ## Example Usage
     * 
     * The following example shows how the resource might be used to obtain
     * the name of the AWS region configured on the provider.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetRegionResult> getRegionPlain() {
        return getRegionPlain(GetRegionPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * `aws.getRegion` provides details about a specific AWS region.
     * 
     * As well as validating a given region name this resource can be used to
     * discover the name of the region configured within the provider. The latter
     * can be useful in a child module which is inheriting an AWS provider
     * configuration from its parent module.
     * 
     * ## Example Usage
     * 
     * The following example shows how the resource might be used to obtain
     * the name of the AWS region configured on the provider.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetRegionResult> getRegion(GetRegionArgs args) {
        return getRegion(args, InvokeOptions.Empty);
    }
    /**
     * `aws.getRegion` provides details about a specific AWS region.
     * 
     * As well as validating a given region name this resource can be used to
     * discover the name of the region configured within the provider. The latter
     * can be useful in a child module which is inheriting an AWS provider
     * configuration from its parent module.
     * 
     * ## Example Usage
     * 
     * The following example shows how the resource might be used to obtain
     * the name of the AWS region configured on the provider.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetRegionResult> getRegionPlain(GetRegionPlainArgs args) {
        return getRegionPlain(args, InvokeOptions.Empty);
    }
    /**
     * `aws.getRegion` provides details about a specific AWS region.
     * 
     * As well as validating a given region name this resource can be used to
     * discover the name of the region configured within the provider. The latter
     * can be useful in a child module which is inheriting an AWS provider
     * configuration from its parent module.
     * 
     * ## Example Usage
     * 
     * The following example shows how the resource might be used to obtain
     * the name of the AWS region configured on the provider.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetRegionResult> getRegion(GetRegionArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:index/getRegion:getRegion", TypeShape.of(GetRegionResult.class), args, Utilities.withVersion(options));
    }
    /**
     * `aws.getRegion` provides details about a specific AWS region.
     * 
     * As well as validating a given region name this resource can be used to
     * discover the name of the region configured within the provider. The latter
     * can be useful in a child module which is inheriting an AWS provider
     * configuration from its parent module.
     * 
     * ## Example Usage
     * 
     * The following example shows how the resource might be used to obtain
     * the name of the AWS region configured on the provider.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetRegionResult> getRegionPlain(GetRegionPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:index/getRegion:getRegion", TypeShape.of(GetRegionResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Provides information about AWS Regions. Can be used to filter regions i.e., by Opt-In status or only regions enabled for current account. To get details like endpoint and description of each region the data source can be combined with the `aws.getRegion` data source.
     * 
     * ## Example Usage
     * 
     * Enabled AWS Regions:
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions();
     * 
     *     }
     * }
     * ```
     * 
     * All the regions regardless of the availability
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     * To see regions that are filtered by `&#34;not-opted-in&#34;`, the `all_regions` argument needs to be set to `true` or no results will be returned.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .filters(GetRegionsFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(&#34;not-opted-in&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetRegionsResult> getRegions() {
        return getRegions(GetRegionsArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Provides information about AWS Regions. Can be used to filter regions i.e., by Opt-In status or only regions enabled for current account. To get details like endpoint and description of each region the data source can be combined with the `aws.getRegion` data source.
     * 
     * ## Example Usage
     * 
     * Enabled AWS Regions:
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions();
     * 
     *     }
     * }
     * ```
     * 
     * All the regions regardless of the availability
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     * To see regions that are filtered by `&#34;not-opted-in&#34;`, the `all_regions` argument needs to be set to `true` or no results will be returned.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .filters(GetRegionsFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(&#34;not-opted-in&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetRegionsResult> getRegionsPlain() {
        return getRegionsPlain(GetRegionsPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Provides information about AWS Regions. Can be used to filter regions i.e., by Opt-In status or only regions enabled for current account. To get details like endpoint and description of each region the data source can be combined with the `aws.getRegion` data source.
     * 
     * ## Example Usage
     * 
     * Enabled AWS Regions:
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions();
     * 
     *     }
     * }
     * ```
     * 
     * All the regions regardless of the availability
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     * To see regions that are filtered by `&#34;not-opted-in&#34;`, the `all_regions` argument needs to be set to `true` or no results will be returned.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .filters(GetRegionsFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(&#34;not-opted-in&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetRegionsResult> getRegions(GetRegionsArgs args) {
        return getRegions(args, InvokeOptions.Empty);
    }
    /**
     * Provides information about AWS Regions. Can be used to filter regions i.e., by Opt-In status or only regions enabled for current account. To get details like endpoint and description of each region the data source can be combined with the `aws.getRegion` data source.
     * 
     * ## Example Usage
     * 
     * Enabled AWS Regions:
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions();
     * 
     *     }
     * }
     * ```
     * 
     * All the regions regardless of the availability
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     * To see regions that are filtered by `&#34;not-opted-in&#34;`, the `all_regions` argument needs to be set to `true` or no results will be returned.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .filters(GetRegionsFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(&#34;not-opted-in&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetRegionsResult> getRegionsPlain(GetRegionsPlainArgs args) {
        return getRegionsPlain(args, InvokeOptions.Empty);
    }
    /**
     * Provides information about AWS Regions. Can be used to filter regions i.e., by Opt-In status or only regions enabled for current account. To get details like endpoint and description of each region the data source can be combined with the `aws.getRegion` data source.
     * 
     * ## Example Usage
     * 
     * Enabled AWS Regions:
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions();
     * 
     *     }
     * }
     * ```
     * 
     * All the regions regardless of the availability
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     * To see regions that are filtered by `&#34;not-opted-in&#34;`, the `all_regions` argument needs to be set to `true` or no results will be returned.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .filters(GetRegionsFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(&#34;not-opted-in&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetRegionsResult> getRegions(GetRegionsArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:index/getRegions:getRegions", TypeShape.of(GetRegionsResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Provides information about AWS Regions. Can be used to filter regions i.e., by Opt-In status or only regions enabled for current account. To get details like endpoint and description of each region the data source can be combined with the `aws.getRegion` data source.
     * 
     * ## Example Usage
     * 
     * Enabled AWS Regions:
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions();
     * 
     *     }
     * }
     * ```
     * 
     * All the regions regardless of the availability
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     * To see regions that are filtered by `&#34;not-opted-in&#34;`, the `all_regions` argument needs to be set to `true` or no results will be returned.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .filters(GetRegionsFilterArgs.builder()
     *                 .name(&#34;opt-in-status&#34;)
     *                 .values(&#34;not-opted-in&#34;)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetRegionsResult> getRegionsPlain(GetRegionsPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:index/getRegions:getRegions", TypeShape.of(GetRegionsResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to compose and decompose AWS service DNS names.
     * 
     * ## Example Usage
     * ### Get Service DNS Name
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     * 
     *         final var test = AwsFunctions.getService(GetServiceArgs.builder()
     *             .region(current.applyValue(getRegionResult -&gt; getRegionResult.name()))
     *             .serviceId(&#34;ec2&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### Use Service Reverse DNS Name to Get Components
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName(&#34;cn.com.amazonaws.cn-north-1.s3&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### Determine Regional Support for a Service
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName(&#34;com.amazonaws.us-gov-west-1.waf&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetServiceResult> getService() {
        return getService(GetServiceArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to compose and decompose AWS service DNS names.
     * 
     * ## Example Usage
     * ### Get Service DNS Name
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     * 
     *         final var test = AwsFunctions.getService(GetServiceArgs.builder()
     *             .region(current.applyValue(getRegionResult -&gt; getRegionResult.name()))
     *             .serviceId(&#34;ec2&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### Use Service Reverse DNS Name to Get Components
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName(&#34;cn.com.amazonaws.cn-north-1.s3&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### Determine Regional Support for a Service
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName(&#34;com.amazonaws.us-gov-west-1.waf&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetServiceResult> getServicePlain() {
        return getServicePlain(GetServicePlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to compose and decompose AWS service DNS names.
     * 
     * ## Example Usage
     * ### Get Service DNS Name
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     * 
     *         final var test = AwsFunctions.getService(GetServiceArgs.builder()
     *             .region(current.applyValue(getRegionResult -&gt; getRegionResult.name()))
     *             .serviceId(&#34;ec2&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### Use Service Reverse DNS Name to Get Components
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName(&#34;cn.com.amazonaws.cn-north-1.s3&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### Determine Regional Support for a Service
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName(&#34;com.amazonaws.us-gov-west-1.waf&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetServiceResult> getService(GetServiceArgs args) {
        return getService(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to compose and decompose AWS service DNS names.
     * 
     * ## Example Usage
     * ### Get Service DNS Name
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     * 
     *         final var test = AwsFunctions.getService(GetServiceArgs.builder()
     *             .region(current.applyValue(getRegionResult -&gt; getRegionResult.name()))
     *             .serviceId(&#34;ec2&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### Use Service Reverse DNS Name to Get Components
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName(&#34;cn.com.amazonaws.cn-north-1.s3&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### Determine Regional Support for a Service
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName(&#34;com.amazonaws.us-gov-west-1.waf&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetServiceResult> getServicePlain(GetServicePlainArgs args) {
        return getServicePlain(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to compose and decompose AWS service DNS names.
     * 
     * ## Example Usage
     * ### Get Service DNS Name
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     * 
     *         final var test = AwsFunctions.getService(GetServiceArgs.builder()
     *             .region(current.applyValue(getRegionResult -&gt; getRegionResult.name()))
     *             .serviceId(&#34;ec2&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### Use Service Reverse DNS Name to Get Components
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName(&#34;cn.com.amazonaws.cn-north-1.s3&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### Determine Regional Support for a Service
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName(&#34;com.amazonaws.us-gov-west-1.waf&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetServiceResult> getService(GetServiceArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:index/getService:getService", TypeShape.of(GetServiceResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to compose and decompose AWS service DNS names.
     * 
     * ## Example Usage
     * ### Get Service DNS Name
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     * 
     *         final var test = AwsFunctions.getService(GetServiceArgs.builder()
     *             .region(current.applyValue(getRegionResult -&gt; getRegionResult.name()))
     *             .serviceId(&#34;ec2&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### Use Service Reverse DNS Name to Get Components
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName(&#34;cn.com.amazonaws.cn-north-1.s3&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * ### Determine Regional Support for a Service
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName(&#34;com.amazonaws.us-gov-west-1.waf&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetServiceResult> getServicePlain(GetServicePlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:index/getService:getService", TypeShape.of(GetServiceResult.class), args, Utilities.withVersion(options));
    }
}
