/*
 * Decompiled with CFR 0.152.
 */
package com.github.phasebash.jsdoc3.maven.tasks;

import com.github.phasebash.jsdoc3.maven.tasks.JsDocArgumentBuilder;
import com.github.phasebash.jsdoc3.maven.tasks.StreamLogger;
import com.github.phasebash.jsdoc3.maven.tasks.Task;
import com.github.phasebash.jsdoc3.maven.tasks.TaskContext;
import com.github.phasebash.jsdoc3.maven.tasks.TaskException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.logging.Log;

final class JsDocTask
implements Task {
    private static final JsDocArgumentBuilder JS_DOC_ARGUMENT_BUILDER = new JsDocArgumentBuilder();

    JsDocTask() {
    }

    @Override
    public void execute(TaskContext context) throws TaskException {
        Process process;
        List<String> arguments = JS_DOC_ARGUMENT_BUILDER.build(context);
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        if (context.isDebug()) {
            throw new UnsupportedOperationException("Debug mode not currently supported.");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        try {
            Log log = context.getLog();
            process = processBuilder.start();
            executorService.submit(new StreamLogger(process.getErrorStream(), log));
            executorService.submit(new StreamLogger(process.getInputStream(), log));
        }
        catch (IOException e) {
            throw new TaskException("Unable to execute jsdoc tasks in new JVM.", e);
        }
        try {
            int exitCode = process.waitFor();
            executorService.awaitTermination(5L, TimeUnit.SECONDS);
            if (exitCode != 0) {
                throw new TaskException("Process died with exit code " + exitCode);
            }
        }
        catch (InterruptedException e) {
            throw new TaskException("Interrupt while waiting for jsdoc task to complete.", e);
        }
    }
}

