/*
 * Decompiled with CFR 0.152.
 */
package lib.android.paypal.com.magnessdk;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import lib.android.paypal.com.magnessdk.Environment;
import lib.android.paypal.com.magnessdk.MagnesSource;
import lib.android.paypal.com.magnessdk.network.MagnesNetworkingFactoryImpl;

public final class MagnesSettings {
    private static final int APPGUID_MAXLENGTH = 36;
    private int magnesSource = -1;
    private String appGuid;
    private String notificationToken;
    private Context context;
    private MagnesNetworkingFactoryImpl magnesNetworkingFactoryImpl;
    private boolean enableNetworkOnCallerThread;
    private boolean disableRemoteConfig = false;
    private boolean disableBeacon = false;
    private Environment environment;

    private MagnesSettings(Builder builder) {
        this.magnesSource = builder.sourceFlow;
        this.appGuid = builder.appGuid;
        this.notificationToken = builder.notificationToken;
        this.disableRemoteConfig = builder.disableRemoteConfig;
        this.disableBeacon = builder.disableBeacon;
        this.context = builder.context;
        this.magnesNetworkingFactoryImpl = builder.magnesNetworkingFactoryImpl;
        this.enableNetworkOnCallerThread = builder.enableNetworkOnCallerThread;
        this.environment = builder.environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getAppGuid() {
        return this.appGuid;
    }

    public int getMagnesSource() {
        return this.magnesSource;
    }

    public String getNotificationToken() {
        return this.notificationToken;
    }

    Context getContext() {
        return this.context;
    }

    public MagnesNetworkingFactoryImpl getMagnesNetworkingFactoryImpl() {
        return this.magnesNetworkingFactoryImpl;
    }

    public boolean isEnableNetworkOnCallerThread() {
        return this.enableNetworkOnCallerThread;
    }

    public boolean isDisableRemoteConfig() {
        return this.disableRemoteConfig;
    }

    public boolean isDisableBeacon() {
        return this.disableBeacon;
    }

    public static class Builder {
        private int sourceFlow = -1;
        private String appGuid;
        private String notificationToken;
        private boolean disableRemoteConfig = false;
        private boolean enableNetworkOnCallerThread;
        private boolean disableBeacon = false;
        private MagnesNetworkingFactoryImpl magnesNetworkingFactoryImpl;
        private Context context;
        private Environment environment = Environment.LIVE;

        public Builder(@NonNull Context context) {
            this.context = context;
        }

        public Builder setMagnesEnvironment(@NonNull Environment env) {
            this.environment = env;
            return this;
        }

        public Builder setMagnesNetworkingFactory(@NonNull MagnesNetworkingFactoryImpl magnesNetworkingFactoryImpl) {
            this.magnesNetworkingFactoryImpl = magnesNetworkingFactoryImpl;
            return this;
        }

        public Builder enableNetworkOnCallerThread(boolean networkOnCallerThread) {
            this.enableNetworkOnCallerThread = networkOnCallerThread;
            return this;
        }

        public Builder setAppGuid(@NonNull @Size(max=36L) String appGuid) {
            this.appGuid = appGuid;
            return this;
        }

        public Builder setMagnesSource(MagnesSource sourceFlow) {
            this.sourceFlow = sourceFlow.getVersion();
            return this;
        }

        public Builder setNotificationToken(@NonNull String notificationToken) {
            this.notificationToken = notificationToken;
            return this;
        }

        public Builder disableRemoteConfig(boolean disableRemoteConfig) {
            this.disableRemoteConfig = disableRemoteConfig;
            return this;
        }

        public Builder disableBeacon(boolean disableBeacon) {
            this.disableBeacon = disableBeacon;
            return this;
        }

        public MagnesSettings build() {
            return new MagnesSettings(this);
        }
    }
}

