/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.data.collector;

import android.content.Context;
import android.support.annotation.MainThread;
import com.paypal.android.sdk.data.collector.InstallationIdentifier;
import com.paypal.android.sdk.data.collector.PayPalDataCollectorRequest;
import lib.android.paypal.com.magnessdk.Environment;
import lib.android.paypal.com.magnessdk.MagnesResult;
import lib.android.paypal.com.magnessdk.MagnesSDK;
import lib.android.paypal.com.magnessdk.MagnesSettings;
import lib.android.paypal.com.magnessdk.MagnesSource;

public class PayPalDataCollector {
    @MainThread
    public static String getClientMetadataId(Context context) {
        PayPalDataCollectorRequest request = new PayPalDataCollectorRequest().setApplicationGuid(InstallationIdentifier.getInstallationGUID(context));
        return PayPalDataCollector.getClientMetadataId(context, request);
    }

    @MainThread
    public static String getClientMetadataId(Context context, String clientMetadataId) {
        PayPalDataCollectorRequest request = new PayPalDataCollectorRequest().setApplicationGuid(InstallationIdentifier.getInstallationGUID(context)).setClientMetadataId(clientMetadataId);
        return PayPalDataCollector.getClientMetadataId(context, request);
    }

    @MainThread
    public static String getClientMetadataId(Context context, PayPalDataCollectorRequest request) {
        if (context == null) {
            return "";
        }
        MagnesSDK magnesInstance = MagnesSDK.getInstance();
        MagnesSettings.Builder magnesSettingsBuilder = new MagnesSettings.Builder(context).setMagnesSource(MagnesSource.BRAINTREE).disableBeacon(request.isDisableBeacon()).setMagnesEnvironment(Environment.LIVE).setAppGuid(request.getApplicationGuid());
        magnesInstance.setUp(magnesSettingsBuilder.build());
        MagnesResult result = magnesInstance.collectAndSubmit(context, request.getClientMetadataId(), request.getAdditionalData());
        return result.getPaypalClientMetaDataId();
    }
}

