/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.rest;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.palominolabs.crm.sf.rest.ConnectionConfig;
import com.palominolabs.crm.sf.rest.HttpApiClient;
import com.palominolabs.crm.sf.rest.HttpApiClientProvider;
import com.palominolabs.crm.sf.rest.RestConnection;
import com.palominolabs.crm.sf.rest.RestConnectionImpl;
import com.palominolabs.crm.sf.rest.RestConnectionPool;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

@ThreadSafe
public class RestConnectionPoolImpl<T>
implements RestConnectionPool<T> {
    private static final int DEFAULT_IDLE_CONN_TIMEOUT = 30;
    private final int idleConnTimeout;
    private final ObjectMapper objectMapper;
    private final HttpClient httpClient;
    @GuardedBy(value="this")
    private final Map<T, ConnectionConfig> configMap = new HashMap<T, ConnectionConfig>();
    private final MetricRegistry metricRegistry;
    private final PoolingHttpClientConnectionManager connectionManager;

    public RestConnectionPoolImpl(MetricRegistry metricRegistry) {
        this(metricRegistry, 30);
    }

    public RestConnectionPoolImpl(MetricRegistry metricRegistry, int idleConnTimeout) {
        this.metricRegistry = metricRegistry;
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.connectionManager.setDefaultMaxPerRoute(20);
        this.connectionManager.setMaxTotal(60);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
        this.idleConnTimeout = idleConnTimeout;
    }

    @Override
    @Nonnull
    public synchronized RestConnection getRestConnection(@Nonnull T orgId) {
        return new RestConnectionImpl(this.objectMapper.reader(), new PoolHttpApiClientProvider(orgId), this.metricRegistry);
    }

    @Override
    public synchronized void configureOrg(@Nonnull T orgId, @Nonnull String host, @Nonnull String token) {
        this.configMap.put(orgId, new ConnectionConfig(host, token));
    }

    @Override
    @Nonnull
    public Runnable getExpiredConnectionTask() {
        return new HttpExpiredConnManager();
    }

    @Nonnull
    private synchronized HttpApiClient getClientForOrg(T orgId) {
        ConnectionConfig connectionConfig = this.configMap.get(orgId);
        if (connectionConfig == null) {
            throw new IllegalStateException("Org <" + orgId + "> has not been configured");
        }
        return new HttpApiClient(connectionConfig.getHost(), connectionConfig.getOauthToken(), this.objectMapper, this.httpClient);
    }

    private class HttpExpiredConnManager
    implements Runnable {
        private HttpExpiredConnManager() {
        }

        @Override
        public void run() {
            RestConnectionPoolImpl.this.connectionManager.closeExpiredConnections();
            RestConnectionPoolImpl.this.connectionManager.closeIdleConnections((long)RestConnectionPoolImpl.this.idleConnTimeout, TimeUnit.SECONDS);
        }
    }

    private class PoolHttpApiClientProvider
    implements HttpApiClientProvider {
        private final T orgId;

        PoolHttpApiClientProvider(T orgId) {
            this.orgId = orgId;
        }

        @Override
        @Nonnull
        public HttpApiClient getClient() {
            return RestConnectionPoolImpl.this.getClientForOrg(this.orgId);
        }
    }
}

