/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.rest;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.palominolabs.crm.sf.core.Id;
import com.palominolabs.crm.sf.core.SObject;
import com.palominolabs.crm.sf.rest.BasicSObjectMetadata;
import com.palominolabs.crm.sf.rest.BasicSObjectMetadataResult;
import com.palominolabs.crm.sf.rest.DescribeGlobalResult;
import com.palominolabs.crm.sf.rest.HttpApiClient;
import com.palominolabs.crm.sf.rest.HttpApiClientProvider;
import com.palominolabs.crm.sf.rest.ResponseParseException;
import com.palominolabs.crm.sf.rest.RestConnection;
import com.palominolabs.crm.sf.rest.RestQueryLocator;
import com.palominolabs.crm.sf.rest.RestQueryResult;
import com.palominolabs.crm.sf.rest.RestQueryResultImpl;
import com.palominolabs.crm.sf.rest.RestSObject;
import com.palominolabs.crm.sf.rest.RestSObjectImpl;
import com.palominolabs.crm.sf.rest.SObjectDescription;
import com.palominolabs.crm.sf.rest.SaveResult;
import com.palominolabs.crm.sf.rest.SaveResultImpl;
import com.palominolabs.crm.sf.rest.UpsertResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class RestConnectionImpl
implements RestConnection {
    private static final String ID_KEY = "Id";
    private static final String ATTRIBUTES_KEY = "attributes";
    private final ObjectReader objectReader;
    private final HttpApiClientProvider httpApiClientProvider;
    private final Timer createTimer;
    private final Timer deleteTimer;
    private final Timer describeGlobalTimer;
    private final Timer describeSObjectTimer;
    private final Timer queryTimer;
    private final Timer queryMoreTimer;
    private final Timer retrieveTimer;
    private final Timer searchTimer;
    private final Timer updateTimer;
    private final Timer basicSObjectInfoTimer;
    private final Timer upsertTimer;

    RestConnectionImpl(ObjectReader objectReader, HttpApiClientProvider httpApiClientProvider, MetricRegistry metricRegistry) {
        this.objectReader = objectReader;
        this.httpApiClientProvider = httpApiClientProvider;
        this.createTimer = metricRegistry.timer(MetricRegistry.name(RestConnectionImpl.class, (String[])new String[]{"create.request"}));
        this.deleteTimer = metricRegistry.timer(MetricRegistry.name(RestConnectionImpl.class, (String[])new String[]{"delete.request"}));
        this.describeGlobalTimer = metricRegistry.timer(MetricRegistry.name(RestConnectionImpl.class, (String[])new String[]{"describeGlobal.request"}));
        this.describeSObjectTimer = metricRegistry.timer(MetricRegistry.name(RestConnectionImpl.class, (String[])new String[]{"describeSObject.request"}));
        this.basicSObjectInfoTimer = metricRegistry.timer(MetricRegistry.name(RestConnectionImpl.class, (String[])new String[]{"getBasicSObjectInfo.request"}));
        this.queryTimer = metricRegistry.timer(MetricRegistry.name(RestConnectionImpl.class, (String[])new String[]{"query.request"}));
        this.queryMoreTimer = metricRegistry.timer(MetricRegistry.name(RestConnectionImpl.class, (String[])new String[]{"queryMore.request"}));
        this.retrieveTimer = metricRegistry.timer(MetricRegistry.name(RestConnectionImpl.class, (String[])new String[]{"retrieve.request"}));
        this.searchTimer = metricRegistry.timer(MetricRegistry.name(RestConnectionImpl.class, (String[])new String[]{"search.request"}));
        this.updateTimer = metricRegistry.timer(MetricRegistry.name(RestConnectionImpl.class, (String[])new String[]{"update.request"}));
        this.upsertTimer = metricRegistry.timer(MetricRegistry.name(RestConnectionImpl.class, (String[])new String[]{"upsert.request"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public SaveResult create(SObject sObject) throws IOException {
        Timer.Context context = this.createTimer.time();
        try {
            SaveResult saveResult = this.getSaveResult(this.getHttpApiClient().create(sObject));
            return saveResult;
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String sObjectType, Id id) throws IOException {
        Timer.Context context = this.deleteTimer.time();
        try {
            this.getHttpApiClient().delete(sObjectType, id);
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public DescribeGlobalResult describeGlobal() throws IOException {
        String describeGlobalJson;
        Timer.Context context = this.describeGlobalTimer.time();
        try {
            describeGlobalJson = this.getHttpApiClient().describeGlobal();
        }
        finally {
            context.stop();
        }
        ObjectNode objectNode = (ObjectNode)this.objectReader.withType(ObjectNode.class).readValue(describeGlobalJson);
        String encoding = objectNode.get("encoding").textValue();
        int maxBatchSize = objectNode.get("maxBatchSize").intValue();
        ArrayNode descriptionsNode = (ArrayNode)this.objectReader.withType(ArrayNode.class).readValue(objectNode.get("sobjects"));
        Iterator elements = descriptionsNode.elements();
        ArrayList descriptions = Lists.newArrayList();
        while (elements.hasNext()) {
            JsonNode node = (JsonNode)elements.next();
            descriptions.add(this.objectReader.readValue(node.traverse(), BasicSObjectMetadata.class));
        }
        return new DescribeGlobalResult(encoding, maxBatchSize, descriptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public SObjectDescription describeSObject(String sObjectType) throws IOException {
        String descrJson;
        Timer.Context context = this.describeSObjectTimer.time();
        try {
            descrJson = this.getHttpApiClient().describeSObject(sObjectType);
        }
        finally {
            context.stop();
        }
        return (SObjectDescription)this.objectReader.withType(SObjectDescription.class).readValue(descrJson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public BasicSObjectMetadataResult getBasicObjectInfo(String sObjectType) throws IOException {
        String jsonStr;
        Timer.Context context = this.basicSObjectInfoTimer.time();
        try {
            jsonStr = this.getHttpApiClient().basicSObjectInfo(sObjectType);
        }
        finally {
            context.stop();
        }
        ObjectNode objectNode = (ObjectNode)this.objectReader.withType(ObjectNode.class).readValue(jsonStr);
        BasicSObjectMetadata metadata = (BasicSObjectMetadata)this.objectReader.withType(BasicSObjectMetadata.class).readValue(objectNode.get("objectDescribe"));
        ArrayNode recentItems = (ArrayNode)this.objectReader.withType(ArrayNode.class).readValue(objectNode.get("recentItems"));
        List<SObject> sObjects = RestConnectionImpl.getSObjects(recentItems.elements());
        return new BasicSObjectMetadataResult(metadata, sObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public RestQueryResult query(String soql) throws IOException {
        String json;
        Timer.Context context = this.queryTimer.time();
        try {
            json = this.getHttpApiClient().query(soql);
        }
        finally {
            context.stop();
        }
        return RestConnectionImpl.getQueryResult((JsonNode)this.objectReader.readValue(this.parse(json), JsonNode.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public RestQueryResult queryMore(RestQueryLocator queryLocator) throws IOException {
        String json;
        Timer.Context context = this.queryMoreTimer.time();
        try {
            json = this.getHttpApiClient().queryMore(queryLocator);
        }
        finally {
            context.stop();
        }
        return RestConnectionImpl.getQueryResult((JsonNode)this.objectReader.readValue(this.parse(json), JsonNode.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public SObject retrieve(String sObjectType, Id id, List<String> fields) throws IOException {
        String json;
        Timer.Context context = this.retrieveTimer.time();
        try {
            json = this.getHttpApiClient().retrieve(sObjectType, id, fields);
        }
        finally {
            context.stop();
        }
        return RestConnectionImpl.getSObject((JsonNode)this.objectReader.readValue(this.parse(json), JsonNode.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<SObject> search(String sosl) throws IOException {
        String json;
        Timer.Context context = this.searchTimer.time();
        try {
            json = this.getHttpApiClient().search(sosl);
        }
        finally {
            context.stop();
        }
        return RestConnectionImpl.getSObjects(((ArrayNode)this.objectReader.readValue(this.parse(json), ArrayNode.class)).elements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(SObject sObject) throws IOException {
        Timer.Context context = this.updateTimer.time();
        try {
            this.getHttpApiClient().update(sObject);
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public UpsertResult upsert(SObject sObject, String externalIdField) throws IOException {
        int statusCode;
        Timer.Context context = this.upsertTimer.time();
        try {
            statusCode = this.getHttpApiClient().upsert(sObject, externalIdField);
        }
        finally {
            context.stop();
        }
        if (statusCode == 204) {
            return UpsertResult.UPDATED;
        }
        return UpsertResult.CREATED;
    }

    @Nonnull
    private JsonParser parse(@Nullable String str) throws IOException {
        return this.objectReader.getFactory().createParser(str);
    }

    @Nonnull
    private HttpApiClient getHttpApiClient() {
        return this.httpApiClientProvider.getClient();
    }

    @Nonnull
    private static List<SObject> getSObjects(Iterator<JsonNode> elements) throws IOException {
        ArrayList sObjects = Lists.newArrayList();
        while (elements.hasNext()) {
            JsonNode node = elements.next();
            sObjects.add(RestConnectionImpl.getSObject(node));
        }
        return sObjects;
    }

    @Nonnull
    private SaveResult getSaveResult(@Nullable String saveResultJson) throws IOException {
        ObjectNode objectNode = (ObjectNode)this.objectReader.withType(ObjectNode.class).readValue(this.parse(saveResultJson));
        String id = objectNode.get("id").textValue();
        boolean success = objectNode.get("success").booleanValue();
        List errors = (List)this.objectReader.withType(HttpApiClient.API_ERRORS_TYPE).readValue(objectNode.get("errors"));
        return new SaveResultImpl(new Id(id), success, errors);
    }

    @Nonnull
    private static RestSObject getSObject(JsonNode rawNode) throws IOException {
        RestSObjectImpl sObject;
        ObjectNode jsonNode = RestConnectionImpl.asObjectNode(rawNode);
        ObjectNode attributes = RestConnectionImpl.getObjectNode(jsonNode, ATTRIBUTES_KEY);
        String type = RestConnectionImpl.getString(attributes, "type");
        JsonNode idNode = jsonNode.get(ID_KEY);
        if (RestConnectionImpl.isNull(idNode)) {
            sObject = RestSObjectImpl.getNew(type);
        } else {
            if (!idNode.isTextual()) {
                throw new ResponseParseException("Id node <" + idNode + "> wasn't textual");
            }
            sObject = RestSObjectImpl.getNewWithId(type, new Id(idNode.textValue()));
        }
        jsonNode.remove(ID_KEY);
        jsonNode.remove(ATTRIBUTES_KEY);
        Iterator fieldNames = jsonNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode fieldValueNode = jsonNode.get(fieldName);
            if (fieldValueNode.isNull()) {
                sObject.setField(fieldName, null);
                continue;
            }
            if (fieldValueNode.isValueNode()) {
                sObject.setField(fieldName, fieldValueNode.asText());
                continue;
            }
            if (fieldValueNode.isObject()) {
                if (fieldValueNode.path(ATTRIBUTES_KEY).isObject()) {
                    sObject.setRelationshipSubObject(fieldName, RestConnectionImpl.getSObject(fieldValueNode));
                    continue;
                }
                if (fieldValueNode.path("records").isArray()) {
                    sObject.setRelationshipQueryResult(fieldName, RestConnectionImpl.getQueryResult(fieldValueNode));
                    continue;
                }
                throw new ResponseParseException("Could not understand field value node: " + fieldValueNode);
            }
            throw new ResponseParseException("Unknown node type <" + fieldValueNode + ">");
        }
        return sObject;
    }

    @Nonnull
    private static RestQueryResult getQueryResult(JsonNode rawNode) throws IOException {
        ObjectNode results = RestConnectionImpl.asObjectNode(rawNode);
        int totalSize = RestConnectionImpl.getInt(results, "totalSize");
        boolean done = RestConnectionImpl.getBoolean(results, "done");
        ArrayNode records = RestConnectionImpl.getArrayNode(results, "records");
        ArrayList sObjects = Lists.newArrayList();
        Iterator elements = records.elements();
        while (elements.hasNext()) {
            JsonNode recordNode = (JsonNode)elements.next();
            sObjects.add(RestConnectionImpl.getSObject(recordNode));
        }
        if (done) {
            return RestQueryResultImpl.getDone(sObjects, totalSize);
        }
        String nextRecordsUrl = RestConnectionImpl.getString(results, "nextRecordsUrl");
        return RestQueryResultImpl.getNotDone(sObjects, totalSize, new RestQueryLocator(nextRecordsUrl));
    }

    @Nonnull
    private static ObjectNode asObjectNode(JsonNode jsonNode) throws ResponseParseException {
        if (jsonNode == null) {
            throw new ResponseParseException("Got a null object node");
        }
        if (!jsonNode.isObject()) {
            throw new ResponseParseException("Got a node that wasn't an object <" + jsonNode + ">");
        }
        return (ObjectNode)jsonNode;
    }

    @Nonnull
    private static String getString(ObjectNode jsonNode, String key) throws ResponseParseException {
        JsonNode node = RestConnectionImpl.getNode(jsonNode, key);
        if (!node.isTextual()) {
            throw new ResponseParseException("Node <" + node + "> isn't text for key <" + key + ">");
        }
        return node.textValue();
    }

    private static int getInt(ObjectNode jsonNode, String key) throws ResponseParseException {
        JsonNode node = RestConnectionImpl.getNode(jsonNode, key);
        if (!node.isInt()) {
            throw new ResponseParseException("Node <" + node + "> isn't int for key <" + key + ">");
        }
        return node.intValue();
    }

    private static boolean getBoolean(ObjectNode jsonNode, String key) throws ResponseParseException {
        JsonNode node = RestConnectionImpl.getNode(jsonNode, key);
        if (!node.isBoolean()) {
            throw new ResponseParseException("Node <" + node + "> isn't boolean for key <" + key + ">");
        }
        return node.booleanValue();
    }

    @Nonnull
    private static ArrayNode getArrayNode(ObjectNode jsonNode, String key) throws ResponseParseException {
        JsonNode node = RestConnectionImpl.getNode(jsonNode, key);
        if (!node.isArray()) {
            throw new ResponseParseException("Node <" + node + "> isn't an array for key <" + key + ">");
        }
        return (ArrayNode)node;
    }

    @Nonnull
    private static ObjectNode getObjectNode(ObjectNode jsonNode, String key) throws ResponseParseException {
        JsonNode node = RestConnectionImpl.getNode(jsonNode, key);
        if (!node.isObject()) {
            throw new ResponseParseException("Node <" + node + "> isn't an object for key <" + key + ">");
        }
        return (ObjectNode)node;
    }

    @Nonnull
    private static JsonNode getNode(ObjectNode jsonNode, String key) throws ResponseParseException {
        JsonNode value = jsonNode.get(key);
        if (RestConnectionImpl.isNull(value)) {
            throw new ResponseParseException("Null value for key <" + key + ">");
        }
        return value;
    }

    private static boolean isNull(JsonNode node) {
        return node == null || node == NullNode.instance;
    }
}

