/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.palominolabs.crm.sf.core.ImmutableBitSet;
import com.palominolabs.crm.sf.core.ImmutableBitSets;
import java.util.BitSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.codec.binary.Base64;

@Immutable
public final class PicklistEntry {
    private final String value;
    private final boolean active;
    private final String label;
    private final boolean defaultValue;
    private final ImmutableBitSet validFor;

    @JsonCreator
    PicklistEntry(@JsonProperty(value="value") String value, @JsonProperty(value="active") boolean active, @JsonProperty(value="label") String label, @JsonProperty(value="defaultValue") boolean defaultValue, @Nullable @JsonProperty(value="validFor") String validFor) {
        this.value = value;
        this.active = active;
        this.label = label;
        this.defaultValue = defaultValue;
        if (validFor == null) {
            this.validFor = new ImmutableBitSet(new BitSet());
        } else {
            Base64 base64 = new Base64();
            byte[] decoded = base64.decode(validFor);
            this.validFor = ImmutableBitSets.parseValidForBytes((byte[])decoded);
        }
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    public boolean isActive() {
        return this.active;
    }

    @CheckForNull
    public String getLabel() {
        return this.label;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    @Nonnull
    public ImmutableBitSet getValidFor() {
        return this.validFor;
    }
}

