/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.rest;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.palominolabs.crm.sf.core.Id;
import com.palominolabs.crm.sf.core.SObject;
import com.palominolabs.crm.sf.rest.ApiErrorImpl;
import com.palominolabs.crm.sf.rest.ApiException;
import com.palominolabs.crm.sf.rest.HttpPatch;
import com.palominolabs.crm.sf.rest.RestQueryLocator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
final class HttpApiClient {
    static final String API_VERSION = "28.0";
    static final TypeReference<List<ApiErrorImpl>> API_ERRORS_TYPE = new TypeReference<List<ApiErrorImpl>>(){};
    private static final String UPLOAD_CONTENT_TYPE = "application/json";
    private static final Logger logger = LoggerFactory.getLogger(HttpApiClient.class);
    @Nonnull
    private final String host;
    @Nonnull
    private final String oauthToken;
    @Nonnull
    private final ObjectMapper objectMapper;
    @Nonnull
    private final HttpClient client;

    HttpApiClient(@Nonnull String host, @Nonnull String oauthToken, @Nonnull ObjectMapper objectMapper, @Nonnull HttpClient client) {
        this.host = host;
        this.oauthToken = oauthToken;
        this.objectMapper = objectMapper;
        this.client = client;
    }

    @CheckForNull
    String describeGlobal() throws IOException {
        return this.executeGet("/sobjects/");
    }

    @CheckForNull
    String describeSObject(String sObjectType) throws IOException {
        return this.executeGet("/sobjects/" + sObjectType + "/describe");
    }

    @CheckForNull
    String basicSObjectInfo(String sObjectType) throws IOException {
        return this.executeGet("/sobjects/" + sObjectType);
    }

    @CheckForNull
    String create(SObject sObject) throws IOException {
        HttpPost post = new HttpPost(this.getUri("/sobjects/" + sObject.getType() + "/"));
        post.setEntity(this.getEntityForSObjectFieldsJson(sObject));
        post.addHeader("Content-Type", UPLOAD_CONTENT_TYPE);
        return this.executeRequestForString((HttpUriRequest)post);
    }

    void delete(String sObjectType, Id id) throws IOException {
        this.executeRequestForString((HttpUriRequest)new HttpDelete(this.getUri("/sobjects/" + sObjectType + "/" + id)));
    }

    @CheckForNull
    String query(String soql) throws IOException {
        return this.executeGet("/query", (NameValuePair)new BasicNameValuePair("q", soql));
    }

    @CheckForNull
    String queryMore(RestQueryLocator queryLocator) throws IOException {
        return this.executeGetForUri(this.getUriForPath(queryLocator.getContents()));
    }

    @CheckForNull
    String search(String sosl) throws IOException {
        return this.executeGet("/search", (NameValuePair)new BasicNameValuePair("q", sosl));
    }

    @CheckForNull
    String retrieve(String sObjectType, Id id, List<String> fields) throws IOException {
        return this.executeGet("/sobjects/" + sObjectType + "/" + id, (NameValuePair)new BasicNameValuePair("fields", StringUtils.join(fields, (String)",")));
    }

    void update(SObject sObject) throws IOException {
        HttpPatch patch = new HttpPatch(this.getUri("/sobjects/" + sObject.getType() + "/" + sObject.getId()));
        patch.setEntity(this.getEntityForSObjectFieldsJson(sObject));
        patch.addHeader("Content-Type", UPLOAD_CONTENT_TYPE);
        this.executeRequestForString((HttpUriRequest)patch);
    }

    int upsert(SObject sObject, String externalIdField) throws IOException {
        HttpPatch patch = new HttpPatch(this.getUri("/sobjects/" + sObject.getType() + "/" + externalIdField + "/" + sObject.getField(externalIdField)));
        patch.setEntity(this.getEntityForSObjectFieldsJson(sObject));
        patch.addHeader("Content-Type", UPLOAD_CONTENT_TYPE);
        ProcessedResponse processedResponse = this.executeRequest((HttpUriRequest)patch);
        return processedResponse.getHttpResponse().getStatusLine().getStatusCode();
    }

    @Nonnull
    private HttpEntity getEntityForSObjectFieldsJson(SObject sObject) throws IOException {
        return new StringEntity(this.getSObjectFieldsAsJson(sObject), "UTF-8");
    }

    @Nonnull
    private String getSObjectFieldsAsJson(@Nonnull SObject sObject) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = this.objectMapper.getFactory().createGenerator((Writer)writer);
        jsonGenerator.writeStartObject();
        for (Map.Entry entry : sObject.getAllFields().entrySet()) {
            if (entry.getValue() == null) {
                jsonGenerator.writeNullField((String)entry.getKey());
                continue;
            }
            jsonGenerator.writeStringField((String)entry.getKey(), (String)entry.getValue());
        }
        jsonGenerator.writeEndObject();
        jsonGenerator.close();
        writer.close();
        return writer.toString();
    }

    @CheckForNull
    private String executeGet(String pathFragment) throws IOException {
        return this.executeGetForUri(this.getUri(pathFragment));
    }

    @CheckForNull
    private String executeGet(String pathFragment, NameValuePair param) throws IOException {
        return this.executeGet(pathFragment, Arrays.asList(param));
    }

    @CheckForNull
    private String executeGet(String pathFragment, List<NameValuePair> params) throws IOException {
        return this.executeGetForUri(this.getUri(pathFragment, params));
    }

    @CheckForNull
    private String executeGetForUri(URI uri) throws IOException {
        return this.executeRequestForString((HttpUriRequest)new HttpGet(uri));
    }

    @Nonnull
    private URI getUri(String pathFragment) throws IOException {
        return this.getUriForPath("/services/data/v28.0" + pathFragment);
    }

    @Nonnull
    private URI getUri(String pathFragment, List<NameValuePair> params) throws IOException {
        return this.getUriForPath("/services/data/v28.0" + pathFragment, params);
    }

    @Nonnull
    private URI getUriForPath(String path) throws IOException {
        try {
            return this.getUriBuilderForPath(path).build();
        }
        catch (URISyntaxException e) {
            throw new IOException("Couldn't create URI", e);
        }
    }

    @Nonnull
    private URI getUriForPath(String path, List<NameValuePair> params) throws IOException {
        URIBuilder b = this.getUriBuilderForPath(path);
        for (NameValuePair param : params) {
            b.addParameter(param.getName(), param.getValue());
        }
        try {
            return b.build();
        }
        catch (URISyntaxException e) {
            throw new IOException("Couldn't create URI", e);
        }
    }

    @Nonnull
    private URIBuilder getUriBuilderForPath(String path) {
        return new URIBuilder().setScheme("https").setHost(this.host).setPort(443).setPath(path);
    }

    @CheckForNull
    private String executeRequestForString(@Nonnull HttpUriRequest request) throws IOException {
        return this.executeRequest(request).getResponseBody();
    }

    @Nonnull
    private ProcessedResponse executeRequest(HttpUriRequest request) throws IOException {
        request.addHeader("Authorization", "OAuth " + this.oauthToken);
        HttpResponse response = this.client.execute(request);
        return new ProcessedResponse(response, this.checkResponse(request, response));
    }

    @CheckForNull
    private String checkResponse(HttpUriRequest request, HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        String responseBody = entity == null ? null : EntityUtils.toString((HttpEntity)entity);
        this.throwApiExceptionIfInvalid(request.getURI().toString(), response, responseBody);
        return responseBody;
    }

    private void throwApiExceptionIfInvalid(@Nonnull String url, @Nonnull HttpResponse response, @Nullable String responseBody) throws IOException {
        List errors;
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return;
        }
        if (responseBody == null) {
            errors = Collections.emptyList();
        } else {
            try {
                errors = (List)this.objectMapper.readValue(responseBody, API_ERRORS_TYPE);
            }
            catch (JsonParseException e) {
                logger.warn("Couldn't parse response <" + responseBody + ">", (Throwable)e);
                errors = Collections.emptyList();
            }
            catch (JsonMappingException e) {
                logger.warn("Couldn't parse response <" + responseBody + ">", (Throwable)e);
                errors = Collections.emptyList();
            }
        }
        switch (statusCode) {
            case 300: {
                throw new ApiException(url, statusCode, statusLine.getReasonPhrase(), errors, responseBody, "External ID already used");
            }
            case 400: {
                throw new ApiException(url, statusCode, statusLine.getReasonPhrase(), errors, responseBody, "Request could not be understood");
            }
            case 401: {
                throw new ApiException(url, statusCode, statusLine.getReasonPhrase(), errors, responseBody, "Invalid session ID or Oauth token");
            }
            case 403: {
                throw new ApiException(url, statusCode, statusLine.getReasonPhrase(), errors, responseBody, "Request refused; check permissions");
            }
            case 404: {
                throw new ApiException(url, statusCode, statusLine.getReasonPhrase(), errors, responseBody, "Resource could not be found");
            }
            case 405: {
                throw new ApiException(url, statusCode, statusLine.getReasonPhrase(), errors, responseBody, "Method not allowed for specified resource");
            }
            case 415: {
                throw new ApiException(url, statusCode, statusLine.getReasonPhrase(), errors, responseBody, "Request is not in a supported format for the resource and method");
            }
            case 500: {
                throw new ApiException(url, statusCode, statusLine.getReasonPhrase(), errors, responseBody, "Force.com error");
            }
        }
        throw new ApiException(url, statusCode, statusLine.getReasonPhrase(), errors, responseBody, "Unclassified error");
    }

    @NotThreadSafe
    private static class ProcessedResponse {
        @Nonnull
        private final HttpResponse httpResponse;
        @CheckForNull
        private final String responseBody;

        private ProcessedResponse(@Nonnull HttpResponse httpResponse, @Nullable String responseBody) {
            this.httpResponse = httpResponse;
            this.responseBody = responseBody;
        }

        @Nonnull
        public HttpResponse getHttpResponse() {
            return this.httpResponse;
        }

        @CheckForNull
        public String getResponseBody() {
            return this.responseBody;
        }
    }
}

