/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.rest;

import com.google.common.collect.ImmutableList;
import com.palominolabs.crm.sf.rest.ApiError;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ApiException
extends IOException {
    @Nonnull
    private final String url;
    private final int httpResponseCode;
    @Nullable
    private final String httpResponseBody;
    @Nonnull
    private final List<ApiError> errors;
    @Nonnull
    private final String httpReason;

    ApiException(@Nonnull String url, int httpResponseCode, @Nonnull String httpReason, @Nonnull List<ApiError> errors, @Nullable String httpResponseBody, @Nonnull String message) {
        super(message);
        this.url = url;
        this.httpResponseCode = httpResponseCode;
        this.httpResponseBody = httpResponseBody;
        this.httpReason = httpReason;
        this.errors = ImmutableList.copyOf(errors);
    }

    @Override
    public String getMessage() {
        return super.getMessage() + " [url=<" + this.url + ">, httpResponseCode=<" + this.httpResponseCode + ">, httpReason=<" + this.httpReason + ">, errors=<" + this.errors + ">, httpResponseBody=<" + this.httpResponseBody + ">]";
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    @CheckForNull
    public String getHttpResponseBody() {
        return this.httpResponseBody;
    }

    @Nonnull
    public String getHttpReason() {
        return this.httpReason;
    }

    @Nonnull
    public List<ApiError> getErrors() {
        return this.errors;
    }
}

