/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.palominolabs.crm.sf.rest.ApiError;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

final class ApiErrorImpl
implements ApiError {
    @Nonnull
    private final List<String> fields;
    @Nonnull
    private final String message;
    @Nonnull
    private final String errorCode;

    private ApiErrorImpl(@Nonnull List<String> fields, @Nonnull String message, @Nonnull String errorCode) {
        this.fields = ImmutableList.copyOf(fields);
        this.message = message;
        this.errorCode = errorCode;
    }

    @Nonnull
    static ApiError getNew(@Nonnull List<String> fields, @Nonnull String message, @Nonnull String errorCode) {
        return new ApiErrorImpl(fields, message, errorCode);
    }

    @JsonCreator
    static ApiErrorImpl getNewFromJackson(@CheckForNull @JsonProperty(value="fields") List<String> fields, @Nonnull @JsonProperty(value="message") String message, @Nonnull @JsonProperty(value="errorCode") String errorCode) {
        if (fields == null) {
            return new ApiErrorImpl(Collections.<String>emptyList(), message, errorCode);
        }
        return new ApiErrorImpl(fields, message, errorCode);
    }

    @Override
    @Nonnull
    public List<String> getFields() {
        return this.fields;
    }

    @Override
    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Override
    @Nonnull
    public String getErrorCode() {
        return this.errorCode;
    }

    public String toString() {
        return "ApiErrorImpl{fields=" + this.fields + ", message='" + this.message + '\'' + ", errorCode='" + this.errorCode + '\'' + '}';
    }
}

