/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Metered;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class MeteredInterceptor
implements MethodInterceptor {
    private final Meter meter;

    static MethodInterceptor forMethod(MetricRegistry metricRegistry, Class<?> klass, Method method) {
        Metered annotation = method.getAnnotation(Metered.class);
        if (annotation != null) {
            Meter meter = metricRegistry.meter(MeteredInterceptor.determineName(annotation, klass, method));
            return new MeteredInterceptor(meter);
        }
        return null;
    }

    private static String determineName(Metered annotation, Class<?> klass, Method method) {
        if (annotation.absolute()) {
            return annotation.name();
        }
        if (annotation.name().isEmpty()) {
            return MetricRegistry.name(klass, (String[])new String[]{method.getName()});
        }
        return MetricRegistry.name(klass, (String[])new String[]{annotation.name()});
    }

    private MeteredInterceptor(Meter meter) {
        this.meter = meter;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.meter.mark();
        return invocation.proceed();
    }
}

