/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matchers;
import com.palominolabs.metrics.guice.ExceptionMeteredListener;
import com.palominolabs.metrics.guice.GaugeListener;
import com.palominolabs.metrics.guice.JmxReporterProvider;
import com.palominolabs.metrics.guice.MeteredListener;
import com.palominolabs.metrics.guice.TimedListener;

public class InstrumentationModule
extends AbstractModule {
    protected void configure() {
        MetricRegistry metricRegistry = this.createMetricRegistry();
        this.bind(MetricRegistry.class).toInstance((Object)metricRegistry);
        this.bind(HealthCheckRegistry.class).toInstance((Object)this.createHealthCheckRegistry());
        this.bindJmxReporter();
        this.bindListener(Matchers.any(), new MeteredListener(metricRegistry));
        this.bindListener(Matchers.any(), new TimedListener(metricRegistry));
        this.bindListener(Matchers.any(), new GaugeListener(metricRegistry));
        this.bindListener(Matchers.any(), new ExceptionMeteredListener(metricRegistry));
    }

    protected void bindJmxReporter() {
        this.bind(JmxReporter.class).toProvider(JmxReporterProvider.class).in(Scopes.SINGLETON);
    }

    protected HealthCheckRegistry createHealthCheckRegistry() {
        return new HealthCheckRegistry();
    }

    protected MetricRegistry createMetricRegistry() {
        return new MetricRegistry();
    }
}

