/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.HistogramMetricBuilder;
import com.palantir.tritium.metrics.MetricRegistries;
import com.palantir.tritium.metrics.TimerMetricBuilder;
import java.util.function.Supplier;

final class MetricRegistryWithReservoirs
extends MetricRegistry {
    private final HistogramMetricBuilder histogramMetricBuilder;
    private final TimerMetricBuilder timerMetricBuilder;

    MetricRegistryWithReservoirs(Supplier<Reservoir> reservoirSupplier) {
        Preconditions.checkNotNull(reservoirSupplier, (String)"reservoirSupplier");
        this.histogramMetricBuilder = new HistogramMetricBuilder(reservoirSupplier);
        this.timerMetricBuilder = new TimerMetricBuilder(reservoirSupplier);
    }

    public Histogram histogram(String name) {
        return MetricRegistries.getOrAdd(this, name, this.histogramMetricBuilder);
    }

    public Timer timer(String name) {
        return MetricRegistries.getOrAdd(this, name, this.timerMetricBuilder);
    }
}

