/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.RatioGauge;
import com.google.common.base.CharMatcher;
import com.palantir.tritium.metrics.JvmMemoryPoolsMetrics;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;

final class MemoryPoolMetrics {
    static void register(TaggedMetricRegistry registry) {
        JvmMemoryPoolsMetrics metrics = JvmMemoryPoolsMetrics.of(registry);
        for (final MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            String poolName = MemoryPoolMetrics.canonicalName(memoryPool.getName());
            metrics.max().memoryPool(poolName).build((Gauge<? extends Number>)((Gauge)() -> memoryPool.getUsage().getMax()));
            metrics.used().memoryPool(poolName).build((Gauge<? extends Number>)((Gauge)() -> memoryPool.getUsage().getUsed()));
            metrics.committed().memoryPool(poolName).build((Gauge<? extends Number>)((Gauge)() -> memoryPool.getUsage().getCommitted()));
            metrics.init().memoryPool(poolName).build((Gauge<? extends Number>)((Gauge)() -> memoryPool.getUsage().getInit()));
            metrics.usage().memoryPool(poolName).build((Gauge<? extends Number>)new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    MemoryUsage memoryUsage = memoryPool.getUsage();
                    double maximum = memoryUsage.getMax() == -1L ? (double)memoryUsage.getCommitted() : (double)memoryUsage.getMax();
                    return RatioGauge.Ratio.of((double)memoryUsage.getUsed(), (double)maximum);
                }
            });
            if (memoryPool.getCollectionUsage() == null) continue;
            metrics.usedAfterGc().memoryPool(poolName).build((Gauge<? extends Number>)((Gauge)() -> memoryPool.getCollectionUsage().getUsed()));
        }
    }

    private static String canonicalName(String collectorName) {
        return CharMatcher.whitespace().replaceFrom((CharSequence)collectorName, (CharSequence)"-");
    }

    private MemoryPoolMetrics() {
    }
}

