/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.RatioGauge;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.palantir.tritium.metrics.registry.MetricName;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

@Beta
public final class InternalCacheMetrics {
    private InternalCacheMetrics() {
    }

    public static <K> ImmutableMap<K, Gauge<?>> createMetrics(Stats stats, Function<String, K> metricNamer) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)12);
        stats.forEach((name, gauge) -> builder.put(metricNamer.apply((String)name), gauge));
        return builder.buildOrThrow();
    }

    public static Function<String, MetricName> taggedMetricName(String cacheName) {
        return name -> MetricName.builder().safeName(name).putSafeTags("cache", cacheName).build();
    }

    public static interface Stats {
        default public void forEach(BiConsumer<String, Gauge<?>> consumer) {
            consumer.accept("cache.estimated.size", this.estimatedSize());
            consumer.accept("cache.request.count", this.requestCount());
            consumer.accept("cache.hit.count", this.hitCount());
            consumer.accept("cache.hit.ratio", this.hitRatio());
            consumer.accept("cache.miss.count", this.missCount());
            consumer.accept("cache.miss.ratio", this.missRatio());
            consumer.accept("cache.eviction.count", this.evictionCount());
            consumer.accept("cache.load.success.count", this.loadSuccessCount());
            consumer.accept("cache.load.failure.count", this.loadFailureCount());
            consumer.accept("cache.load.average.millis", this.loadAverageMillis());
            this.maximumSize().ifPresent(maximumSizeGauge -> consumer.accept("cache.maximum.size", (Gauge<?>)maximumSizeGauge));
            this.weightedSize().ifPresent(weightedSizeGauge -> consumer.accept("cache.weighted.size", (Gauge<?>)weightedSizeGauge));
        }

        public Gauge<Long> estimatedSize();

        public Optional<Gauge<Long>> weightedSize();

        public Optional<Gauge<Long>> maximumSize();

        public Gauge<Long> requestCount();

        public Gauge<Long> hitCount();

        public Gauge<Long> missCount();

        public Gauge<Long> evictionCount();

        public Gauge<Long> loadSuccessCount();

        public Gauge<Long> loadFailureCount();

        public Gauge<Double> loadAverageMillis();

        default public Gauge<Double> hitRatio() {
            return new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of((double)((Long)this.hitCount().getValue()).doubleValue(), (double)((Long)this.requestCount().getValue()).doubleValue());
                }
            };
        }

        default public Gauge<Double> missRatio() {
            return new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of((double)((Long)this.missCount().getValue()).doubleValue(), (double)((Long)this.requestCount().getValue()).doubleValue());
                }
            };
        }
    }
}

