/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Gauge;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.CacheMetricSet;
import com.palantir.tritium.metrics.InternalCacheMetrics;
import com.palantir.tritium.metrics.registry.MetricName;
import java.util.concurrent.TimeUnit;

final class CacheTaggedMetrics {
    private final Cache<?, ?> cache;
    private final String cacheName;

    private CacheTaggedMetrics(Cache<?, ?> cache, @Safe String cacheName) {
        String name = ((String)Preconditions.checkNotNull((Object)cacheName, (String)"cacheName")).trim();
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"Cache name cannot be blank or empty");
        this.cache = (Cache)Preconditions.checkNotNull(cache, (String)"cache");
        this.cacheName = name;
    }

    static CacheTaggedMetrics create(Cache<?, ?> cache, @Safe String cacheName) {
        return new CacheTaggedMetrics(cache, cacheName);
    }

    ImmutableMap<MetricName, Gauge<?>> getMetrics() {
        return InternalCacheMetrics.createMetrics(CacheMetricSet.GuavaStats.create(this.cache, 1L, TimeUnit.SECONDS), InternalCacheMetrics.taggedMetricName(this.cacheName));
    }
}

