/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.ids;

import com.google.common.annotations.VisibleForTesting;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public final class UniqueIds {
    private static final SafeLogger log = SafeLoggerFactory.get(UniqueIds.class);
    private static final int CHUNK_SIZE = 16;
    private static final ThreadLocal<Random> SECURE_RANDOM = ThreadLocal.withInitial(UniqueIds::createSecureRandom);

    private UniqueIds() {
    }

    static SecureRandom createSecureRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            log.warn("Falling back to default SecureRandom", (Throwable)e);
            return new SecureRandom();
        }
    }

    public static UUID pseudoRandomUuidV4() {
        return UniqueIds.randomUuidV4(ThreadLocalRandom.current());
    }

    public static UUID randomUuidV4() {
        return UniqueIds.randomUuidV4(SECURE_RANDOM.get());
    }

    @VisibleForTesting
    static UUID randomUuidV4(Random rand) {
        byte[] data = UniqueIds.bytes(rand);
        Preconditions.checkArgument((data.length == 16 ? 1 : 0) != 0, (String)"Invalid data length, expected 16 bytes");
        data[6] = (byte)(data[6] & 0xF | 0x40);
        data[8] = (byte)(data[8] & 0x3F | 0x80);
        long mostSigBits = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSigBits = mostSigBits << 8 | (long)(data[i] & 0xFF);
        }
        long leastSigBits = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSigBits = leastSigBits << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(mostSigBits, leastSigBits);
    }

    private static byte[] bytes(Random rand) {
        byte[] data = new byte[16];
        rand.nextBytes(data);
        return data;
    }
}

