/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.caffeine;

import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.caffeine.CacheMetrics;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Supplier;

public final class CacheStats
implements StatsCounter,
Supplier<StatsCounter> {
    private final CacheMetrics metrics;
    private final String name;
    private final Meter hitMeter;
    private final Meter missMeter;
    private final Timer loadSuccessTimer;
    private final Timer loadFailureTimer;
    private final ImmutableMap<RemovalCause, Meter> evictionMeters;
    private final ImmutableMap<RemovalCause, Meter> evictionWeightMeters;
    private final LongAdder totalLoadTime = new LongAdder();

    public static CacheStats of(TaggedMetricRegistry taggedMetricRegistry, @Safe String name) {
        return new CacheStats(CacheMetrics.of(taggedMetricRegistry), name);
    }

    public <K, V> void register(Cache<K, V> cache) {
        Preconditions.checkState((boolean)cache.policy().isRecordingStats(), (String)"Registered cache is not recording stats. Registered caches must enabled stats recording with .recordStats(stats).");
        this.metrics.estimatedSize().cache(this.name).build((Gauge<? extends Number>)((Gauge)() -> cache.estimatedSize()));
        this.metrics.weightedSize().cache(this.name).build((Gauge<? extends Number>)((Gauge)() -> cache.policy().eviction().flatMap(e -> e.weightedSize().stream().boxed().findFirst()).orElse(null)));
        this.metrics.maximumSize().cache(this.name).build((Gauge<? extends Number>)((Gauge)() -> cache.policy().eviction().map(Policy.Eviction::getMaximum).orElse(null)));
    }

    public <K, V, C extends Cache<K, V>> C register(Function<CacheStats, C> cacheFactory) {
        Cache cache = (Cache)cacheFactory.apply(this);
        this.register(cache);
        return (C)cache;
    }

    public <K, V, C extends AsyncCache<K, V>> C registerAsync(Function<CacheStats, C> cacheFactory) {
        AsyncCache cache = (AsyncCache)cacheFactory.apply(this);
        this.register(cache.synchronous());
        return (C)cache;
    }

    private CacheStats(CacheMetrics metrics, @Safe String name) {
        this.metrics = metrics;
        this.name = name;
        this.hitMeter = metrics.request().cache(name).result(CacheMetrics.Request_Result.HIT).build();
        this.missMeter = metrics.request().cache(name).result(CacheMetrics.Request_Result.MISS).build();
        this.loadSuccessTimer = metrics.load().cache(name).result(CacheMetrics.Load_Result.SUCCESS).build();
        this.loadFailureTimer = metrics.load().cache(name).result(CacheMetrics.Load_Result.FAILURE).build();
        this.evictionMeters = (ImmutableMap)Arrays.stream(RemovalCause.values()).collect(Maps.toImmutableEnumMap(cause -> cause, cause -> metrics.eviction().cache(name).cause(cause.toString()).build()));
        this.evictionWeightMeters = (ImmutableMap)Arrays.stream(RemovalCause.values()).collect(Maps.toImmutableEnumMap(cause -> cause, cause -> metrics.evictionWeight().cache(name).cause(cause.toString()).build()));
    }

    @Override
    public StatsCounter get() {
        return this;
    }

    public void recordHits(int count) {
        this.hitMeter.mark((long)count);
    }

    public void recordMisses(int count) {
        this.missMeter.mark((long)count);
    }

    public void recordLoadSuccess(long loadTime) {
        this.loadSuccessTimer.update(loadTime, TimeUnit.NANOSECONDS);
        this.totalLoadTime.add(loadTime);
    }

    public void recordLoadFailure(long loadTime) {
        this.loadFailureTimer.update(loadTime, TimeUnit.NANOSECONDS);
        this.totalLoadTime.add(loadTime);
    }

    public void recordEviction(int weight, RemovalCause cause) {
        Meter evictionWeightMeter;
        Meter evictionMeter = (Meter)this.evictionMeters.get((Object)cause);
        if (evictionMeter != null) {
            evictionMeter.mark();
        }
        if ((evictionWeightMeter = (Meter)this.evictionWeightMeters.get((Object)cause)) != null) {
            evictionWeightMeter.mark((long)weight);
        }
    }

    public com.github.benmanes.caffeine.cache.stats.CacheStats snapshot() {
        return com.github.benmanes.caffeine.cache.stats.CacheStats.of((long)this.hitMeter.getCount(), (long)this.missMeter.getCount(), (long)this.loadSuccessTimer.getCount(), (long)this.loadFailureTimer.getCount(), (long)this.totalLoadTime.sum(), (long)this.evictionMeters.values().stream().mapToLong(Counting::getCount).sum(), (long)this.evictionWeightMeters.values().stream().mapToLong(Counting::getCount).sum());
    }

    public String toString() {
        return this.name + ": " + String.valueOf(this.snapshot());
    }
}

