/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.ri;

import com.palantir.ri.CharPredicate;

final class FastAsciiPredicate
implements CharPredicate {
    private static final int TABLE_SIZE = 256;
    private final boolean[] truthTable;

    private FastAsciiPredicate(boolean[] truthTable) {
        this.truthTable = truthTable;
    }

    static CharPredicate compile(CharPredicate predicate) {
        boolean[] mask = new boolean[256];
        for (char ch = '\u0000'; ch < '\u0100'; ch = (char)(ch + '\u0001')) {
            mask[ch] = predicate.test(ch);
        }
        return new FastAsciiPredicate(mask);
    }

    @Override
    public boolean test(char ch) {
        return ch < '\u0100' && this.truthTable[ch];
    }
}

