/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.annotations;

import com.palantir.dialogue.annotations.ContentBody;
import com.palantir.logsafe.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.OptionalLong;

final class PathContentBody
implements ContentBody {
    private final String contentType;
    private final Path filePath;

    PathContentBody(String contentType, Path filePath) {
        this.contentType = (String)Preconditions.checkNotNull((Object)contentType, (String)"contentType");
        this.filePath = (Path)Preconditions.checkNotNull((Object)filePath, (String)"filePath");
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        Files.copy(this.filePath, output);
    }

    @Override
    public boolean repeatable() {
        return true;
    }

    @Override
    public OptionalLong contentLength() {
        return OptionalLong.of(this.filePath.toFile().length());
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public void close() {
    }
}

