/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.serialization;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileFactoryBuilder;
import com.fasterxml.jackson.dataformat.smile.SmileParser;
import com.fasterxml.jackson.dataformat.smile.SmileParserBootstrapper;
import com.palantir.conjure.java.serialization.ParserInstrumentation;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

final class InstrumentedSmileFactory
extends SmileFactory {
    private final ParserInstrumentation instrumentation;

    InstrumentedSmileFactory() {
        this.instrumentation = new ParserInstrumentation(this.getFormatName());
    }

    private InstrumentedSmileFactory(SmileFactoryBuilder builder) {
        this(builder, new ParserInstrumentation("Smile"));
    }

    private InstrumentedSmileFactory(SmileFactoryBuilder builder, ParserInstrumentation instrumentation) {
        super(builder);
        this.instrumentation = instrumentation;
    }

    private InstrumentedSmileFactory(SmileFactory src, @Nullable ObjectCodec codec, ParserInstrumentation instrumentation) {
        super(src, codec);
        this.instrumentation = instrumentation;
    }

    public static SmileFactoryBuilder builder() {
        return new SmileFactoryBuilder(){

            public SmileFactory build() {
                return new InstrumentedSmileFactory(this);
            }
        };
    }

    public SmileFactoryBuilder rebuild() {
        return new SmileFactoryBuilder(this){

            public SmileFactory build() {
                return new InstrumentedSmileFactory(this, InstrumentedSmileFactory.this.instrumentation);
            }
        };
    }

    public SmileFactory copy() {
        return new InstrumentedSmileFactory(this, null, this.instrumentation);
    }

    protected SmileParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        InstrumentedSmileParserBootstrapper bootstrapper = new InstrumentedSmileParserBootstrapper(ctxt, in, this.instrumentation);
        return bootstrapper.constructParser(this._factoryFeatures, this._parserFeatures, this._smileParserFeatures, this._objectCodec, this._byteSymbolCanonicalizer);
    }

    protected SmileParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        return new InstrumentedSmileParserBootstrapper(ctxt, data, offset, len, this.instrumentation).constructParser(this._factoryFeatures, this._parserFeatures, this._smileParserFeatures, this._objectCodec, this._byteSymbolCanonicalizer);
    }

    private static final class InstrumentedSmileParserBootstrapper
    extends SmileParserBootstrapper {
        private final ParserInstrumentation instrumentation;

        InstrumentedSmileParserBootstrapper(IOContext ctxt, InputStream in, ParserInstrumentation instrumentation) {
            super(ctxt, in);
            this.instrumentation = instrumentation;
        }

        InstrumentedSmileParserBootstrapper(IOContext ctxt, byte[] inputBuffer, int inputStart, int inputLen, ParserInstrumentation instrumentation) {
            super(ctxt, inputBuffer, inputStart, inputLen);
            this.instrumentation = instrumentation;
        }

        public InstrumentedSmileParser constructParser(int factoryFeatures, int generalParserFeatures, int smileFeatures, ObjectCodec codec, ByteQuadsCanonicalizer rootByteSymbols) throws IOException, JsonParseException {
            int count;
            ByteQuadsCanonicalizer can = rootByteSymbols.makeChildOrPlaceholder(factoryFeatures);
            int end = this._inputEnd;
            if (this._inputPtr < end && this._in != null && (count = this._in.read(this._inputBuffer, end, this._inputBuffer.length - end)) > 0) {
                this._inputEnd += count;
            }
            InstrumentedSmileParser smileParser = new InstrumentedSmileParser(this._context, generalParserFeatures, smileFeatures, codec, can, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._bufferRecyclable, this.instrumentation);
            boolean hadSig = false;
            if (this._inputPtr >= this._inputEnd) {
                return smileParser;
            }
            byte firstByte = this._inputBuffer[this._inputPtr];
            if (firstByte == 58) {
                hadSig = smileParser.handleSignature(true, true);
            }
            if (!hadSig && SmileParser.Feature.REQUIRE_HEADER.enabledIn(smileFeatures)) {
                String msg = firstByte == 123 || firstByte == 91 ? "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(firstByte & 0xFF) + ") -- rather, it starts with '" + (char)firstByte + "' (plain JSON input?) -- can not parse" : "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(firstByte & 0xFF) + ") and parser has REQUIRE_HEADER enabled: can not parse";
                throw new JsonParseException((JsonParser)smileParser, msg);
            }
            return smileParser;
        }
    }

    private static final class InstrumentedSmileParser
    extends SmileParser {
        private final ParserInstrumentation instrumentation;

        InstrumentedSmileParser(IOContext ctxt, int parserFeatures, int smileFeatures, ObjectCodec codec, ByteQuadsCanonicalizer sym, InputStream in, byte[] inputBuffer, int start, int end, boolean bufferRecyclable, ParserInstrumentation instrumentation) {
            super(ctxt, parserFeatures, smileFeatures, codec, sym, in, inputBuffer, start, end, bufferRecyclable);
            this.instrumentation = instrumentation;
        }

        public String nextTextValue() throws IOException {
            return this.instrumentation.recordStringLength(super.nextTextValue());
        }

        public String getText() throws IOException {
            return this.instrumentation.recordStringLength(super.getText());
        }

        public String getValueAsString() throws IOException {
            return this.instrumentation.recordStringLength(super.getValueAsString());
        }

        public String getValueAsString(String def) throws IOException {
            return this.instrumentation.recordStringLength(super.getValueAsString(def));
        }

        public boolean handleSignature(boolean consumeFirstByte, boolean throwException) throws IOException {
            return super.handleSignature(consumeFirstByte, throwException);
        }
    }
}

