/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.serialization;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.async.NonBlockingInputFeeder;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.core.util.RequestPayload;
import com.palantir.conjure.java.serialization.ParserInstrumentation;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import javax.annotation.Nullable;

final class InstrumentedJsonFactory
extends JsonFactory {
    private final ParserInstrumentation instrumentation;

    InstrumentedJsonFactory() {
        this.instrumentation = new ParserInstrumentation(this.getFormatName());
    }

    private InstrumentedJsonFactory(JsonFactoryBuilder builder) {
        this(builder, new ParserInstrumentation("JSON"));
    }

    private InstrumentedJsonFactory(JsonFactoryBuilder builder, ParserInstrumentation instrumentation) {
        super(builder);
        this.instrumentation = instrumentation;
    }

    private InstrumentedJsonFactory(JsonFactory src, @Nullable ObjectCodec codec, ParserInstrumentation instrumentation) {
        super(src, codec);
        this.instrumentation = instrumentation;
    }

    public static JsonFactoryBuilder builder() {
        return new JsonFactoryBuilder(){

            public JsonFactory build() {
                return new InstrumentedJsonFactory(this);
            }
        };
    }

    public JsonFactoryBuilder rebuild() {
        return new JsonFactoryBuilder(this){

            public JsonFactory build() {
                return new InstrumentedJsonFactory(this, InstrumentedJsonFactory.this.instrumentation);
            }
        };
    }

    public JsonFactory copy() {
        return new InstrumentedJsonFactory(this, null, this.instrumentation);
    }

    public String getFormatName() {
        return "JSON";
    }

    protected JsonParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        return this.wrap(super._createParser(in, ctxt));
    }

    protected JsonParser _createParser(Reader reader, IOContext ctxt) throws IOException {
        return this.wrap(super._createParser(reader, ctxt));
    }

    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        return this.wrap(super._createParser(data, offset, len, ctxt, recyclable));
    }

    protected JsonParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        return this.wrap(super._createParser(data, offset, len, ctxt));
    }

    protected JsonParser _createParser(DataInput input, IOContext ctxt) throws IOException {
        return this.wrap(super._createParser(input, ctxt));
    }

    private JsonParser wrap(JsonParser input) {
        if (input == null || input instanceof InstrumentedJsonParser) {
            return input;
        }
        return new InstrumentedJsonParser(input, this.instrumentation);
    }

    private static final class InstrumentedJsonParser
    extends JsonParser {
        private final JsonParser delegate;
        private final ParserInstrumentation instrumentation;

        InstrumentedJsonParser(JsonParser delegate, ParserInstrumentation instrumentation) {
            this.delegate = delegate;
            this.instrumentation = instrumentation;
        }

        public ObjectCodec getCodec() {
            return this.delegate.getCodec();
        }

        public void setCodec(ObjectCodec oc) {
            this.delegate.setCodec(oc);
        }

        public Object getInputSource() {
            return this.delegate.getInputSource();
        }

        public void setRequestPayloadOnError(RequestPayload payload) {
            this.delegate.setRequestPayloadOnError(payload);
        }

        public void setRequestPayloadOnError(byte[] payload, String charset) {
            this.delegate.setRequestPayloadOnError(payload, charset);
        }

        public void setRequestPayloadOnError(String payload) {
            this.delegate.setRequestPayloadOnError(payload);
        }

        public void setSchema(FormatSchema schema) {
            this.delegate.setSchema(schema);
        }

        public FormatSchema getSchema() {
            return this.delegate.getSchema();
        }

        public boolean canUseSchema(FormatSchema schema) {
            return this.delegate.canUseSchema(schema);
        }

        public boolean requiresCustomCodec() {
            return this.delegate.requiresCustomCodec();
        }

        public boolean canParseAsync() {
            return this.delegate.canParseAsync();
        }

        public NonBlockingInputFeeder getNonBlockingInputFeeder() {
            return this.delegate.getNonBlockingInputFeeder();
        }

        public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
            return this.delegate.getReadCapabilities();
        }

        public Version version() {
            return this.delegate.version();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        public JsonStreamContext getParsingContext() {
            return this.delegate.getParsingContext();
        }

        public JsonLocation currentLocation() {
            return this.delegate.currentLocation();
        }

        public JsonLocation currentTokenLocation() {
            return this.delegate.currentTokenLocation();
        }

        public JsonLocation getCurrentLocation() {
            return this.delegate.getCurrentLocation();
        }

        public JsonLocation getTokenLocation() {
            return this.delegate.getTokenLocation();
        }

        public Object currentValue() {
            return this.delegate.currentValue();
        }

        public void assignCurrentValue(Object value) {
            this.delegate.assignCurrentValue(value);
        }

        public Object getCurrentValue() {
            return this.delegate.getCurrentValue();
        }

        public void setCurrentValue(Object value) {
            this.delegate.setCurrentValue(value);
        }

        public int releaseBuffered(OutputStream out) throws IOException {
            return this.delegate.releaseBuffered(out);
        }

        public int releaseBuffered(Writer writer) throws IOException {
            return this.delegate.releaseBuffered(writer);
        }

        public JsonParser enable(JsonParser.Feature feature) {
            this.delegate.enable(feature);
            return this;
        }

        public JsonParser disable(JsonParser.Feature feature) {
            this.delegate.disable(feature);
            return this;
        }

        public JsonParser configure(JsonParser.Feature feature, boolean state) {
            this.delegate.configure(feature, state);
            return this;
        }

        public boolean isEnabled(JsonParser.Feature feature) {
            return this.delegate.isEnabled(feature);
        }

        public boolean isEnabled(StreamReadFeature feature) {
            return this.delegate.isEnabled(feature);
        }

        public int getFeatureMask() {
            return this.delegate.getFeatureMask();
        }

        @Deprecated
        public JsonParser setFeatureMask(int mask) {
            this.delegate.setFeatureMask(mask);
            return this;
        }

        public JsonParser overrideStdFeatures(int values, int mask) {
            this.delegate.overrideStdFeatures(values, mask);
            return this;
        }

        public int getFormatFeatures() {
            return this.delegate.getFormatFeatures();
        }

        public JsonParser overrideFormatFeatures(int values, int mask) {
            this.delegate.overrideFormatFeatures(values, mask);
            return this;
        }

        public JsonToken nextToken() throws IOException {
            return this.delegate.nextToken();
        }

        public JsonToken nextValue() throws IOException {
            return this.delegate.nextValue();
        }

        public boolean nextFieldName(SerializableString str) throws IOException {
            return this.delegate.nextFieldName(str);
        }

        public String nextFieldName() throws IOException {
            return this.delegate.nextFieldName();
        }

        public String nextTextValue() throws IOException {
            return this.instrumentation.recordStringLength(this.delegate.nextTextValue());
        }

        public int nextIntValue(int defaultValue) throws IOException {
            return this.delegate.nextIntValue(defaultValue);
        }

        public long nextLongValue(long defaultValue) throws IOException {
            return this.delegate.nextLongValue(defaultValue);
        }

        public Boolean nextBooleanValue() throws IOException {
            return this.delegate.nextBooleanValue();
        }

        public JsonParser skipChildren() throws IOException {
            this.delegate.skipChildren();
            return this;
        }

        public void finishToken() throws IOException {
            this.delegate.finishToken();
        }

        public JsonToken currentToken() {
            return this.delegate.currentToken();
        }

        public int currentTokenId() {
            return this.delegate.currentTokenId();
        }

        public JsonToken getCurrentToken() {
            return this.delegate.getCurrentToken();
        }

        @Deprecated
        public int getCurrentTokenId() {
            return this.delegate.getCurrentTokenId();
        }

        public boolean hasCurrentToken() {
            return this.delegate.hasCurrentToken();
        }

        public boolean hasTokenId(int id) {
            return this.delegate.hasTokenId(id);
        }

        public boolean hasToken(JsonToken token) {
            return this.delegate.hasToken(token);
        }

        public boolean isExpectedStartArrayToken() {
            return this.delegate.isExpectedStartArrayToken();
        }

        public boolean isExpectedStartObjectToken() {
            return this.delegate.isExpectedStartObjectToken();
        }

        public boolean isExpectedNumberIntToken() {
            return this.delegate.isExpectedNumberIntToken();
        }

        public boolean isNaN() throws IOException {
            return this.delegate.isNaN();
        }

        public void clearCurrentToken() {
            this.delegate.clearCurrentToken();
        }

        public JsonToken getLastClearedToken() {
            return this.delegate.getLastClearedToken();
        }

        public void overrideCurrentName(String name) {
            this.delegate.overrideCurrentName(name);
        }

        public String getCurrentName() throws IOException {
            return this.delegate.getCurrentName();
        }

        public String currentName() throws IOException {
            return this.delegate.currentName();
        }

        public String getText() throws IOException {
            return this.instrumentation.recordStringLength(this.delegate.getText());
        }

        public int getText(Writer writer) throws IOException, UnsupportedOperationException {
            return this.delegate.getText(writer);
        }

        public char[] getTextCharacters() throws IOException {
            return this.delegate.getTextCharacters();
        }

        public int getTextLength() throws IOException {
            return this.delegate.getTextLength();
        }

        public int getTextOffset() throws IOException {
            return this.delegate.getTextOffset();
        }

        public boolean hasTextCharacters() {
            return this.delegate.hasTextCharacters();
        }

        public Number getNumberValue() throws IOException {
            return this.delegate.getNumberValue();
        }

        public Number getNumberValueExact() throws IOException {
            return this.delegate.getNumberValueExact();
        }

        public JsonParser.NumberType getNumberType() throws IOException {
            return this.delegate.getNumberType();
        }

        public byte getByteValue() throws IOException {
            return this.delegate.getByteValue();
        }

        public short getShortValue() throws IOException {
            return this.delegate.getShortValue();
        }

        public int getIntValue() throws IOException {
            return this.delegate.getIntValue();
        }

        public long getLongValue() throws IOException {
            return this.delegate.getLongValue();
        }

        public BigInteger getBigIntegerValue() throws IOException {
            return this.delegate.getBigIntegerValue();
        }

        public float getFloatValue() throws IOException {
            return this.delegate.getFloatValue();
        }

        public double getDoubleValue() throws IOException {
            return this.delegate.getDoubleValue();
        }

        public BigDecimal getDecimalValue() throws IOException {
            return this.delegate.getDecimalValue();
        }

        public boolean getBooleanValue() throws IOException {
            return this.delegate.getBooleanValue();
        }

        public Object getEmbeddedObject() throws IOException {
            return this.delegate.getEmbeddedObject();
        }

        public byte[] getBinaryValue(Base64Variant bv) throws IOException {
            return this.delegate.getBinaryValue(bv);
        }

        public byte[] getBinaryValue() throws IOException {
            return this.delegate.getBinaryValue();
        }

        public int readBinaryValue(OutputStream out) throws IOException {
            return this.delegate.readBinaryValue(out);
        }

        public int readBinaryValue(Base64Variant bv, OutputStream out) throws IOException {
            return this.delegate.readBinaryValue(bv, out);
        }

        public int getValueAsInt() throws IOException {
            return this.delegate.getValueAsInt();
        }

        public int getValueAsInt(int def) throws IOException {
            return this.delegate.getValueAsInt(def);
        }

        public long getValueAsLong() throws IOException {
            return this.delegate.getValueAsLong();
        }

        public long getValueAsLong(long def) throws IOException {
            return this.delegate.getValueAsLong(def);
        }

        public double getValueAsDouble() throws IOException {
            return this.delegate.getValueAsDouble();
        }

        public double getValueAsDouble(double def) throws IOException {
            return this.delegate.getValueAsDouble(def);
        }

        public boolean getValueAsBoolean() throws IOException {
            return this.delegate.getValueAsBoolean();
        }

        public boolean getValueAsBoolean(boolean def) throws IOException {
            return this.delegate.getValueAsBoolean(def);
        }

        public String getValueAsString() throws IOException {
            return this.instrumentation.recordStringLength(this.delegate.getValueAsString());
        }

        public String getValueAsString(String def) throws IOException {
            return this.instrumentation.recordStringLength(this.delegate.getValueAsString(def));
        }

        public boolean canReadObjectId() {
            return this.delegate.canReadObjectId();
        }

        public boolean canReadTypeId() {
            return this.delegate.canReadTypeId();
        }

        public Object getObjectId() throws IOException {
            return this.delegate.getObjectId();
        }

        public Object getTypeId() throws IOException {
            return this.delegate.getTypeId();
        }

        public <T> T readValueAs(Class<T> valueType) throws IOException {
            return (T)this.delegate.readValueAs(valueType);
        }

        public <T> T readValueAs(TypeReference<?> valueTypeRef) throws IOException {
            return (T)this.delegate.readValueAs(valueTypeRef);
        }

        public <T> Iterator<T> readValuesAs(Class<T> valueType) throws IOException {
            return this.delegate.readValuesAs(valueType);
        }

        public <T> Iterator<T> readValuesAs(TypeReference<T> valueTypeRef) throws IOException {
            return this.delegate.readValuesAs(valueTypeRef);
        }

        public <T extends TreeNode> T readValueAsTree() throws IOException {
            return (T)this.delegate.readValueAsTree();
        }

        public ObjectCodec _codec() {
            ObjectCodec codec = this.delegate.getCodec();
            if (codec == null) {
                throw new SafeIllegalStateException("No ObjectCodec defined for parser, needed for deserialization", new Arg[0]);
            }
            return codec;
        }
    }
}

