/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.palantir.conjure.java.lib.Bytes;
import java.io.IOException;
import javax.annotation.Nullable;

public final class BinaryBytesDeserializationModule
extends SimpleModule {
    public BinaryBytesDeserializationModule() {
        super(BinaryBytesDeserializationModule.class.getCanonicalName());
        this.addDeserializer(Object.class, (JsonDeserializer)new BytesObjectDeserializer());
    }

    private static final class BytesObjectDeserializer
    extends UntypedObjectDeserializer {
        BytesObjectDeserializer() {
            super(null, (JavaType)null);
        }

        public Object deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
            Bytes maybeResult = this.maybeDeserializeEmbeddedByteArray(parser);
            if (maybeResult != null) {
                return maybeResult;
            }
            return super.deserialize(parser, ctxt);
        }

        public Object deserialize(JsonParser parser, DeserializationContext ctxt, Object intoValue) throws IOException {
            Bytes maybeResult = this.maybeDeserializeEmbeddedByteArray(parser);
            if (maybeResult != null) {
                return maybeResult;
            }
            return super.deserialize(parser, ctxt, intoValue);
        }

        public Object deserializeWithType(JsonParser parser, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            Bytes maybeResult = this.maybeDeserializeEmbeddedByteArray(parser);
            if (maybeResult != null) {
                return maybeResult;
            }
            return super.deserializeWithType(parser, ctxt, typeDeserializer);
        }

        @Nullable
        private Bytes maybeDeserializeEmbeddedByteArray(JsonParser parser) throws IOException {
            Object object;
            JsonToken token = parser.currentToken();
            if (token == JsonToken.VALUE_EMBEDDED_OBJECT && (object = parser.getEmbeddedObject()) instanceof byte[]) {
                byte[] embeddedBytes = (byte[])object;
                return Bytes.from((byte[])embeddedBytes);
            }
            return null;
        }
    }
}

