/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.dataformat.smile.databind.SmileMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.palantir.conjure.java.jackson.optimizations.ObjectMapperOptimizations;
import com.palantir.conjure.java.serialization.InstrumentedJsonFactory;
import com.palantir.conjure.java.serialization.InstrumentedSmileFactory;
import com.palantir.conjure.java.serialization.LenientLongModule;
import com.palantir.conjure.java.serialization.NonCachingTypeFactory;
import com.palantir.conjure.java.serialization.ShimJdk7Module;

public final class ObjectMappers {
    private ObjectMappers() {
    }

    public static JsonMapper newClientJsonMapper() {
        return (JsonMapper)((JsonMapper.Builder)ObjectMappers.withDefaultModules(JsonMapper.builder((JsonFactory)ObjectMappers.jsonFactory())).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build();
    }

    public static CBORMapper newClientCborMapper() {
        return (CBORMapper)((CBORMapper.Builder)ObjectMappers.withDefaultModules(CBORMapper.builder((CBORFactory)ObjectMappers.cborFactory())).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build();
    }

    public static SmileMapper newClientSmileMapper() {
        return (SmileMapper)((SmileMapper.Builder)ObjectMappers.withDefaultModules(SmileMapper.builder((SmileFactory)ObjectMappers.smileFactory())).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build();
    }

    public static JsonMapper newServerJsonMapper() {
        return (JsonMapper)((JsonMapper.Builder)ObjectMappers.withDefaultModules(JsonMapper.builder((JsonFactory)ObjectMappers.jsonFactory())).enable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build();
    }

    public static CBORMapper newServerCborMapper() {
        return (CBORMapper)((CBORMapper.Builder)ObjectMappers.withDefaultModules(CBORMapper.builder((CBORFactory)ObjectMappers.cborFactory())).enable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build();
    }

    public static SmileMapper newServerSmileMapper() {
        return (SmileMapper)((SmileMapper.Builder)ObjectMappers.withDefaultModules(SmileMapper.builder((SmileFactory)ObjectMappers.smileFactory())).enable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build();
    }

    public static ObjectMapper newClientObjectMapper() {
        return ObjectMappers.newClientJsonMapper();
    }

    public static ObjectMapper newCborClientObjectMapper() {
        return ObjectMappers.newClientCborMapper();
    }

    public static ObjectMapper newSmileClientObjectMapper() {
        return ObjectMappers.newClientSmileMapper();
    }

    public static ObjectMapper newServerObjectMapper() {
        return ObjectMappers.newServerJsonMapper();
    }

    public static ObjectMapper newCborServerObjectMapper() {
        return ObjectMappers.newServerCborMapper();
    }

    public static ObjectMapper newSmileServerObjectMapper() {
        return ObjectMappers.newServerSmileMapper();
    }

    public static <M extends ObjectMapper, B extends MapperBuilder<M, B>> B withDefaultModules(B builder) {
        return (B)builder.typeFactory(NonCachingTypeFactory.from(builder.build().getTypeFactory())).addModule((Module)new GuavaModule()).addModule((Module)new ShimJdk7Module()).addModule((Module)new Jdk8Module().configureAbsentsAsNulls(true)).addModules((Iterable)ObjectMapperOptimizations.createModules()).addModule((Module)new JavaTimeModule()).addModule((Module)new LenientLongModule()).addModule((Module)new JodaModule()).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS}).disable(new SerializationFeature[]{SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS}).disable(new DeserializationFeature[]{DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE}).disable(new DeserializationFeature[]{DeserializationFeature.WRAP_EXCEPTIONS}).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS}).enable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES}).disable(new MapperFeature[]{MapperFeature.ALLOW_COERCION_OF_SCALARS}).disable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_FLOAT_AS_INT});
    }

    public static ObjectMapper withDefaultModules(ObjectMapper mapper) {
        return mapper.setTypeFactory(NonCachingTypeFactory.from(mapper.getTypeFactory())).registerModule((Module)new GuavaModule()).registerModule((Module)new ShimJdk7Module()).registerModule((Module)new Jdk8Module().configureAbsentsAsNulls(true)).registerModules((Iterable)ObjectMapperOptimizations.createModules()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new LenientLongModule()).registerModule((Module)new JodaModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS).disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE).disable(DeserializationFeature.WRAP_EXCEPTIONS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).enable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES).disable(new MapperFeature[]{MapperFeature.ALLOW_COERCION_OF_SCALARS}).disable(DeserializationFeature.ACCEPT_FLOAT_AS_INT);
    }

    public static JsonFactory jsonFactory() {
        return ObjectMappers.withDefaults(InstrumentedJsonFactory.builder()).build();
    }

    public static SmileFactory smileFactory() {
        return ObjectMappers.withDefaults(InstrumentedSmileFactory.builder().disable(SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT)).build();
    }

    public static CBORFactory cborFactory() {
        return ObjectMappers.withDefaults(CBORFactory.builder()).build();
    }

    private static <F extends JsonFactory, B extends TSFBuilder<F, B>> B withDefaults(B builder) {
        return (B)builder.disable(JsonFactory.Feature.INTERN_FIELD_NAMES).disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES).streamReadConstraints(StreamReadConstraints.builder().maxStringLength(50000000).build());
    }
}

