/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.annotations;

import com.palantir.conjure.java.undertow.annotations.CollectionParamDecoder;
import com.palantir.conjure.java.undertow.lib.Deserializer;
import com.palantir.logsafe.Preconditions;
import io.undertow.server.HttpServerExchange;
import java.util.Collections;
import java.util.Deque;

public final class QueryParamDeserializer<T>
implements Deserializer<T> {
    private final String parameter;
    private final CollectionParamDecoder<? extends T> decoder;

    public QueryParamDeserializer(String parameter, CollectionParamDecoder<? extends T> decoder) {
        this.parameter = (String)Preconditions.checkNotNull((Object)parameter, (String)"Query parameter name is required");
        this.decoder = (CollectionParamDecoder)Preconditions.checkNotNull(decoder, (String)"Decoder is required");
    }

    public T deserialize(HttpServerExchange exchange) {
        Deque maybeValues = (Deque)exchange.getQueryParameters().get(this.parameter);
        return (T)Preconditions.checkNotNull(this.decoder.decode(maybeValues == null ? Collections.emptyList() : Collections.unmodifiableCollection(maybeValues)), (String)"Decoder produced a null value");
    }

    public String toString() {
        return "QueryParamDeserializer{parameter='" + this.parameter + "', decoder=" + String.valueOf(this.decoder) + "}";
    }
}

