/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.annotations;

import com.palantir.conjure.java.undertow.annotations.CollectionParamDecoder;
import com.palantir.conjure.java.undertow.lib.Deserializer;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;

public final class FormParamDeserializer<T>
implements Deserializer<T> {
    private static final FormParserFactory FORM_PARSER_FACTORY = FormParserFactory.builder().withDefaultCharset(StandardCharsets.UTF_8.name()).build();
    private final String parameter;
    private final CollectionParamDecoder<? extends T> decoder;

    public FormParamDeserializer(String parameter, CollectionParamDecoder<? extends T> decoder) {
        this.parameter = (String)Preconditions.checkNotNull((Object)parameter, (String)"Form parameter name is required");
        this.decoder = (CollectionParamDecoder)Preconditions.checkNotNull(decoder, (String)"Decoder is required");
    }

    public T deserialize(HttpServerExchange exchange) throws IOException {
        FormDataParser parser = FORM_PARSER_FACTORY.createParser(exchange);
        if (parser == null) {
            throw new SafeIllegalArgumentException("Failed to create form data parser", new Arg[]{SafeArg.of((String)"contentType", (Object)exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE))});
        }
        Deque maybeValues = parser.parseBlocking().get(this.parameter);
        return (T)Preconditions.checkNotNull(this.decoder.decode(this.getValues(maybeValues)), (String)"Decoder produced a null value");
    }

    private Collection<String> getValues(Deque<FormData.FormValue> maybeValues) {
        if (maybeValues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>(maybeValues.size());
        for (FormData.FormValue value : maybeValues) {
            Preconditions.checkArgument((!value.isFileItem() ? 1 : 0) != 0, (String)"Form value was a file item");
            values.add(value.getValue());
        }
        return Collections.unmodifiableCollection(values);
    }

    public String toString() {
        return "QueryParamDeserializer{parameter='" + this.parameter + "', decoder=" + String.valueOf(this.decoder) + "}";
    }
}

