/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.annotations;

import com.palantir.conjure.java.undertow.annotations.DeserializerFactory;
import com.palantir.conjure.java.undertow.annotations.SerializerFactory;
import com.palantir.conjure.java.undertow.lib.BinaryResponseBody;
import com.palantir.conjure.java.undertow.lib.BodySerDe;
import com.palantir.conjure.java.undertow.lib.Deserializer;
import com.palantir.conjure.java.undertow.lib.Endpoint;
import com.palantir.conjure.java.undertow.lib.Serializer;
import com.palantir.conjure.java.undertow.lib.TypeMarker;
import com.palantir.conjure.java.undertow.lib.UndertowRuntime;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Optional;
import javax.annotation.Nullable;

public enum DefaultSerDe implements SerializerFactory<Object>,
DeserializerFactory<Object>
{
    INSTANCE;

    private static final TypeMarker<InputStream> INPUT_STREAM;

    @Override
    public <T> Deserializer<T> deserializer(TypeMarker<T> marker, UndertowRuntime runtime, Endpoint endpoint) {
        if (INPUT_STREAM.getType().equals(marker.getType())) {
            return new BinaryDeserializer(runtime.bodySerDe());
        }
        return runtime.bodySerDe().deserializer(marker, endpoint);
    }

    @Override
    public <T> Serializer<T> serializer(TypeMarker<T> marker, UndertowRuntime runtime, Endpoint endpoint) {
        Type type = marker.getType();
        Serializer<?> maybeSpecialSerializer = this.maybeSpecialSerializer(type, runtime);
        if (maybeSpecialSerializer != null) {
            return maybeSpecialSerializer;
        }
        OptionalDelegatingSerializer delegateSerializer = runtime.bodySerDe().serializer(marker, endpoint);
        return DefaultSerDe.isOptional(marker) ? new OptionalDelegatingSerializer(delegateSerializer) : delegateSerializer;
    }

    private Serializer<?> maybeSpecialSerializer(Type type, UndertowRuntime runtime) {
        Serializer<?> maybeDelegate;
        Type optionalValueType;
        if (Void.class.equals((Object)type)) {
            return VoidSerializer.INSTANCE;
        }
        Class<?> clazz = DefaultSerDe.asClass(type);
        if (clazz != null) {
            if (BinaryResponseBody.class.isAssignableFrom(clazz)) {
                return new BinaryResponseBodySerializer(runtime.bodySerDe());
            }
            if (InputStream.class.isAssignableFrom(clazz)) {
                return new InputStreamBodySerializer(runtime.bodySerDe());
            }
        }
        if ((optionalValueType = DefaultSerDe.unwrapOptional(type)) != null && (maybeDelegate = this.maybeSpecialSerializer(optionalValueType, runtime)) != null) {
            return new OptionalValueDelegatingSerializer(maybeDelegate);
        }
        return null;
    }

    @Nullable
    private static Class<?> asClass(Type type) {
        WildcardType wild;
        Type[] upperBounds;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)type;
            return DefaultSerDe.asClass(param.getRawType());
        }
        if (type instanceof WildcardType && (upperBounds = (wild = (WildcardType)type).getUpperBounds()) != null && upperBounds.length == 1) {
            return DefaultSerDe.asClass(upperBounds[0]);
        }
        return null;
    }

    private static boolean isOptional(TypeMarker<?> marker) {
        return DefaultSerDe.unwrapOptional(marker.getType()) != null;
    }

    private static Type unwrapOptional(Type type) {
        ParameterizedType parameterizedType;
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType().equals(Optional.class)) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new SafeIllegalArgumentException("Expected Optional to have exactly one type argument", new Arg[]{SafeArg.of((String)"typeArguments", (Object)typeArguments)});
            }
            return typeArguments[0];
        }
        return null;
    }

    static {
        INPUT_STREAM = new TypeMarker<InputStream>(){};
    }

    private static final class BinaryDeserializer
    implements Deserializer<InputStream> {
        private final BodySerDe bodySerDe;

        BinaryDeserializer(BodySerDe bodySerDe) {
            this.bodySerDe = bodySerDe;
        }

        public InputStream deserialize(HttpServerExchange exchange) {
            return this.bodySerDe.deserializeInputStream(exchange);
        }
    }

    private static final class OptionalDelegatingSerializer<T>
    implements Serializer<Optional<T>> {
        private final Serializer<Optional<T>> delegate;

        OptionalDelegatingSerializer(Serializer<Optional<T>> delegate) {
            this.delegate = delegate;
        }

        public void serialize(Optional<T> value, HttpServerExchange exchange) throws IOException {
            if (value.isPresent()) {
                this.delegate.serialize(value, exchange);
            } else {
                exchange.setStatusCode(204);
            }
        }
    }

    private static enum VoidSerializer implements Serializer<Void>
    {
        INSTANCE;


        public void serialize(Void _value, HttpServerExchange exchange) {
            exchange.setStatusCode(204);
        }
    }

    private static final class BinaryResponseBodySerializer
    implements Serializer<BinaryResponseBody> {
        private final BodySerDe bodySerDe;

        BinaryResponseBodySerializer(BodySerDe bodySerDe) {
            this.bodySerDe = bodySerDe;
        }

        public void serialize(BinaryResponseBody value, HttpServerExchange exchange) throws IOException {
            this.bodySerDe.serialize(value, exchange);
        }
    }

    private static final class InputStreamBodySerializer
    implements Serializer<InputStream> {
        private final BodySerDe bodySerDe;

        InputStreamBodySerializer(BodySerDe bodySerDe) {
            this.bodySerDe = bodySerDe;
        }

        public void serialize(InputStream value, HttpServerExchange exchange) throws IOException {
            this.bodySerDe.serialize(responseBody -> {
                try (InputStream inputStream = value;){
                    value.transferTo(responseBody);
                }
            }, exchange);
        }
    }

    private static final class OptionalValueDelegatingSerializer<T>
    implements Serializer<Optional<T>> {
        private final Serializer<T> delegate;

        OptionalValueDelegatingSerializer(Serializer<T> delegate) {
            this.delegate = delegate;
        }

        public void serialize(Optional<T> value, HttpServerExchange exchange) throws IOException {
            if (value.isPresent()) {
                this.delegate.serialize(value.get(), exchange);
            } else {
                exchange.setStatusCode(204);
            }
        }
    }
}

