/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.annotations;

import com.palantir.conjure.java.undertow.annotations.ParamDecoder;
import com.palantir.conjure.java.undertow.lib.Deserializer;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import java.io.IOException;

public final class CookieDeserializer<T>
implements Deserializer<T> {
    private final String cookieName;
    private final ParamDecoder<? extends T> decoder;

    public CookieDeserializer(String cookieName, ParamDecoder<? extends T> decoder) {
        this.cookieName = (String)Preconditions.checkNotNull((Object)cookieName, (String)"Cookie name is required");
        this.decoder = (ParamDecoder)Preconditions.checkNotNull(decoder, (String)"Decoder is required");
    }

    public T deserialize(HttpServerExchange exchange) throws IOException {
        Cookie cookie = exchange.getRequestCookie(this.cookieName);
        if (cookie == null) {
            return this.decoder.noValuePresent().orElseThrow(() -> new SafeIllegalArgumentException("Cookie value is required", new Arg[]{SafeArg.of((String)"cookieName", (Object)this.cookieName)}));
        }
        return this.decoder.decode(cookie.getValue());
    }

    public String toString() {
        return "CookieDeserializer{cookieName='" + this.cookieName + "', decoder=" + String.valueOf(this.decoder) + "}";
    }
}

