/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.palantir.logsafe.Preconditions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.util.Set;

final class OptionsHandler
implements HttpHandler {
    private final String allowValue;

    OptionsHandler(Set<HttpString> methods) {
        this.allowValue = Joiner.on((String)", ").join((Iterable)ImmutableSet.builder().add((Object)Methods.OPTIONS).addAll(methods).build());
    }

    public void handleRequest(HttpServerExchange exchange) {
        Preconditions.checkState((boolean)Methods.OPTIONS.equals(exchange.getRequestMethod()), (String)"Expected an OPTIONS request");
        exchange.getResponseHeaders().put(Headers.ALLOW, this.allowValue);
        exchange.setStatusCode(204);
    }
}

